/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.zzu;
import com.google.android.gms.analytics.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.gtm.zzbk;
import com.google.android.gms.internal.gtm.zzbs;
import com.google.android.gms.internal.gtm.zzbu;
import com.google.android.gms.internal.gtm.zzbx;
import com.google.android.gms.internal.gtm.zzch;
import com.google.android.gms.internal.gtm.zzcz;
import com.google.android.gms.internal.gtm.zzfb;
import com.google.android.gms.internal.gtm.zzfd;
import com.google.android.gms.internal.gtm.zzft;
import com.google.android.gms.internal.gtm.zzfu;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

@VisibleForTesting
public class Tracker
extends zzbu {
    private boolean zza;
    private final Map zzb = new HashMap();
    private final Map zzc = new HashMap();
    private final zzfb zzd;
    private final zzv zze;
    @Nullable
    private ExceptionReporter zzf;
    @Nullable
    private zzft zzg;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String get(@Nullable String key) {
        void var1_1;
        this.zzV();
        if (TextUtils.isEmpty((CharSequence)var1_1)) {
            return null;
        }
        if (this.zzb.containsKey(var1_1)) {
            return (String)this.zzb.get(var1_1);
        }
        if (var1_1.equals("&ul")) {
            return zzfu.zzd(Locale.getDefault());
        }
        if (var1_1.equals("&cid")) {
            return this.zzv().zzb();
        }
        if (var1_1.equals("&sr")) {
            return this.zzx().zzb();
        }
        if (var1_1.equals("&aid")) {
            return this.zzu().zza().zzd();
        }
        if (var1_1.equals("&an")) {
            return this.zzu().zza().zzf();
        }
        if (var1_1.equals("&av")) {
            return this.zzu().zza().zzg();
        }
        if (var1_1.equals("&aiid")) {
            return this.zzu().zza().zze();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void enableAdvertisingIdCollection(boolean enabled) {
        void var1_1;
        this.zza = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void enableAutoActivityTracking(boolean enabled) {
        void var1_1;
        this.zze.zzc((boolean)var1_1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableExceptionReporting(boolean enable) {
        synchronized (this) {
            void var1_1;
            ExceptionReporter exceptionReporter = this.zzf;
            boolean bl = exceptionReporter != null;
            if (bl == var1_1) {
                return;
            }
            if (var1_1 != false) {
                Context context = this.zzo();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzf = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzf);
                this.zzN("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(exceptionReporter.zza());
                this.zzN("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(@NonNull Map<String, String> params) {
        String string;
        Map.Entry entry222222;
        String string2;
        long l = this.zzC().currentTimeMillis();
        if (this.zzp().getAppOptOut()) {
            this.zzE("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzp().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzY(this.zzb, hashMap);
        Tracker.zzY((Map)((Object)string2), hashMap);
        string2 = (String)this.zzb.get("useSecure");
        boolean bl2 = string2 != null ? (!string2.equalsIgnoreCase("true") ? (!string2.equalsIgnoreCase("yes") ? (string2.equalsIgnoreCase("1") ? true : (!string2.equalsIgnoreCase("false") ? (!string2.equalsIgnoreCase("no") ? !string2.equalsIgnoreCase("0") : false) : false)) : true) : true) : true;
        Preconditions.checkNotNull(hashMap);
        for (Map.Entry entry222222 : this.zzc.entrySet()) {
            string = Tracker.zzn(entry222222);
            if (string == null || hashMap.containsKey(string)) continue;
            hashMap.put(string, (String)entry222222.getValue());
        }
        this.zzc.clear();
        entry222222 = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)((Object)entry222222))) {
            this.zzz().zzc(hashMap, "Missing hit type parameter");
            return;
        }
        string = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzz().zzc(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zza;
        synchronized (this) {
            boolean bl4 = "screenview".equalsIgnoreCase((String)((Object)entry222222));
            if (bl4 || (bl4 = "pageview".equalsIgnoreCase((String)((Object)entry222222))) || (bl4 = "appview".equalsIgnoreCase((String)((Object)entry222222))) || (bl4 = TextUtils.isEmpty((CharSequence)((Object)entry222222)))) {
                String string3 = (String)this.zzb.get("&a");
                Preconditions.checkNotNull((Object)string3);
                int n = Integer.parseInt(string3);
                if (++n >= Integer.MAX_VALUE) {
                    n = 1;
                }
                this.zzb.put("&a", Integer.toString(n));
            }
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl43 : MonitorExitStatement: MONITOREXIT : this
            this.zzq().zzi(new zzu(this, hashMap, bl3, (String)((Object)entry222222), l, bl, bl2, string));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void set(@NonNull String key, @Nullable String value) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        this.zzb.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setAnonymizeIp(boolean anonymize) {
        void var1_1;
        this.set("&aip", zzfu.zzc((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setAppId(@NonNull String appId) {
        void var1_1;
        this.set("&aid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppInstallerId(@NonNull String appInstallerId) {
        void var1_1;
        this.set("&aiid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppName(@NonNull String appName) {
        void var1_1;
        this.set("&an", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAppVersion(@NonNull String appVersion) {
        void var1_1;
        this.set("&av", (String)var1_1);
    }

    public void setCampaignParamsOnNextHit(@Nullable Uri uri) {
        String string;
        if (uri == null || string.isOpaque()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(string = string.getQueryParameter("referrer")))) {
            return;
        }
        string = String.valueOf(string);
        String string2 = (string = Uri.parse((String)"http://hostname/?".concat(string))).getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzc.put("&ci", string2);
        }
        if ((string2 = string.getQueryParameter("anid")) != null) {
            this.zzc.put("&anid", string2);
        }
        if ((string2 = string.getQueryParameter("utm_campaign")) != null) {
            this.zzc.put("&cn", string2);
        }
        if ((string2 = string.getQueryParameter("utm_content")) != null) {
            this.zzc.put("&cc", string2);
        }
        if ((string2 = string.getQueryParameter("utm_medium")) != null) {
            this.zzc.put("&cm", string2);
        }
        if ((string2 = string.getQueryParameter("utm_source")) != null) {
            this.zzc.put("&cs", string2);
        }
        if ((string2 = string.getQueryParameter("utm_term")) != null) {
            this.zzc.put("&ck", string2);
        }
        if ((string2 = string.getQueryParameter("dclid")) != null) {
            this.zzc.put("&dclid", string2);
        }
        if ((string2 = string.getQueryParameter("gclid")) != null) {
            this.zzc.put("&gclid", string2);
        }
        if ((string = string.getQueryParameter("aclid")) != null) {
            this.zzc.put("&aclid", string);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setClientId(@NonNull String clientId) {
        void var1_1;
        this.set("&cid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEncoding(@NonNull String encoding) {
        void var1_1;
        this.set("&de", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setHostname(@NonNull String hostname) {
        void var1_1;
        this.set("&dh", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLanguage(@NonNull String language) {
        void var1_1;
        this.set("&ul", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setLocation(@NonNull String location) {
        void var1_1;
        this.set("&dl", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPage(@NonNull String page) {
        void var1_1;
        this.set("&dp", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setReferrer(@NonNull String referrer) {
        void var1_1;
        this.set("&dr", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSampleRate(double sampleRate) {
        void var1_1;
        this.set("&sf", Double.toString((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenColors(@NonNull String screenColors) {
        void var1_1;
        this.set("&sd", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenName(@Nullable String screenName) {
        void var1_1;
        this.set("&cd", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenResolution(int width, int height) {
        void var1_1;
        void var2_3;
        if (width < 0 && var2_3 < 0) {
            this.zzQ("Invalid width or height. The values should be non-negative.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((int)var1_1);
        stringBuilder.append("x");
        stringBuilder.append((int)var2_3);
        String string = stringBuilder.toString();
        this.set("&sr", string);
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTimeout(long sessionTimeout) {
        void var1_1;
        this.zze.zze((long)(var1_1 * 1000L));
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(@NonNull String title) {
        void var1_1;
        this.set("&dt", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUseSecure(boolean useSecure) {
        void var1_1;
        this.set("useSecure", zzfu.zzc((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setViewportSize(@NonNull String viewportSize) {
        void var1_1;
        this.set("&vp", (String)var1_1);
    }

    static /* bridge */ /* synthetic */ zzv zza(Tracker tracker) {
        return tracker.zze;
    }

    static /* synthetic */ zzbk zzb(Tracker tracker) {
        return tracker.zzr();
    }

    static /* synthetic */ zzbs zzc(Tracker tracker) {
        return tracker.zzs();
    }

    static /* synthetic */ zzbs zze(Tracker tracker) {
        return tracker.zzs();
    }

    static /* synthetic */ zzch zzf(Tracker tracker) {
        return tracker.zzu();
    }

    static /* synthetic */ zzcz zzg(Tracker tracker) {
        return tracker.zzx();
    }

    static /* synthetic */ zzcz zzh(Tracker tracker) {
        return tracker.zzx();
    }

    static /* bridge */ /* synthetic */ zzfb zzi(Tracker tracker) {
        return tracker.zzd;
    }

    static /* synthetic */ zzfd zzj(Tracker tracker) {
        return tracker.zzz();
    }

    static /* synthetic */ zzfd zzk(Tracker tracker) {
        return tracker.zzz();
    }

    static /* bridge */ /* synthetic */ zzft zzl(Tracker tracker) {
        return tracker.zzg;
    }

    @Nullable
    private static String zzn(Map.Entry entry) {
        String string = (String)entry.getKey();
        if (!string.startsWith("&") || string.length() < 2) {
            return null;
        }
        return ((String)entry.getKey()).substring(1);
    }

    Tracker(zzbx zzbx2, @Nullable String string, @Nullable zzfb zzfb2) {
        super(zzbx2);
        if (string != null) {
            this.zzb.put("&tid", string);
        }
        this.zzb.put("useSecure", "1");
        int n = new Random().nextInt(Integer.MAX_VALUE) + 1;
        this.zzb.put("&a", Integer.toString(n));
        Clock clock = this.zzC();
        this.zzd = new zzfb(60, 2000L, "tracking", clock);
        this.zze = new zzv(this, zzbx2);
    }

    private static void zzY(@Nullable Map object, Map map) {
        Preconditions.checkNotNull((Object)map);
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            String string = Tracker.zzn(entry);
            if (string == null) continue;
            map.put(string, (String)entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzm(zzft zzft2) {
        boolean bl;
        double d;
        this.zzN("Loading Tracker config values");
        this.zzg = zzft2;
        String string = zzft2.zza;
        if (string != null) {
            this.set("&tid", string);
            this.zzO("trackingId loaded", string);
        }
        if ((d = zzft2.zzb) >= 0.0) {
            string = Double.toString(d);
            this.set("&sf", string);
            this.zzO("Sample frequency loaded", string);
        }
        if ((bl = zzft2.zzc) >= false) {
            this.setSessionTimeout((long)bl);
            this.zzO("Session timeout loaded", bl ? 1 : 0);
        }
        if (!(bl = zzft2.zzd)) {
            bl = true == bl;
            this.enableAutoActivityTracking(bl);
            this.zzO("Auto activity tracking loaded", bl);
        }
        if (!(bl = zzft2.zze)) {
            if (bl) {
                this.set("&aip", "1");
            }
            bl = true == bl;
            this.zzO("Anonymize ip loaded", bl);
        }
        boolean bl2 = zzft2.zzf == 1;
        this.enableExceptionReporting(bl2);
    }

    @Override
    protected final void zzd() {
        this.zze.zzW();
        String string = this.zzB().zza();
        if (string != null) {
            this.set("&an", string);
        }
        if ((string = this.zzB().zzb()) != null) {
            this.set("&av", string);
            return;
        }
    }
}

