/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.analytics.ExceptionParser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

@VisibleForTesting
public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet zza = new TreeSet();

    @Nullable
    protected StackTraceElement getBestStackTraceElement(@NonNull Throwable t) {
        int n;
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        if (stackTraceElementArray != null && (n = stackTraceElementArray.length) != 0) {
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                String string = stackTraceElement.getClassName();
                Iterator iterator = this.zza.iterator();
                while (iterator.hasNext()) {
                    if (!string.startsWith((String)iterator.next())) continue;
                    return stackTraceElement;
                }
            }
            return stackTraceElementArray[0];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public String getDescription(@Nullable String threadName, @NonNull Throwable t) {
        void var1_1;
        void var2_2;
        StandardExceptionParser standardExceptionParser = this;
        return standardExceptionParser.getDescription(this.getCause((Throwable)var2_2), standardExceptionParser.getBestStackTraceElement(standardExceptionParser.getCause((Throwable)var2_2)), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    protected String getDescription(@NonNull Throwable cause, @Nullable StackTraceElement element, @Nullable String threadName) {
        void var3_10;
        void var2_9;
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objectArray.getClass().getSimpleName());
        if (var2_9 != null) {
            void var0_3;
            String[] stringArray = var2_9.getClassName().split("\\.");
            objectArray = "unknown";
            if (stringArray != null) {
                int n = stringArray.length;
                if (n > 0) {
                    String string = stringArray[n + -1];
                } else {
                    Object[] objectArray2 = objectArray;
                }
            } else {
                Object[] objectArray3 = objectArray;
            }
            objectArray = new Object[]{var0_3, var2_9.getMethodName(), var2_9.getLineNumber()};
            stringBuilder.append(String.format(" (@%s:%s:%s)", objectArray));
        }
        if (var3_10 != null) {
            Object[] objectArray4 = new Object[]{var3_10};
            stringBuilder.append(String.format(" {%s}", objectArray4));
        }
        return stringBuilder.toString();
    }

    @NonNull
    protected Throwable getCause(@NonNull Throwable t) {
        Throwable throwable;
        while (t.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    /*
     * WARNING - void declaration
     */
    public StandardExceptionParser(@NonNull Context context, @NonNull Collection<String> additionalPackages) {
        void var2_2;
        void var1_1;
        this.setIncludedPackages((Context)var1_1, (Collection<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedPackages(@NonNull Context context, @NonNull Collection<String> additionalPackages) {
        void var1_1;
        Iterator iterator;
        this.zza.clear();
        Object object = new HashSet();
        if (iterator != null) {
            object.addAll(iterator);
        }
        if (var1_1 != null) {
            object.add(var1_1.getApplicationContext().getPackageName());
        }
        iterator = object.iterator();
        block0: while (iterator.hasNext()) {
            object = (String)iterator.next();
            Iterator iterator2 = this.zza.iterator();
            boolean bl = true;
            while (true) {
                block9: {
                    block8: {
                        if (!iterator2.hasNext()) break block8;
                        String string = (String)iterator2.next();
                        if (((String)object).startsWith(string)) break block9;
                        if (string.startsWith((String)object)) {
                            this.zza.remove(string);
                        }
                    }
                    if (!bl) continue block0;
                    this.zza.add(object);
                    continue block0;
                }
                bl = false;
            }
        }
    }
}

