/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzfa;
import com.google.android.gms.internal.gtm.zzfs;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@VisibleForTesting
public class HitBuilders {

    @VisibleForTesting
    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            this.set("&t", "screenview");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setCategory(@RecentlyNonNull String category) {
            void var1_1;
            this.set("&iv", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setCurrencyCode(@RecentlyNonNull String currencyCode) {
            void var1_1;
            this.set("&cu", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setName(@RecentlyNonNull String name) {
            void var1_1;
            this.set("&in", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setPrice(double price) {
            void var1_1;
            this.set("&ip", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setQuantity(long quantity) {
            void var1_1;
            this.set("&iq", Long.toString((long)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setSku(@RecentlyNonNull String sku) {
            void var1_1;
            this.set("&ic", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ItemBuilder setTransactionId(@RecentlyNonNull String transactionid) {
            void var1_1;
            this.set("&ti", (String)var1_1);
            return this;
        }

        public ItemBuilder() {
            this.set("&t", "item");
        }
    }

    @Deprecated
    @VisibleForTesting
    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setAffiliation(@RecentlyNonNull String affiliation) {
            void var1_1;
            this.set("&ta", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setCurrencyCode(@RecentlyNonNull String currencyCode) {
            void var1_1;
            this.set("&cu", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setRevenue(double revenue) {
            void var1_1;
            this.set("&tr", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setShipping(double shipping) {
            void var1_1;
            this.set("&ts", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setTax(double tax) {
            void var1_1;
            this.set("&tt", Double.toString((double)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TransactionBuilder setTransactionId(@RecentlyNonNull String transactionid) {
            void var1_1;
            this.set("&ti", (String)var1_1);
            return this;
        }

        public TransactionBuilder() {
            this.set("&t", "transaction");
        }
    }

    @VisibleForTesting
    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ExceptionBuilder setDescription(@RecentlyNonNull String description) {
            void var1_1;
            this.set("&exd", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public ExceptionBuilder setFatal(boolean fatal) {
            void var1_1;
            this.set("&exf", zzfs.zzc((boolean)var1_1));
            return this;
        }

        public ExceptionBuilder() {
            this.set("&t", "exception");
        }
    }

    @VisibleForTesting
    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TimingBuilder setCategory(@RecentlyNonNull String category) {
            void var1_1;
            this.set("&utc", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TimingBuilder setLabel(@RecentlyNonNull String label) {
            void var1_1;
            this.set("&utl", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TimingBuilder setValue(long value) {
            void var1_1;
            this.set("&utt", Long.toString((long)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public TimingBuilder setVariable(@RecentlyNonNull String variable) {
            void var1_1;
            this.set("&utv", (String)var1_1);
            return this;
        }

        public TimingBuilder() {
            this.set("&t", "timing");
        }

        /*
         * WARNING - void declaration
         */
        public TimingBuilder(@RecentlyNonNull String category, @RecentlyNonNull String variable, long value) {
            this();
            void var1_1;
            void var3_3;
            void var2_2;
            this.setVariable((String)var2_2);
            this.setValue((long)var3_3);
            this.setCategory((String)var1_1);
        }
    }

    @VisibleForTesting
    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public SocialBuilder setAction(@RecentlyNonNull String action) {
            void var1_1;
            this.set("&sa", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public SocialBuilder setNetwork(@RecentlyNonNull String network) {
            void var1_1;
            this.set("&sn", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public SocialBuilder setTarget(@RecentlyNonNull String target) {
            void var1_1;
            this.set("&st", (String)var1_1);
            return this;
        }

        public SocialBuilder() {
            this.set("&t", "social");
        }
    }

    @VisibleForTesting
    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public EventBuilder setAction(@RecentlyNonNull String action) {
            void var1_1;
            this.set("&ea", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public EventBuilder setCategory(@RecentlyNonNull String category) {
            void var1_1;
            this.set("&ec", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public EventBuilder setLabel(@RecentlyNonNull String label) {
            void var1_1;
            this.set("&el", (String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public EventBuilder setValue(long value) {
            void var1_1;
            this.set("&ev", Long.toString((long)var1_1));
            return this;
        }

        public EventBuilder() {
            this.set("&t", "event");
        }

        /*
         * WARNING - void declaration
         */
        public EventBuilder(@RecentlyNonNull String category, @RecentlyNonNull String action) {
            this();
            void var2_2;
            void var1_1;
            this.setCategory((String)var1_1);
            this.setAction((String)var2_2);
        }
    }

    @VisibleForTesting
    protected static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> zze;
        ProductAction zza;
        Map<String, List<Product>> zzb;
        List<Promotion> zzc;
        List<Product> zzd;

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T addImpression(@RecentlyNonNull Product product, @RecentlyNonNull String impressionList) {
            void var1_1;
            String string;
            if (product == null) {
                zzfa.zze("product should be non-null");
                return (T)this;
            }
            if (string == null) {
                string = "";
            }
            if (!this.zzb.containsKey(string)) {
                Map<String, List<Product>> map = this.zzb;
                ArrayList arrayList = new ArrayList();
                map.put(string, arrayList);
            }
            this.zzb.get(string).add((Product)var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T addProduct(@RecentlyNonNull Product product) {
            void var1_1;
            if (product == null) {
                zzfa.zze("product should be non-null");
                return (T)this;
            }
            this.zzd.add((Product)var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T addPromotion(@RecentlyNonNull Promotion promotion) {
            void var1_1;
            if (promotion == null) {
                zzfa.zze("promotion should be non-null");
                return (T)this;
            }
            this.zzc.add((Promotion)var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RecentlyNonNull
        public final T set(@RecentlyNonNull String paramName, @RecentlyNonNull String paramValue) {
            if (paramName != null) {
                void var2_2;
                void var1_1;
                this.zze.put((String)var1_1, (String)var2_2);
                return (T)this;
            }
            zzfa.zze("HitBuilder.set() called with a null paramName.");
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public final T setAll(@RecentlyNonNull Map<String, String> params) {
            void var1_1;
            if (params == null) {
                return (T)this;
            }
            Map<String, String> map = this.zze;
            HashMap hashMap = new HashMap(var1_1);
            map.putAll(hashMap);
            return (T)this;
        }

        /*
         * Unable to fully structure code
         */
        @RecentlyNonNull
        public T setCampaignParamsFromUrl(@RecentlyNonNull String utmParams) {
            block9: {
                if (TextUtils.isEmpty((CharSequence)utmParams)) {
                    var1_1 = null;
lbl3:
                    // 4 sources

                    while (true) {
                        if (TextUtils.isEmpty(var1_1)) {
                            return (T)this;
                        }
                        var1_1 = zzfs.zzf(var1_1);
                        this.zza("&cc", (String)var1_1.get("utm_content"));
                        this.zza("&cm", (String)var1_1.get("utm_medium"));
                        this.zza("&cn", (String)var1_1.get("utm_campaign"));
                        this.zza("&cs", (String)var1_1.get("utm_source"));
                        this.zza("&ck", (String)var1_1.get("utm_term"));
                        this.zza("&ci", (String)var1_1.get("utm_id"));
                        this.zza("&anid", (String)var1_1.get("anid"));
                        this.zza("&gclid", (String)var1_1.get("gclid"));
                        this.zza("&dclid", (String)var1_1.get("dclid"));
                        this.zza("&aclid", (String)var1_1.get("aclid"));
                        this.zza("&gmob_t", (String)var1_1.get("gmob_t"));
                        return (T)this;
                    }
                }
                if (var1_1.contains("?") && ((String[])(var2_3 = var1_1.split("[\\?]"))).length > 1) {
                    var1_1 = var2_3[1];
                }
                if (!var1_1.contains("%3D")) break block9;
                try {
                    var1_1 = URLDecoder.decode((String)var1_1, "UTF-8");
                }
                catch (UnsupportedEncodingException v0) {
                    var1_1 = null;
                    ** continue;
                }
lbl35:
                // 2 sources

                while (true) {
                    var2_3 = zzfs.zzf((String)var1_1);
                    var3_4 = new String[]{"dclid", "utm_source", "gclid", "aclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "anid", "gmob_t"};
                    var4_5 = new StringBuilder();
                    for (var1_2 = 0; var1_2 < 11; ++var1_2) {
                        if (TextUtils.isEmpty((CharSequence)((CharSequence)var2_3.get(var3_4[var1_2])))) continue;
                        if (var4_5.length() > 0) {
                            var4_5.append("&");
                        }
                        var4_5.append(var3_4[var1_2]);
                        var4_5.append("=");
                        var4_5.append((String)var2_3.get(var3_4[var1_2]));
                    }
                    var1_1 = var4_5.toString();
                    ** GOTO lbl3
                    break;
                }
            }
            ** while (var1_1.contains((CharSequence)"="))
lbl55:
            // 1 sources

            var1_1 = null;
            ** GOTO lbl3
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T setCustomDimension(int index, @RecentlyNonNull String dimension) {
            void var2_2;
            void var1_1;
            this.set(com.google.android.gms.analytics.zzd.zza((int)var1_1), (String)var2_2);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T setCustomMetric(int index, float metric) {
            void var2_2;
            void var1_1;
            this.set(com.google.android.gms.analytics.zzd.zzd((int)var1_1), Float.toString((float)var2_2));
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        protected T setHitType(@RecentlyNonNull String hitType) {
            void var1_1;
            this.set("&t", (String)var1_1);
            return (T)this;
        }

        @RecentlyNonNull
        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T setNonInteraction(boolean nonInteraction) {
            void var1_1;
            this.set("&ni", zzfs.zzc((boolean)var1_1));
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T setProductAction(@RecentlyNonNull ProductAction action) {
            void var1_1;
            this.zza = var1_1;
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public T setPromotionAction(@RecentlyNonNull String action) {
            void var1_1;
            this.zze.put("&promoa", (String)var1_1);
            return (T)this;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @RecentlyNonNull
        protected String get(@RecentlyNonNull String paramName) {
            void var1_1;
            return this.zze.get(var1_1);
        }

        /*
         * Enabled aggressive block sorting
         */
        @RecentlyNonNull
        public Map<String, String> build() {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.zze);
            ProductAction productAction = this.zza;
            if (productAction != null) {
                hashMap.putAll(productAction.zza());
            }
            Object object = this.zzc.iterator();
            int n = 1;
            while (object.hasNext()) {
                hashMap.putAll(object.next().zza(com.google.android.gms.analytics.zzd.zzl(n)));
                ++n;
            }
            object = this.zzd.iterator();
            n = 1;
            while (object.hasNext()) {
                hashMap.putAll(((Product)object.next()).zza(com.google.android.gms.analytics.zzd.zzj(n)));
                ++n;
            }
            Iterator<Map.Entry<String, List<Product>>> iterator = this.zzb.entrySet().iterator();
            int n2 = 1;
            while (iterator.hasNext()) {
                Map.Entry<String, List<Product>> entry = iterator.next();
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzd.zzg(n2);
                Iterator<Product> iterator2 = list.iterator();
                n = 1;
                while (iterator2.hasNext()) {
                    Product product = iterator2.next();
                    object = String.valueOf(string);
                    String string2 = String.valueOf(com.google.android.gms.analytics.zzd.zzi(n));
                    if (string2.length() != 0) {
                        object = ((String)object).concat(string2);
                    } else {
                        string2 = new String((String)object);
                        object = string2;
                    }
                    hashMap.putAll(product.zza((String)object));
                    ++n;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(String.valueOf(string).concat("nm"), entry.getKey());
                }
                ++n2;
            }
            return hashMap;
        }

        protected HitBuilder() {
            Cloneable cloneable = new Cloneable();
            this.zze = cloneable;
            cloneable = new Cloneable();
            this.zzb = cloneable;
            this.zzc = cloneable;
            super();
            this.zzd = cloneable;
        }

        private final T zza(String string, String string2) {
            if (string2 != null) {
                this.zze.put(string, string2);
            }
            return (T)this;
        }
    }
}

