/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzatk;
import com.google.android.gms.internal.zzatm;
import com.google.android.gms.internal.zzatt;
import com.google.android.gms.internal.zzcyz;

public final class zzatl<T extends Context> {
    private final Handler mHandler;
    private final T zzeej;
    private static Boolean zzeek;

    @Hide
    public zzatl(T t) {
        zzbq.checkNotNull(t);
        this.zzeej = t;
        this.mHandler = new Handler();
    }

    @Hide
    public static boolean zzbn(Context context) {
        zzbq.checkNotNull((Object)context);
        if (zzeek != null) {
            return zzeek;
        }
        boolean bl = zzatt.zzp(context, "com.google.android.gms.analytics.AnalyticsService");
        zzeek = bl;
        return bl;
    }

    @Hide
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onCreate() {
        zzark.zzbl(this.zzeej).zzxy().zzea("Local AnalyticsService is starting up");
    }

    @Hide
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onDestroy() {
        zzark.zzbl(this.zzeej).zzxy().zzea("Local AnalyticsService is shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final int onStartCommand(Intent intent, int n, int n2) {
        try {
            Object object = zzatk.sLock;
            synchronized (object) {
                zzcyz zzcyz2 = zzatk.zzeei;
                if (zzcyz2 != null && zzcyz2.isHeld()) {
                    zzcyz2.release();
                }
            }
        }
        catch (SecurityException securityException) {}
        zzatd zzatd2 = zzark.zzbl(this.zzeej).zzxy();
        if (intent == null) {
            zzatd2.zzed("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzatd2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzark zzark2 = zzark.zzbl(this.zzeej);
        zzatd zzatd2 = zzark2.zzxy();
        zzark2.zzyc().zza(new zzatm(this, n, zzark2, zzatd2, jobParameters));
    }

    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzatd zzatd2 = zzark.zzbl(this.zzeej).zzxy();
        String string = jobParameters.getExtras().getString("action");
        zzatd2.zza("Local AnalyticsJobService called. action", (Object)string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    static /* synthetic */ Context zza(zzatl zzatl2) {
        return zzatl2.zzeej;
    }

    static /* synthetic */ Handler zzb(zzatl zzatl2) {
        return zzatl2.mHandler;
    }
}

