/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.RemoteException;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarp;
import com.google.android.gms.internal.zzarq;
import com.google.android.gms.internal.zzasf;
import com.google.android.gms.internal.zzasl;
import com.google.android.gms.internal.zzasn;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzasz;
import com.google.android.gms.internal.zzatp;
import java.util.Collections;
import java.util.List;

@Hide
public final class zzaro
extends zzari {
    private final zzarq zzdzm;
    private zzasz zzdzn;
    private final zzasn zzdzo;
    private final zzatp zzdzp;

    protected zzaro(zzark zzark2) {
        super(zzark2);
        this.zzdzp = new zzatp(zzark2.zzxx());
        this.zzdzm = new zzarq(this);
        this.zzdzo = new zzarp(this, zzark2);
    }

    @Override
    protected final void zzwk() {
    }

    public final boolean isConnected() {
        zzk.zzwj();
        this.zzyk();
        return this.zzdzn != null;
    }

    public final boolean zzb(zzasy zzasy2) {
        zzbq.checkNotNull((Object)zzasy2);
        zzk.zzwj();
        this.zzyk();
        zzasz zzasz2 = this.zzdzn;
        if (zzasz2 == null) {
            return false;
        }
        String string = zzasy2.zzaap() ? zzasl.zzaab() : zzasl.zzaac();
        List<zzasf> list = Collections.emptyList();
        try {
            zzasz2.zza(zzasy2.zzjq(), zzasy2.zzaan(), string, list);
            this.zzyw();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzea("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public final boolean zzyv() {
        zzk.zzwj();
        this.zzyk();
        zzasz zzasz2 = this.zzdzn;
        if (zzasz2 == null) {
            return false;
        }
        try {
            zzasz2.zzxr();
            this.zzyw();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzea("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private final void zzyw() {
        this.zzdzp.start();
        this.zzdzo.zzs(zzast.zzecv.get());
    }

    public final boolean connect() {
        zzk.zzwj();
        this.zzyk();
        if (this.zzdzn != null) {
            return true;
        }
        zzasz zzasz2 = this.zzdzm.zzyy();
        if (zzasz2 != null) {
            this.zzdzn = zzasz2;
            this.zzyw();
            return true;
        }
        return false;
    }

    private final void zza(zzasz zzasz2) {
        zzk.zzwj();
        this.zzdzn = zzasz2;
        this.zzyw();
        this.zzyc().onServiceConnected();
    }

    public final void disconnect() {
        zzk.zzwj();
        this.zzyk();
        try {
            zza.zzanm();
            zzarq zzarq2 = this.zzdzm;
            Context context = this.getContext();
            context.unbindService((ServiceConnection)zzarq2);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzdzn != null) {
            this.zzdzn = null;
            this.zzyc().zzxu();
        }
    }

    private final void onServiceDisconnected(ComponentName componentName) {
        zzk.zzwj();
        if (this.zzdzn != null) {
            this.zzdzn = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.zzyc().zzxu();
        }
    }

    private final void zzyx() {
        zzk.zzwj();
        if (!this.isConnected()) {
            return;
        }
        this.zzea("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    static /* synthetic */ zzarq zza(zzaro zzaro2) {
        return zzaro2.zzdzm;
    }

    static /* synthetic */ void zza(zzaro zzaro2, zzasz zzasz2) {
        zzaro2.zza(zzasz2);
    }

    static /* synthetic */ void zza(zzaro zzaro2, ComponentName componentName) {
        zzaro2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ void zzb(zzaro zzaro2) {
        zzaro2.zzyx();
    }
}

