/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqm;
import com.google.android.gms.internal.zzaqn;
import com.google.android.gms.internal.zzaqo;
import com.google.android.gms.internal.zzaqp;
import com.google.android.gms.internal.zzaqq;
import com.google.android.gms.internal.zzaqr;
import com.google.android.gms.internal.zzaqs;
import com.google.android.gms.internal.zzaqt;
import com.google.android.gms.internal.zzaqu;
import com.google.android.gms.internal.zzaqv;
import com.google.android.gms.internal.zzaqw;
import com.google.android.gms.internal.zzaqx;
import com.google.android.gms.internal.zzarh;
import com.google.android.gms.internal.zzarj;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarn;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzatt;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Hide
public final class zzb
extends zzarh
implements zzo {
    private static DecimalFormat zzdua;
    private final zzark zzdtw;
    private final String zzdub;
    private final Uri zzduc;

    public zzb(zzark zzark2, String string) {
        this(zzark2, string, true, false);
    }

    private zzb(zzark zzark2, String string, boolean bl, boolean bl2) {
        super(zzark2);
        zzbq.zzgv((String)string);
        this.zzdtw = zzark2;
        this.zzdub = string;
        this.zzduc = zzb.zzdl(this.zzdub);
    }

    static Uri zzdl(String string) {
        zzbq.zzgv((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzvu() {
        return this.zzduc;
    }

    @Override
    public final void zzb(zzg zzg2) {
        zzbq.checkNotNull((Object)zzg2);
        zzbq.checkArgument((boolean)zzg2.zzwb(), (Object)"Can't deliver not submitted measurement");
        zzbq.zzgw((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzvx();
        zzaqu zzaqu2 = zzg3.zzb(zzaqu.class);
        if (TextUtils.isEmpty((CharSequence)zzaqu2.zzxd())) {
            this.zzxy().zzf(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzaqu2.zzxe())) {
            this.zzxy().zzf(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzdtw.zzyn().getAppOptOut()) {
            return;
        }
        double d = zzaqu2.zzxj();
        if (zzatt.zza(d, zzaqu2.zzxe())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzarj.zzdyr);
        map.put("tid", this.zzdub);
        if (this.zzdtw.zzyn().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzatt.zzb(hashMap, "uid", zzaqu2.getUserId());
        zzaql zzaql2 = zzg2.zza(zzaql.class);
        if (zzaql2 != null) {
            zzatt.zzb(hashMap, "an", zzaql2.zzwn());
            zzatt.zzb(hashMap, "aid", zzaql2.getAppId());
            zzatt.zzb(hashMap, "av", zzaql2.zzwo());
            zzatt.zzb(hashMap, "aiid", zzaql2.zzwp());
        }
        zzarn zzarn2 = new zzarn(0L, zzaqu2.zzxe(), this.zzdub, !TextUtils.isEmpty((CharSequence)zzaqu2.zzxf()), 0L, hashMap);
        long l = this.zzyc().zza(zzarn2);
        map.put("_s", String.valueOf(l));
        zzasy zzasy2 = new zzasy(this.zzxy(), map, zzg2.zzvz(), true);
        this.zzyc().zza(zzasy2);
    }

    @Hide
    private static Map<String, String> zzc(zzg zzg2) {
        zzaql zzaql2;
        zzaqo zzaqo2;
        Object object;
        Object object2;
        Object object3;
        zzaqn zzaqn2;
        zzaqx zzaqx2;
        zzaqw zzaqw2;
        zzaqt zzaqt2;
        zzaqm zzaqm2;
        zzaqs zzaqs2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzaqp zzaqp2 = zzg2.zza(zzaqp.class);
        if (zzaqp2 != null) {
            object5 = zzaqp2.zzwy().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zzb((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzaqs2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzaqs2));
            }
        }
        if ((object5 = zzg2.zza(zzaqu.class)) != null) {
            zzb.zza(hashMap, "t", ((zzaqu)object5).zzxd());
            zzb.zza(hashMap, "cid", ((zzaqu)object5).zzxe());
            zzb.zza(hashMap, "uid", ((zzaqu)object5).getUserId());
            zzb.zza(hashMap, "sc", ((zzaqu)object5).zzxh());
            zzb.zza(hashMap, "sf", ((zzaqu)object5).zzxj());
            zzb.zza(hashMap, "ni", ((zzaqu)object5).zzxi());
            zzb.zza(hashMap, "adid", ((zzaqu)object5).zzxf());
            zzb.zza(hashMap, "ate", ((zzaqu)object5).zzxg());
        }
        if ((object4 = zzg2.zza(zzaqv.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzaqv)object4).zzxk());
            zzb.zza(hashMap, "a", ((zzaqv)object4).zzxl());
            zzb.zza(hashMap, "dr", ((zzaqv)object4).zzxm());
        }
        if ((zzaqs2 = zzg2.zza(zzaqs.class)) != null) {
            zzb.zza(hashMap, "ec", zzaqs2.getCategory());
            zzb.zza(hashMap, "ea", zzaqs2.getAction());
            zzb.zza(hashMap, "el", zzaqs2.getLabel());
            zzb.zza(hashMap, "ev", zzaqs2.getValue());
        }
        if ((zzaqm2 = zzg2.zza(zzaqm.class)) != null) {
            zzb.zza(hashMap, "cn", zzaqm2.getName());
            zzb.zza(hashMap, "cs", zzaqm2.getSource());
            zzb.zza(hashMap, "cm", zzaqm2.zzwq());
            zzb.zza(hashMap, "ck", zzaqm2.zzwr());
            zzb.zza(hashMap, "cc", zzaqm2.getContent());
            zzb.zza(hashMap, "ci", zzaqm2.getId());
            zzb.zza(hashMap, "anid", zzaqm2.zzws());
            zzb.zza(hashMap, "gclid", zzaqm2.zzwt());
            zzb.zza(hashMap, "dclid", zzaqm2.zzwu());
            zzb.zza(hashMap, "aclid", zzaqm2.zzwv());
        }
        if ((zzaqt2 = zzg2.zza(zzaqt.class)) != null) {
            zzb.zza(hashMap, "exd", zzaqt2.zzdxh);
            zzb.zza(hashMap, "exf", zzaqt2.zzdxi);
        }
        if ((zzaqw2 = zzg2.zza(zzaqw.class)) != null) {
            zzb.zza(hashMap, "sn", zzaqw2.zzdxw);
            zzb.zza(hashMap, "sa", zzaqw2.zzdxe);
            zzb.zza(hashMap, "st", zzaqw2.zzdxx);
        }
        if ((zzaqx2 = zzg2.zza(zzaqx.class)) != null) {
            zzb.zza(hashMap, "utv", zzaqx2.zzdxy);
            zzb.zza(hashMap, "utt", zzaqx2.zzdxz);
            zzb.zza(hashMap, "utc", zzaqx2.mCategory);
            zzb.zza(hashMap, "utl", zzaqx2.zzdxf);
        }
        if ((zzaqn2 = zzg2.zza(zzaqn.class)) != null) {
            object3 = zzaqn2.zzww().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zzaj(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzaqo2 = zzg2.zza(zzaqo.class)) != null) {
            object2 = zzaqo2.zzwx().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zzal((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzaqr.class)) != null) {
            object2 = ((zzaqr)object3).zzwz();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzaqr)object3).zzxc()) {
                hashMap.putAll(promotion.zzdx(zzd.zzap(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzaqr)object3).zzxa()) {
                hashMap.putAll(product.zzdx(zzd.zzan(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzaqr)object3).zzxb().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzas(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzaq(n2));
                    hashMap.putAll(product.zzdx(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzaqq.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzaqq)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzaqq)object2).zzdxb);
            zzb.zza(hashMap, "sr", ((zzaqq)object2).zzcly, ((zzaqq)object2).zzclz);
            zzb.zza(hashMap, "vp", ((zzaqq)object2).zzdxc, ((zzaqq)object2).zzdxd);
        }
        if ((zzaql2 = zzg2.zza(zzaql.class)) != null) {
            zzb.zza(hashMap, "an", zzaql2.zzwn());
            zzb.zza(hashMap, "aid", zzaql2.getAppId());
            zzb.zza(hashMap, "aiid", zzaql2.zzwp());
            zzb.zza(hashMap, "av", zzaql2.zzwo());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    @Hide
    private static String zzb(double d) {
        if (zzdua == null) {
            zzdua = new DecimalFormat("0.######");
        }
        return zzdua.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

