/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgks;
import com.google.android.gms.internal.ads.zzgpp;
import com.google.android.gms.internal.ads.zzgpy;
import com.google.android.gms.internal.ads.zzguo;
import com.google.android.gms.internal.ads.zzgvh;
import com.google.android.gms.internal.ads.zzgvm;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzgvi
implements zzgpy {
    private static final ThreadLocal zza = new zzgvh();
    private final SecretKey zzb;
    private final byte[] zzc;
    private final byte[] zzd;

    private static Cipher zzb() throws GeneralSecurityException {
        if (!zzgks.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return (Cipher)zza.get();
    }

    public zzgvi(byte[] byArray) throws GeneralSecurityException {
        zzgvm.zza(byArray.length);
        String string2 = "AES";
        this.zzb = new SecretKeySpec(byArray, string2);
        Cipher cipher = zzgvi.zzb();
        cipher.init(1, this.zzb);
        this.zzc = zzgpp.zza(cipher.doFinal(new byte[16]));
        this.zzd = zzgpp.zza(this.zzc);
    }

    private static void zzc(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        for (int i = 0; i < 16; ++i) {
            int n2 = i;
            byArray3[n2] = (byte)(byArray[i] ^ byArray2[n2 + n]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        Object object;
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        SecretKey secretKey = ((zzgvi)object).zzb;
        Cipher cipher = zzgvi.zzb();
        cipher.init(1, secretKey);
        int n2 = byArray.length;
        int n3 = n2 == 0 ? 1 : (n2 + -1 >> 4) + 1;
        int n4 = n3 + -1;
        int n5 = n4 * 16;
        if (n3 * 16 == n2) {
            object = zzguo.zzc(byArray, n5, ((zzgvi)object).zzc, 0, 16);
        } else {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5, n2);
            if ((n2 = byArray2.length) >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byArray2 = Arrays.copyOf(byArray2, 16);
            byArray2[n2] = -128;
            object = ((zzgvi)object).zzd;
            if (byArray2.length != 16) {
                throw new IllegalArgumentException("The lengths of x and y should match.");
            }
            object = zzguo.zzc(byArray2, 0, (byte[])object, 0, 16);
        }
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < n4; ++i) {
            zzgvi.zzc(byArray3, byArray, i * 16, byArray4);
            if (cipher.doFinal(byArray4, 0, 16, byArray3) == 16) continue;
            throw new IllegalStateException("Cipher didn't write full block");
        }
        zzgvi.zzc(byArray3, (byte[])object, 0, byArray4);
        if (cipher.doFinal(byArray4, 0, 16, byArray3) != 16) {
            throw new IllegalStateException("Cipher didn't write full block");
        }
        if (n == 16) {
            return byArray3;
        }
        return Arrays.copyOf(byArray3, n);
    }
}

