/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgdn;
import com.google.android.gms.internal.ads.zzgdw;
import com.google.android.gms.internal.ads.zzggr;
import com.google.android.gms.internal.ads.zzgjo;
import com.google.android.gms.internal.ads.zzgks;
import com.google.android.gms.internal.ads.zzgnu;
import com.google.android.gms.internal.ads.zzgvf;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgjp
implements zzgdn {
    private static final byte[] zza = zzgvf.zza("808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9f");
    private static final byte[] zzb = zzgvf.zza("070000004041424344454647");
    private static final byte[] zzc = zzgvf.zza("a0784d7a4716f3feb4f64e7f4b39bf04");
    private static final ThreadLocal zzd = new zzgjo();
    private final SecretKey zze;
    private final byte[] zzf;

    public static zzgdn zzb(zzggr zzggr2) throws GeneralSecurityException {
        return new zzgjp(zzggr2.zzd().zzd(zzgdw.zza()), zzggr2.zzc().zzc());
    }

    @Nullable
    static Cipher zzc() {
        return (Cipher)zzd.get();
    }

    private zzgjp(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (!zzgks.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzgjp.zze()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        String string2 = "ChaCha20";
        this.zze = new SecretKeySpec(byArray, string2);
        this.zzf = byArray2;
    }

    static /* bridge */ /* synthetic */ boolean zzd(Cipher cipher) {
        return zzgjp.zzf(cipher);
    }

    public static boolean zze() {
        return zzd.get() != null;
    }

    private static boolean zzf(Cipher cipher) {
        IvParameterSpec ivParameterSpec;
        block3: {
            try {
                ivParameterSpec = new IvParameterSpec(zzb);
                cipher.init(2, (Key)new SecretKeySpec(zza, "ChaCha20"), ivParameterSpec);
                int n = cipher.doFinal(zzc).length;
                if (n == 0) break block3;
                return false;
            }
            catch (GeneralSecurityException generalSecurityException) {
                return false;
            }
        }
        cipher.init(2, (Key)new SecretKeySpec(zza, "ChaCha20"), ivParameterSpec);
        int n = cipher.doFinal(zzc).length;
        return n == 0;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        int n = byArray.length;
        Object object = this.zzf;
        if (n < ((byte[])object).length + 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzgnu.zzc(object, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        object = new byte[12];
        System.arraycopy(byArray, this.zzf.length, object, 0, 12);
        IvParameterSpec ivParameterSpec = new IvParameterSpec((byte[])object);
        object = (Cipher)zzd.get();
        object.init(2, (Key)this.zze, ivParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            object.updateAAD(byArray2);
        }
        int n2 = this.zzf.length;
        return object.doFinal(byArray, n2 + 12, n - n2 + -12);
    }
}

