/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzasy;
import com.google.android.gms.internal.ads.zzfni;
import com.google.android.gms.internal.ads.zzfnk;
import com.google.android.gms.internal.ads.zzfnq;
import com.google.android.gms.internal.ads.zzfnv;
import com.google.android.gms.internal.ads.zzfnw;
import com.google.android.gms.internal.ads.zzfnx;
import com.google.android.gms.internal.ads.zzfny;
import com.google.android.gms.internal.ads.zzfnz;
import com.google.android.gms.internal.ads.zzfoa;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfob {
    private final Context zza;
    private final Executor zzb;
    private final zzfni zzc;
    private final zzfnk zzd;
    private final zzfoa zze;
    private final zzfoa zzf;
    private Task zzg;
    private Task zzh;

    public final zzasy zza() {
        zzfoa zzfoa2 = this.zze;
        return zzfob.zzg(this.zzg, zzfoa2.zza());
    }

    public final zzasy zzb() {
        zzfoa zzfoa2 = this.zzf;
        return zzfob.zzg(this.zzh, zzfoa2.zza());
    }

    private static zzasy zzg(@NonNull Task task, @NonNull zzasy zzasy2) {
        if (!task.isSuccessful()) {
            return zzasy2;
        }
        return (zzasy)((Object)task.getResult());
    }

    final /* synthetic */ zzasy zzc() throws Exception {
        zzasc zzasc2 = zzasy.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfob)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzasc2.zzs((String)object);
            zzasc2.zzr(info.isLimitAdTrackingEnabled());
            zzasc2.zzab(6);
        }
        return (zzasy)zzasc2.zzbn();
    }

    final /* synthetic */ zzasy zzd() throws Exception {
        zzfob zzfob2 = zzfob2.zza;
        PackageInfo packageInfo = zzfob2.getPackageManager().getPackageInfo(zzfob2.getPackageName(), 0);
        zzfob zzfob3 = zzfob2;
        return zzfnq.zza((Context)zzfob3, zzfob3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfob zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfni zzfni2, @NonNull zzfnk zzfnk2) {
        zzfob zzfob2 = new zzfob(context, executor, zzfni2, zzfnk2, new zzfny(), new zzfnz());
        if (zzfob2.zzd.zzh()) {
            zzfob zzfob3 = zzfob2;
            zzfob3.zzg = zzfob3.zzh(new zzfnv(zzfob3));
        } else {
            zzfob2.zzg = Tasks.forResult((Object)((Object)zzfob2.zze.zza()));
        }
        zzfob zzfob4 = zzfob2;
        zzfob4.zzh = zzfob4.zzh(new zzfnw(zzfob4));
        return zzfob2;
    }

    private final Task zzh(@NonNull Callable object) {
        Task task = Tasks.call((Executor)this.zzb, (Callable)object);
        object = new zzfnx(this);
        return task.addOnFailureListener(this.zzb, (OnFailureListener)object);
    }

    @VisibleForTesting
    zzfob(Context context, Executor executor, zzfni zzfni2, zzfnk zzfnk2, zzfny zzfny2, zzfnz zzfnz2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfni2;
        this.zzd = zzfnk2;
        this.zze = zzfny2;
        this.zzf = zzfnz2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

