/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.internal.ClientApi;
import com.google.android.gms.ads.internal.client.zzcf;
import com.google.android.gms.ads.internal.client.zze;
import com.google.android.gms.ads.internal.client.zzft;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzbpe;
import com.google.android.gms.internal.ads.zzcvm;
import com.google.android.gms.internal.ads.zzfjc;
import com.google.android.gms.internal.ads.zzfjg;
import com.google.android.gms.internal.ads.zzfjp;
import com.google.android.gms.internal.ads.zzfjx;
import com.google.android.gms.internal.ads.zzfjy;
import com.google.android.gms.internal.ads.zzfjz;
import com.google.android.gms.internal.ads.zzfka;
import com.google.android.gms.internal.ads.zzfkb;
import com.google.android.gms.internal.ads.zzfkc;
import com.google.android.gms.internal.ads.zzfkd;
import com.google.android.gms.internal.ads.zzfke;
import com.google.android.gms.internal.ads.zzfkf;
import com.google.android.gms.internal.ads.zzfkg;
import com.google.android.gms.internal.ads.zzgcd;
import com.google.android.gms.internal.ads.zzgch;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class zzfkh {
    protected final ClientApi zza;
    protected final Context zzb;
    protected final int zzc;
    protected final zzbpe zzd;
    protected zzft zze;
    protected final AtomicBoolean zzf;
    private final zzcf zzg;
    private final ConcurrentLinkedQueue zzh;
    private final zzfjg zzi;
    private final AtomicBoolean zzj;
    private final ScheduledExecutorService zzk;
    private final AtomicBoolean zzl;
    private final AtomicBoolean zzm;
    private zzfjp zzn;
    private final Clock zzo;

    public final synchronized zzfkh zzc() {
        zzfjy zzfjy2 = new zzfjy(this);
        this.zzk.submit(zzfjy2);
        return this;
    }

    protected abstract ListenableFuture zza();

    @Nullable
    protected final synchronized Object zzd() {
        zzfjx zzfjx2 = (zzfjx)((zzfkh)((Object)zzfjx2)).zzh.peek();
        if (zzfjx2 == null) {
            return null;
        }
        return zzfjx2.zzb();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final synchronized Object zze() {
        this.zzi.zzc();
        zzfjx zzfjx2 = (zzfjx)this.zzh.poll();
        boolean bl = zzfjx2 != null;
        this.zzm.set(bl);
        this.zzl();
        if (zzfjx2 == null) {
            return null;
        }
        return zzfjx2.zzb();
    }

    protected abstract Optional zzb(Object var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized Optional zzf() {
        Object object;
        Object object2 = ((zzfkh)object).zzd();
        if (object2 == null) {
            object = Optional.empty();
            return zzfkh.zzD((Optional)object);
        }
        object = ((zzfkh)object).zzb(object2);
        return zzfkh.zzD((Optional)object);
    }

    public static /* synthetic */ void zzg(zzfkh zzfkh2) {
        zzfkh2.zzx();
    }

    public static /* synthetic */ void zzh(zzfkh zzfkh2) {
        zzfkh2.zzy();
    }

    static /* bridge */ /* synthetic */ void zzi(zzfkh zzfkh2, Throwable throwable) {
        zzfkh2.zzv(throwable);
    }

    static /* bridge */ /* synthetic */ void zzj(zzfkh zzfkh2, Object object) {
        zzfkh2.zzw(object);
    }

    static /* bridge */ /* synthetic */ void zzk(zzfkh zzfkh2, zze zze2) {
        zzfkh2.zzA(zze2);
    }

    public zzfkh(ClientApi clientApi, Context context, int n, zzbpe zzbpe2, @NonNull zzft zzft2, @NonNull zzcf zzcf2, @NonNull ScheduledExecutorService scheduledExecutorService, zzfjg zzfjg2, Clock clock) {
        this.zza = clientApi;
        this.zzb = context;
        this.zzc = n;
        this.zzd = zzbpe2;
        this.zze = zzft2;
        this.zzg = zzcf2;
        this.zzh = new ConcurrentLinkedQueue();
        this.zzf = new AtomicBoolean(true);
        this.zzj = new AtomicBoolean(false);
        this.zzk = scheduledExecutorService;
        this.zzi = zzfjg2;
        this.zzl = new AtomicBoolean(true);
        this.zzm = new AtomicBoolean(false);
        this.zzo = clock;
    }

    private final synchronized void zzu(Object object) {
        zzfjx zzfjx2 = new zzfjx(object, this.zzo);
        this.zzh.add(zzfjx2);
        object = this.zzb(object);
        long l = this.zzo.currentTimeMillis();
        zzs.zza.post((Runnable)new zzfkc(this));
        zzfkd zzfkd2 = new zzfkd(this, l, (Optional)object);
        this.zzk.execute(zzfkd2);
        object = new zzfjy(this);
        l = zzfjx2.zza();
        this.zzk.schedule((Runnable)object, l, TimeUnit.MILLISECONDS);
    }

    protected final synchronized void zzl() {
        this.zzB();
        this.zzz();
        if (this.zzj.get() || !this.zzf.get() || this.zzh.size() >= this.zze.zzd) {
            return;
        }
        this.zzj.set(true);
        zzgch.zzr((ListenableFuture)this.zza(), (zzgcd)new zzfkg(this), (Executor)this.zzk);
    }

    private final synchronized void zzv(Throwable throwable) {
        this.zzj.set(false);
        if (throwable instanceof zzfjc && ((zzfjc)throwable).zza() == 0) {
            throw null;
        }
        this.zzC(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final synchronized void zzw(Object object) {
        this.zzj.set(false);
        if (object != null) {
            this.zzi.zzc();
            this.zzm.set(true);
            this.zzu(object);
        }
        boolean bl = object == null;
        this.zzC(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void zzx() {
        if (!this.zzl.get()) return;
        try {
            this.zzg.zze(this.zze);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"Failed to call onAdsAvailable");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void zzy() {
        if (!this.zzl.get()) return;
        try {
            this.zzg.zzf(this.zze);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"Failed to call onAdsExhausted");
            return;
        }
    }

    final /* synthetic */ void zzm(long l, Optional optional) {
        zzfjp zzfjp2 = this.zzn;
        if (zzfjp2 != null) {
            zzfjp2.zzb(AdFormat.getAdFormat((int)this.zze.zzb), l, zzfkh.zzD(optional));
            return;
        }
    }

    final /* synthetic */ void zzn() {
        zzfjp zzfjp2 = this.zzn;
        if (zzfjp2 != null) {
            zzfjp2.zzc(AdFormat.getAdFormat((int)this.zze.zzb), this.zzo.currentTimeMillis());
            return;
        }
    }

    private final synchronized void zzz() {
        if (this.zzm.get() && this.zzh.isEmpty()) {
            this.zzm.set(false);
            zzs.zza.post((Runnable)new zzfke(this));
            this.zzk.execute(new zzfkf(this));
            return;
        }
    }

    private final synchronized void zzA(zze zze2) {
        this.zzj.set(false);
        switch (zze2.zza) {
            default: {
                this.zzC(true);
                return;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
        }
        zzft zzft2 = this.zze;
        int n = zzft2.zzb;
        String string2 = zzft2.zza;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Preloading ");
        stringBuilder.append(n);
        stringBuilder.append(", for adUnitId:");
        stringBuilder.append(string2);
        stringBuilder.append(", Ad load failed. Stop preloading due to non-retriable error:");
        com.google.android.gms.ads.internal.util.client.zzo.zzi((String)stringBuilder.toString());
        this.zzf.set(false);
    }

    private final synchronized void zzB() {
        Iterator iterator = ((zzfkh)((Object)iterator)).zzh.iterator();
        while (iterator.hasNext()) {
            if (!((zzfjx)iterator.next()).zzc()) continue;
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final synchronized void zzo(int n) {
        boolean bl = n >= 5;
        Preconditions.checkArgument((boolean)bl);
        this.zzi.zzd(n);
    }

    public final synchronized void zzp() {
        this.zzf.set(true);
        this.zzl.set(true);
        zzfjy zzfjy2 = new zzfjy(this);
        this.zzk.submit(zzfjy2);
    }

    public final void zzq(zzfjp zzfjp2) {
        this.zzn = zzfjp2;
    }

    private final synchronized void zzC(boolean bl) {
        if (!this.zzi.zze()) {
            if (bl) {
                this.zzi.zzb();
            }
            this.zzk.schedule(new zzfjy(this), this.zzi.zza(), TimeUnit.MILLISECONDS);
            return;
        }
    }

    public final void zzr() {
        this.zzf.set(false);
        this.zzl.set(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final synchronized void zzs(int n) {
        zzft zzft2;
        boolean bl = n > 0;
        Preconditions.checkArgument((boolean)bl);
        zzft zzft3 = this.zze;
        String string2 = zzft3.zza;
        int n2 = zzft3.zzb;
        zzm zzm2 = zzft3.zzc;
        if (n <= 0) {
            n = zzft3.zzd;
        }
        this.zze = zzft2 = new zzft(string2, n2, zzm2, n);
    }

    public final synchronized boolean zzt() {
        this.zzB();
        return !this.zzh.isEmpty();
    }

    private static final Optional zzD(Optional object) {
        Class<zzcvm> clazz = zzcvm.class;
        Objects.requireNonNull(clazz);
        Optional optional = ((Optional)object).filter(new zzfjz(clazz));
        object = zzcvm.class;
        Objects.requireNonNull(object);
        return optional.map(new zzfka((Class)object)).map(new zzfkb());
    }
}

