/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.ConnectivityManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.client.zzby;
import com.google.android.gms.ads.internal.client.zzcf;
import com.google.android.gms.ads.internal.client.zzft;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzbad;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbpe;
import com.google.android.gms.internal.ads.zzbwp;
import com.google.android.gms.internal.ads.zzfjp;
import com.google.android.gms.internal.ads.zzfjr;
import com.google.android.gms.internal.ads.zzfjs;
import com.google.android.gms.internal.ads.zzfjt;
import com.google.android.gms.internal.ads.zzfju;
import com.google.android.gms.internal.ads.zzfkh;
import com.google.android.gms.internal.ads.zzfki;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzfjv {
    private final ConcurrentMap zza = new ConcurrentHashMap();
    private final ConcurrentMap zzb = new ConcurrentHashMap();
    private final zzfki zzc;
    private final zzfjp zzd;
    private final Context zze;
    @Nullable
    private volatile ConnectivityManager zzf;
    private final Clock zzg;
    private AtomicInteger zzh;

    @Nullable
    public final synchronized zzbad zza(String string2) {
        AdFormat adFormat = AdFormat.APP_OPEN_AD;
        return this.zzp(zzbad.class, string2, adFormat).orElse(null);
    }

    @Nullable
    public final synchronized zzby zzb(String string2) {
        AdFormat adFormat = AdFormat.INTERSTITIAL;
        return this.zzp(zzby.class, string2, adFormat).orElse(null);
    }

    @Nullable
    public final synchronized zzbwp zzc(String string2) {
        AdFormat adFormat = AdFormat.REWARDED;
        return this.zzp(zzbwp.class, string2, adFormat).orElse(null);
    }

    @Nullable
    private final synchronized zzfkh zzn(String string2, AdFormat adFormat) {
        return (zzfkh)this.zza.get(zzfjv.zzd(string2, adFormat));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static String zzd(String string2, @Nullable AdFormat object) {
        void var1_3;
        if (object == null) {
            String string3 = "NULL";
        } else {
            String string4 = object.name();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("#");
        stringBuilder.append((String)var1_3);
        return stringBuilder.toString();
    }

    private final synchronized List zzo(List iterator) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (zzft)iterator.next();
            String string2 = zzfjv.zzd(((zzft)object).zza, AdFormat.getAdFormat((int)((zzft)object).zzb));
            hashSet.add(string2);
            zzfkh zzfkh2 = (zzfkh)((zzfjv)((Object)iterator2)).zza.get(string2);
            if (zzfkh2 != null) {
                if (!zzfkh2.zze.equals(object)) {
                    ((zzfjv)((Object)iterator2)).zzb.put(string2, zzfkh2);
                    ((zzfjv)((Object)iterator2)).zza.remove(string2);
                    continue;
                }
                zzfkh2.zzs(((zzft)object).zzd);
                continue;
            }
            if (((zzfjv)((Object)iterator2)).zzb.containsKey(string2)) {
                zzfkh2 = (zzfkh)((zzfjv)((Object)iterator2)).zzb.get(string2);
                if (!zzfkh2.zze.equals(object)) continue;
                zzfkh2.zzs(((zzft)object).zzd);
                zzfkh2.zzp();
                ((zzfjv)((Object)iterator2)).zza.put(string2, zzfkh2);
                ((zzfjv)((Object)iterator2)).zzb.remove(string2);
                continue;
            }
            arrayList.add(object);
        }
        iterator = ((zzfjv)((Object)iterator2)).zza.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (hashSet.contains((String)object.getKey())) continue;
            ((zzfjv)((Object)iterator2)).zzb.put((String)object.getKey(), (zzfkh)object.getValue());
            iterator.remove();
        }
        Iterator iterator2 = ((zzfjv)((Object)iterator2)).zzb.entrySet().iterator();
        while (iterator2.hasNext()) {
            zzfkh zzfkh3 = (zzfkh)((Map.Entry)iterator2.next()).getValue();
            zzfkh3.zzr();
            if (zzfkh3.zzt()) continue;
            iterator2.remove();
        }
        return arrayList;
    }

    private final synchronized Optional zzp(Class object, String optional, AdFormat adFormat) {
        long l = this.zzg.currentTimeMillis();
        this.zzd.zzd(adFormat, l);
        optional = this.zzn((String)((Object)optional), adFormat);
        if (optional == null) {
            return Optional.empty();
        }
        try {
            Optional optional2 = ((zzfkh)((Object)optional)).zzf();
            Optional<Object> optional3 = Optional.ofNullable(((zzfkh)((Object)optional)).zze());
            Objects.requireNonNull(object);
            optional = optional3.map(new zzfjr((Class)object));
            optional.ifPresent(new zzfjs(this, adFormat, optional2));
            return optional;
        }
        catch (ClassCastException classCastException) {
            optional = "PreloadAdManager.pollAd";
            zzv.zzp().zzw(classCastException, (String)((Object)optional));
            object = String.valueOf(((Class)object).getName());
            com.google.android.gms.ads.internal.util.zze.zzb("Unable to cast ad to the requested type:".concat((String)object), classCastException);
            return Optional.empty();
        }
    }

    static /* bridge */ /* synthetic */ void zze(zzfjv zzfjv2, boolean bl) {
        zzfjv2.zzr(bl);
    }

    static /* bridge */ /* synthetic */ void zzf(zzfjv zzfjv2, boolean bl) {
        zzfjv2.zzs(bl);
    }

    zzfjv(zzfki zzfki2, zzfjp zzfjp2, Context context, Clock clock) {
        this.zzc = zzfki2;
        this.zzd = zzfjp2;
        this.zze = context;
        this.zzg = clock;
    }

    final /* synthetic */ void zzg(AdFormat adFormat, Optional optional, Object object) {
        long l = this.zzg.currentTimeMillis();
        this.zzd.zze(adFormat, l, optional);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzh() {
        ConnectivityManager connectivityManager;
        if (this.zzf == null) {
            synchronized (this) {
                connectivityManager = this.zzf;
                if (connectivityManager == null) {
                    try {
                        this.zzf = (ConnectivityManager)this.zze.getSystemService("connectivity");
                    }
                    catch (ClassCastException classCastException) {
                        String string2 = "Failed to get connectivity manager";
                        zzo.zzk((String)string2, (Throwable)classCastException);
                    }
                }
            }
        }
        if (!PlatformVersion.isAtLeastO() || this.zzf == null) {
            connectivityManager = zzbcl.zzy;
            this.zzh = new AtomicInteger((Integer)zzbe.zzc().zza((zzbcc)connectivityManager));
            return;
        }
        try {
            this.zzf.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)new zzfju(this));
            return;
        }
        catch (RuntimeException runtimeException) {
            zzo.zzk((String)"Failed to register network callback", (Throwable)runtimeException);
            zzbcc zzbcc2 = zzbcl.zzy;
            this.zzh = new AtomicInteger((Integer)zzbe.zzc().zza(zzbcc2));
            return;
        }
    }

    public final void zzi(zzbpe zzbpe2) {
        this.zzc.zzb(zzbpe2);
    }

    public final synchronized void zzj(List enumMap, zzcf zzcf2) {
        List list = this.zzo((List)((Object)enumMap));
        enumMap = new EnumMap<AdFormat, Integer>(AdFormat.class);
        for (Object object : list) {
            String string2 = ((zzft)object).zza;
            AdFormat adFormat = AdFormat.getAdFormat((int)((zzft)object).zzb);
            object = this.zzc.zza((zzft)object, zzcf2);
            if (adFormat == null || object == null) continue;
            AtomicInteger atomicInteger = this.zzh;
            if (atomicInteger != null) {
                ((zzfkh)object).zzo(atomicInteger.get());
            }
            ((zzfkh)object).zzq(this.zzd);
            this.zzq(zzfjv.zzd(string2, adFormat), (zzfkh)object);
            EnumMap<AdFormat, Integer> enumMap2 = enumMap;
            AdFormat adFormat2 = adFormat;
            enumMap2.put(adFormat2, enumMap2.getOrDefault(adFormat2, 0) + 1);
        }
        this.zzd.zzf(enumMap, this.zzg.currentTimeMillis());
        zzv.zzb().zzc(new zzfjt(this));
    }

    private final synchronized void zzq(String string2, zzfkh zzfkh2) {
        zzfkh2.zzc();
        this.zza.put(string2, zzfkh2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final synchronized void zzr(boolean bl) {
        Iterator iterator;
        if (bl) {
            iterator = ((zzfjv)((Object)iterator)).zza.values().iterator();
            while (iterator.hasNext()) {
                ((zzfkh)iterator.next()).zzp();
            }
            return;
        } else {
            iterator = ((zzfjv)((Object)iterator)).zza.values().iterator();
            while (iterator.hasNext()) {
                ((zzfkh)iterator.next()).zzf.set(false);
            }
        }
    }

    private final synchronized void zzs(boolean bl) {
        zzbcc zzbcc2 = zzbcl.zzt;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
            this.zzr(bl);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final synchronized boolean zzt(String string2, AdFormat adFormat) {
        void var3_7;
        long l = ((zzfjv)((Object)optional)).zzg.currentTimeMillis();
        zzfkh zzfkh2 = ((zzfjv)((Object)optional)).zzn(string2, adFormat);
        boolean bl = zzfkh2 != null ? zzfkh2.zzt() : false;
        if (bl) {
            Optional<Long> optional = Optional.of(((zzfjv)((Object)optional)).zzg.currentTimeMillis());
        } else {
            Optional optional = Optional.empty();
        }
        zzfjp zzfjp2 = ((zzfjv)((Object)optional)).zzd;
        Optional optional = zzfkh2 == null ? Optional.empty() : zzfkh2.zzf();
        zzfjp2.zza(adFormat, l, (Optional)var3_7, optional);
        return bl;
    }

    public final synchronized boolean zzk(String string2) {
        return this.zzt(string2, AdFormat.APP_OPEN_AD);
    }

    public final synchronized boolean zzl(String string2) {
        return this.zzt(string2, AdFormat.INTERSTITIAL);
    }

    public final synchronized boolean zzm(String string2) {
        return this.zzt(string2, AdFormat.REWARDED);
    }
}

