/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzeb;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbmb;
import com.google.android.gms.internal.ads.zzbmf;
import com.google.android.gms.internal.ads.zzcaj;
import com.google.android.gms.internal.ads.zzcqz;
import com.google.android.gms.internal.ads.zzdia;
import com.google.android.gms.internal.ads.zzdif;
import com.google.android.gms.internal.ads.zzdml;
import java.util.Collections;

public final class zzdmm
extends zzbmb
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbfi {
    private View zza;
    private zzeb zzb;
    private zzdia zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzeb zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbft zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdmm)((Object)zzdia2)).zzd) {
            zzo.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdia zzdia2 = ((zzdmm)((Object)zzdia2)).zzc;
        if (zzdia2 != null && zzdia2.zzc() != null) {
            return zzdia2.zzc().zza();
        }
        return null;
    }

    public zzdmm(zzdia zzdia2, zzdif zzdif2) {
        this.zza = zzdif2.zzf();
        this.zzb = zzdif2.zzj();
        this.zzc = zzdia2;
        this.zzd = false;
        this.zze = false;
        if (zzdif2.zzs() != null) {
            zzdif2.zzs().zzap(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdia zzdia2 = this.zzc;
        if (zzdia2 != null) {
            ((zzcqz)zzdia2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdia zzdia2 = this.zzc;
        if (zzdia2 != null && (view = this.zza) != null) {
            zzdia2.zzB(view, Collections.emptyMap(), Collections.emptyMap(), zzdia.zzY(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbmf)new zzdml(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbmf zzbmf2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdmm)((Object)string2)).zzd) {
            zzo.zzg((String)"Instream ad can not be shown after destroy().");
            zzdmm.zzi(zzbmf2, 2);
            return;
        }
        View view = ((zzdmm)((Object)string2)).zza;
        if (view == null || ((zzdmm)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzo.zzg((String)"Instream internal error: ".concat(string2));
            zzdmm.zzi(zzbmf2, 0);
            return;
        }
        if (((zzdmm)((Object)string2)).zze) {
            zzo.zzg((String)"Instream ad should not be used again.");
            zzdmm.zzi(zzbmf2, 1);
            return;
        }
        ((zzdmm)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdmm)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzv.zzy();
        zzcaj.zza(((zzdmm)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzv.zzy();
        zzcaj.zzb(((zzdmm)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbmf2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbmf zzbmf2, int n) {
        try {
            zzbmf2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzo.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

