/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzbe;
import com.google.android.gms.ads.internal.util.client.zzo;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzbcc;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbda;
import com.google.android.gms.internal.ads.zzbzw;
import com.google.android.gms.internal.ads.zzcaw;
import com.google.android.gms.internal.ads.zzcax;
import com.google.android.gms.internal.ads.zzcay;
import com.google.android.gms.internal.ads.zzcaz;
import com.google.android.gms.internal.ads.zzcba;
import com.google.android.gms.internal.ads.zzcbb;
import com.google.android.gms.internal.ads.zzcbc;
import com.google.android.gms.internal.ads.zzcbd;
import com.google.android.gms.internal.ads.zzcbe;
import com.google.android.gms.internal.ads.zzcbf;
import com.google.android.gms.internal.ads.zzcbk;
import com.google.android.gms.internal.ads.zzcbr;
import com.google.android.gms.internal.ads.zzcbs;
import com.google.android.gms.internal.ads.zzcbt;
import com.google.android.gms.internal.ads.zzcbu;
import com.google.android.gms.internal.ads.zzcck;
import com.google.android.gms.internal.ads.zzcem;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzcbg
extends FrameLayout
implements zzcax {
    private final zzcbs zzb;
    private final FrameLayout zzc;
    private final View zzd;
    private final zzbda zze;
    @VisibleForTesting
    final zzcbu zza;
    private final long zzf;
    @Nullable
    private final zzcay zzg;
    private boolean zzh;
    private boolean zzi;
    private boolean zzj;
    private boolean zzk;
    private long zzl;
    private long zzm;
    private String zzn;
    private String[] zzo;
    private Bitmap zzp;
    private final ImageView zzq;
    private boolean zzr;

    @Nullable
    public final Integer zzl() {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 != null) {
            return zzcay2.zzw();
        }
        return null;
    }

    static /* bridge */ /* synthetic */ void zzm(zzcbg zzcbg2, String string2, String[] stringArray) {
        zzcbg2.zzK(string2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzcbg(Context context, zzcbs object, int n, boolean bl, zzbda zzbda2, zzcbr zzcbr2) {
        super(context);
        boolean bl2;
        this.zzb = object;
        this.zze = zzbda2;
        this.zzc = new FrameLayout(context);
        zzcbg zzcbg2 = this;
        zzcbg2.addView((View)zzcbg2.zzc, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)object.zzj());
        zzcaz cfr_ignored_0 = object.zzj().zza;
        zzcbt zzcbt2 = new zzcbt(context, object.zzn(), object.zzs(), zzbda2, object.zzk());
        if (n == 3) {
            object = new zzcem(context, zzcbt2);
        } else if (n == 2) {
            Object object2 = object;
            object = new zzcck(context, zzcbt2, (zzcbs)object2, bl, zzcbk.zza((zzcbs)object2), zzcbr2);
        } else {
            Object object3 = object;
            object = new zzcaw(context, (zzcbs)object3, bl, zzcbk.zza((zzcbs)object3), zzcbr2, new zzcbt(context, object.zzn(), object.zzs(), zzbda2, object.zzk()));
        }
        this.zzg = object;
        this.zzd = new View(context);
        this.zzd.setBackgroundColor(0);
        object = this.zzg;
        if (object != null) {
            this.zzc.addView((View)object, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            object = zzbcl.zzS;
            if (((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) {
                this.zzc.addView(this.zzd, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.zzc.bringChildToFront(this.zzd);
            }
            object = zzbcl.zzP;
            if (((Boolean)zzbe.zzc().zza((zzbcc)object)).booleanValue()) {
                this.zzn();
            }
        }
        this.zzq = new ImageView(context);
        context = zzbcl.zzU;
        this.zzf = (Long)zzbe.zzc().zza((zzbcc)context);
        context = zzbcl.zzR;
        this.zzk = bl2 = ((Boolean)zzbe.zzc().zza((zzbcc)context)).booleanValue();
        object = this.zze;
        if (object != null) {
            String string2 = true != bl2 ? "0" : "1";
            ((zzbda)object).zzd("spinner_used", string2);
        }
        this.zza = new zzcbu(this);
        zzcay zzcay2 = this.zzg;
        if (zzcay2 != null) {
            zzcay2.zzr(this);
        }
        if (this.zzg == null) {
            this.zzb("AdVideoUnderlay Error", "Allocating player failed.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzn() {
        Object object = this.zzg;
        if (object == null) {
            return;
        }
        object = object.getContext();
        TextView textView = new TextView((Context)object);
        object = zzv.zzp().zze();
        object = object == null ? "AdMob - " : object.getString(R.string.watermark_label_prefix);
        zzcay zzcay2 = this.zzg;
        textView.setText((CharSequence)String.valueOf(object).concat(zzcay2.zzj()));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzc.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzc.bringChildToFront((View)textView);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzJ() {
        if (this.zzb.zzi() == null || !this.zzi || this.zzj) {
            return;
        }
        this.zzb.zzi().getWindow().clearFlags(128);
        this.zzi = false;
    }

    public final void zzo() {
        this.zza.zza();
        zzcay zzcay2 = this.zzg;
        if (zzcay2 != null) {
            zzcay2.zzt();
        }
        this.zzJ();
    }

    public final void finalize() throws Throwable {
        block3: {
            zzcay zzcay2;
            try {
                this.zza.zza();
                zzcay2 = this.zzg;
                if (zzcay2 == null) break block3;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            Objects.requireNonNull(zzcay2);
            zzbzw.zzf.execute((Runnable)new zzcba(zzcay2));
        }
        super.finalize();
    }

    final /* synthetic */ void zzp() {
        this.zzK("firstFrameRendered", new String[0]);
    }

    final /* synthetic */ void zzq(boolean bl) {
        String string2 = "hasWindowFocus";
        String[] stringArray = new String[]{string2, String.valueOf(bl)};
        this.zzK("windowFocusChanged", stringArray);
    }

    public final void zzr(Integer n) {
        if (this.zzg == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzn)) {
            this.zzg.zzC(this.zzn, this.zzo, n);
            return;
        }
        this.zzK("no_src", new String[0]);
    }

    public final void zzs() {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzb.zzd(true);
        zzcay2.zzn();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzt() {
        long l;
        zzcay zzcay2 = this.zzg;
        if (zzcay2 == null || this.zzl == (l = (long)zzcay2.zza()) || l <= 0L) {
            return;
        }
        float f = l;
        String[] stringArray = zzbcl.zzbY;
        f /= 1000.0f;
        if (((Boolean)zzbe.zzc().zza((zzbcc)stringArray)).booleanValue()) {
            stringArray = "time";
            String[] stringArray2 = new String[]{stringArray, String.valueOf(f), "totalBytes", String.valueOf(this.zzg.zzh()), "qoeCachedBytes", String.valueOf(this.zzg.zzf()), "qoeLoadedBytes", String.valueOf(this.zzg.zzg()), "droppedFrames", String.valueOf(this.zzg.zzb()), "reportTime", String.valueOf(zzv.zzC().currentTimeMillis())};
            this.zzK("timeupdate", stringArray2);
        } else {
            stringArray = new String[]{"time", String.valueOf(f)};
            this.zzK("timeupdate", stringArray);
        }
        this.zzl = l;
    }

    @Override
    public final void zza() {
        zzbcc zzbcc2 = zzbcl.zzca;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
            this.zza.zza();
        }
        this.zzK("ended", new String[0]);
        this.zzJ();
    }

    @Override
    public final void zzb(String string2, @Nullable String string3) {
        String string4 = "what";
        String[] stringArray = new String[]{string4, string2, "extra", string3};
        this.zzK("error", stringArray);
    }

    @Override
    public final void zzc(String string2, @Nullable String string3) {
        string2 = "what";
        String[] stringArray = new String[]{string2, "ExoPlayerAdapter exception", "extra", string3};
        this.zzK("exception", stringArray);
    }

    @Override
    public final void zzd() {
        this.zzK("pause", new String[0]);
        this.zzJ();
        this.zzh = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zze() {
        zzbcc zzbcc2 = zzbcl.zzca;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
            this.zza.zzb();
        }
        if (this.zzb.zzi() != null && !this.zzi) {
            boolean bl = (this.zzb.zzi().getWindow().getAttributes().flags & 0x80) != 0;
            this.zzj = bl;
            if (!bl) {
                this.zzb.zzi().getWindow().addFlags(128);
                this.zzi = true;
            }
        }
        this.zzh = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzf() {
        zzcay zzcay2 = this.zzg;
        if (zzcay2 == null || this.zzm != 0L) {
            return;
        }
        float f = zzcay2.zzc();
        zzcay zzcay3 = this.zzg;
        String string2 = "duration";
        int n = zzcay3.zze();
        String[] stringArray = new String[]{string2, String.valueOf(f / 1000.0f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(zzcay3.zzd())};
        this.zzK("canplaythrough", stringArray);
    }

    @Override
    public final void zzg() {
        this.zzd.setVisibility(4);
        zzs.zza.post((Runnable)new zzcbb(this));
    }

    @Override
    public final void zzh() {
        this.zza.zzb();
        zzs.zza.post((Runnable)new zzcbd(this));
    }

    @Override
    public final void zzi() {
        if (this.zzr && this.zzp != null && !this.zzL()) {
            this.zzq.setImageBitmap(this.zzp);
            this.zzq.invalidate();
            this.zzc.addView((View)this.zzq, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzc.bringChildToFront((View)this.zzq);
        }
        this.zza.zza();
        this.zzm = this.zzl;
        zzs.zza.post((Runnable)new zzcbe(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzj(int n, int n2) {
        block3: {
            block2: {
                if (!this.zzk) break block2;
                zzbcc zzbcc2 = zzbcl.zzT;
                n = Math.max(n / (Integer)zzbe.zzc().zza(zzbcc2), 1);
                zzbcc2 = zzbcl.zzT;
                n2 = Math.max(n2 / (Integer)zzbe.zzc().zza(zzbcc2), 1);
                zzbcc2 = this.zzp;
                if (zzbcc2 == null || zzbcc2.getWidth() != n || this.zzp.getHeight() != n2) break block3;
            }
            return;
        }
        this.zzp = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.zzr = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzk() {
        long l;
        block7: {
            block6: {
                if (((zzcbg)((Object)zzbda2)).zzh && ((zzcbg)((Object)zzbda2)).zzL()) {
                    ((zzcbg)((Object)zzbda2)).zzc.removeView((View)((zzcbg)((Object)zzbda2)).zzq);
                }
                if (((zzcbg)((Object)zzbda2)).zzg == null || ((zzcbg)((Object)zzbda2)).zzp == null) break block6;
                long l2 = zzv.zzC().elapsedRealtime();
                if (((zzcbg)((Object)zzbda2)).zzg.getBitmap(((zzcbg)((Object)zzbda2)).zzp) != null) {
                    ((zzcbg)((Object)zzbda2)).zzr = true;
                }
                l = zzv.zzC().elapsedRealtime() - l2;
                if (com.google.android.gms.ads.internal.util.zze.zzc()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Spinner frame grab took ");
                    stringBuilder.append(l);
                    stringBuilder.append("ms");
                    com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
                }
                if (l <= ((zzcbg)((Object)zzbda2)).zzf) break block6;
                com.google.android.gms.ads.internal.util.client.zzo.zzj((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                ((zzcbg)((Object)zzbda2)).zzk = false;
                ((zzcbg)((Object)zzbda2)).zzp = null;
                zzbda zzbda2 = ((zzcbg)((Object)zzbda2)).zze;
                if (zzbda2 != null) break block7;
            }
            return;
        }
        zzbda2.zzd("spinner_jank", Long.toString(l));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zza.zzb();
        } else {
            this.zza.zza();
            this.zzm = this.zzl;
        }
        zzs.zza.post((Runnable)new zzcbc(this, bl));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zza.zzb();
            n = 1;
        } else {
            this.zza.zza();
            this.zzm = this.zzl;
            n = 0;
        }
        zzs.zza.post((Runnable)new zzcbf(this, n != 0));
    }

    public final void zzu() {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzo();
    }

    public final void zzv() {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzp();
    }

    public final void zzw(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzq(n);
    }

    public final void zzx(MotionEvent motionEvent) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.dispatchTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzK(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Integer n = this.zzl();
        if (n != null) {
            hashMap.put("playerId", n.toString());
        }
        hashMap.put("event", string2);
        int n2 = stringArray.length;
        string2 = null;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.zzb.zzd("onVideoEvent", hashMap);
                return;
            }
            String string3 = stringArray[n3];
            if (string2 == null) {
                string2 = string3;
            } else {
                hashMap.put(string2, string3);
                string2 = null;
            }
            ++n3;
        }
    }

    public final void zzy(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzx(n);
    }

    public final void zzz(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzy(n);
    }

    public final void zzA(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzz(n);
    }

    public final void zzB(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzA(n);
    }

    public final void zzC(int n) {
        zzbcc zzbcc2 = zzbcl.zzS;
        if (((Boolean)zzbe.zzc().zza(zzbcc2)).booleanValue()) {
            this.zzc.setBackgroundColor(n);
            this.zzd.setBackgroundColor(n);
            return;
        }
    }

    public final void zzD(int n) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzB(n);
    }

    public final void zzE(String string2, String[] stringArray) {
        this.zzn = string2;
        this.zzo = stringArray;
    }

    public final void zzF(int n, int n2, int n3, int n4) {
        if (com.google.android.gms.ads.internal.util.zze.zzc()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Set video bounds to x:");
            stringBuilder.append(n);
            stringBuilder.append(";y:");
            stringBuilder.append(n2);
            stringBuilder.append(";w:");
            stringBuilder.append(n3);
            stringBuilder.append(";h:");
            stringBuilder.append(n4);
            com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzG(float f) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzb.zze(f);
        zzcay2.zzn();
    }

    public final void zzH(float f, float f2) {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 != null) {
            zzcay2.zzu(f, f2);
            return;
        }
    }

    public final void zzI() {
        zzcay zzcay2 = ((zzcbg)((Object)zzcay2)).zzg;
        if (zzcay2 == null) {
            return;
        }
        zzcay2.zzb.zzd(false);
        zzcay2.zzn();
    }

    private final boolean zzL() {
        return this.zzq.getParent() != null;
    }
}

