/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgjd;
import com.google.android.gms.internal.ads.zzgji;
import com.google.android.gms.internal.ads.zzgjl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.AEADBadTagException;

abstract class zzgjf {
    private final zzgjd zza;
    private final zzgjd zzb;

    abstract zzgjd zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzgjf(byte[] byArray) throws GeneralSecurityException {
        if (!zzgjl.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        this.zza = this.zza(byArray, 1);
        this.zzb = this.zza(byArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] zzb(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byteBuffer.remaining() < 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        int n = byteBuffer.position();
        byte[] byArray3 = new byte[16];
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.position(byteBuffer2.limit() + -16);
        byteBuffer.get(byArray3);
        byteBuffer.position(n);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer3.limit(byteBuffer3.limit() + -16);
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        try {
            byte[] byArray4 = new byte[32];
            this.zzb.zzc(byArray, 0).get(byArray4);
            int n2 = byArray2.length;
            int n3 = n2 & 0xF;
            n3 = n3 == 0 ? n2 : n2 + 16 - n3;
            int n4 = byteBuffer.remaining();
            int n5 = n4 % 16;
            n5 = n5 == 0 ? n4 : n4 + 16 - n5;
            n5 = n3 + n5;
            int n6 = n5 + 16;
            ByteBuffer byteBuffer4 = ByteBuffer.allocate(n6).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer4.put(byArray2);
            byteBuffer4.position(n3);
            byteBuffer4.put(byteBuffer);
            byteBuffer4.position(n5);
            byteBuffer4.putLong(n2);
            byteBuffer4.putLong(n4);
            byArray2 = byteBuffer4.array();
            boolean bl = MessageDigest.isEqual(zzgji.zza(byArray4, byArray2), byArray3);
            if (!bl) {
                throw new GeneralSecurityException("invalid MAC");
            }
            byteBuffer.position(n);
            return this.zza.zzd(byArray, byteBuffer);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AEADBadTagException(generalSecurityException.toString());
        }
    }
}

