/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.util.zzt;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbth;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzcbs;
import com.google.android.gms.internal.ads.zzdto;
import com.google.android.gms.internal.ads.zzdtp;
import com.google.android.gms.internal.ads.zzeei;
import com.google.android.gms.internal.ads.zzeep;
import com.google.android.gms.internal.ads.zzeer;
import com.google.android.gms.internal.ads.zzees;
import com.google.android.gms.internal.ads.zzeet;
import com.google.android.gms.internal.ads.zzeeu;
import com.google.android.gms.internal.ads.zzeev;
import com.google.android.gms.internal.ads.zzeew;
import com.google.android.gms.internal.ads.zzeex;
import com.google.android.gms.internal.ads.zzeey;
import com.google.android.gms.internal.ads.zzeez;
import com.google.android.gms.internal.ads.zzefc;
import com.google.android.gms.internal.ads.zzfjd;
import com.google.android.gms.internal.ads.zzfje;
import com.google.android.gms.internal.ads.zzfre;
import com.google.android.gms.internal.ads.zzfwx;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class zzefa
extends zzbth {
    private final Context zza;
    private final zzdtp zzb;
    private final zzcbs zzc;
    private final zzeep zzd;
    private final zzfje zze;
    private String zzf;
    private String zzg;

    private static String zzp(int n, String string2) {
        Resources resources = com.google.android.gms.ads.internal.zzt.zzo().zze();
        if (resources == null) {
            return string2;
        }
        return resources.getString(n);
    }

    @VisibleForTesting
    public zzefa(Context context, zzeep zzeep2, zzcbs zzcbs2, zzdtp zzdtp2, zzfje zzfje2) {
        this.zza = context;
        this.zzb = zzdtp2;
        this.zzc = zzcbs2;
        this.zzd = zzeep2;
        this.zze = zzfje2;
    }

    private final void zzq(String string2, String string3, Map map) {
        zzefa.zzc(this.zza, this.zzb, this.zze, this.zzd, string2, string3, map);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void zzc(Context object, zzdtp object2, zzfje object3, zzeep zzeep2, String string2, String object4, Map map) {
        void var3_5;
        void var6_10;
        void var4_6;
        void var5_7;
        object = true != com.google.android.gms.ads.internal.zzt.zzo().zzz((Context)object) ? "offline" : "online";
        zzbcu zzbcu2 = zzbdc.zziv;
        if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue() || object2 == null) {
            object2 = zzfjd.zzb((String)var5_7);
            ((zzfjd)object2).zza("gqi", (String)var4_6);
            ((zzfjd)object2).zza("device_connectivity", (String)object);
            object = String.valueOf(com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis());
            ((zzfjd)object2).zza("event_timestamp", (String)object);
            for (Map.Entry entry : var6_10.entrySet()) {
                ((zzfjd)object2).zza((String)entry.getKey(), (String)entry.getValue());
            }
            object = object3.zza((zzfjd)object2);
        } else {
            object2 = ((zzdtp)object2).zza();
            ((zzdto)object2).zzb("gqi", (String)var4_6);
            ((zzdto)object2).zzb("action", (String)var5_7);
            ((zzdto)object2).zzb("device_connectivity", (String)object);
            object = String.valueOf(com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis());
            ((zzdto)object2).zzb("event_timestamp", (String)object);
            for (Map.Entry entry : var6_10.entrySet()) {
                ((zzdto)object2).zzb((String)entry.getKey(), (String)entry.getValue());
            }
            object = ((zzdto)object2).zzf();
        }
        var3_5.zzd(new zzeer(com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis(), (String)var4_6, (String)object, 2));
    }

    /*
     * Unable to fully structure code
     */
    public final void zze(Intent var1_2) {
        block8: {
            block9: {
                block10: {
                    var2_4 = var1_2.getStringExtra("offline_notification_action");
                    if (!var2_4.equals("offline_notification_clicked") && !var2_4.equals("offline_notification_dismissed")) break block8;
                    var3_5 = var1_2.getStringExtra("gws_query_id");
                    var4_6 = var1_2.getStringExtra("uri");
                    var1_2 = this.zza;
                    var1_3 = com.google.android.gms.ads.internal.zzt.zzo().zzz((Context)var1_2);
                    var5_7 = new HashMap<String, String>();
                    if (!var2_4.equals("offline_notification_clicked")) break block9;
                    var5_7.put("offline_notification_action", "offline_notification_clicked");
                    if (1 == var1_3) break block10;
                    var1_3 = 2;
lbl13:
                    // 2 sources

                    while (true) {
                        var2_4 = String.valueOf(Build.VERSION.SDK_INT);
                        var5_7.put("obvs", var2_4);
                        var2_4 = String.valueOf(var4_6.startsWith("http"));
                        var5_7.put("olaih", var2_4);
                        var2_4 = this.zza.getPackageManager().getLaunchIntentForPackage(var4_6);
                        if (var2_4 != null) ** GOTO lbl28
                        v0 = new Intent("android.intent.action.VIEW");
                        v0.setData(Uri.parse((String)var4_6));
                        var2_4 = v0;
lbl28:
                        // 2 sources

                        var2_4.addFlags(0x10000000);
                        this.zza.startActivity((Intent)var2_4);
                        var5_7.put("olaa", "olas");
lbl33:
                        // 3 sources

                        while (true) {
                            block7: {
                                this.zzq(var3_5, "offline_notification_action", var5_7);
                                var2_4 = this.zzd.getWritableDatabase();
                                if (var1_3 != 1) break block7;
                                this.zzd.zzg((SQLiteDatabase)var2_4, this.zzc, var3_5);
                                return;
                            }
                            zzeep.zzi((SQLiteDatabase)var2_4, var3_5);
                            return;
                        }
                        break;
                    }
                }
                var1_3 = 1;
                ** while (true)
            }
            var5_7.put("offline_notification_action", "offline_notification_dismissed");
            var1_3 = 2;
            ** GOTO lbl33
        }
        return;
        catch (ActivityNotFoundException v1) {
            var5_7.put("olaa", "olaf");
            ** continue;
        }
        catch (SQLiteException var0_1) {
            zzcbn.zzg((String)"Failed to get writable offline buffering database: ".concat(var0_1.toString()));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(String[] activity, int[] nArray, IObjectWrapper object) {
        int n = 0;
        while (true) {
            if (n >= ((Activity)activity).length) {
                return;
            }
            if (activity[n].equals("android.permission.POST_NOTIFICATIONS")) break;
            ++n;
        }
        zzefc zzefc2 = (zzefc)ObjectWrapper.unwrap((IObjectWrapper)object);
        activity = zzefc2.zza();
        object = zzefc2.zzb();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nArray[n] == 0) {
            hashMap.put("dialog_action", "confirm");
            this.zzr();
            this.zzt(activity, (zzl)object);
        } else {
            hashMap.put("dialog_action", "dismiss");
            if (object != null) {
                ((zzl)object).zzb();
            }
        }
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "asnpdc", hashMap);
    }

    public final void zzg(IObjectWrapper iObjectWrapper) {
        zzefa zzefa2 = this;
        zzefc zzefc2 = (zzefc)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        iObjectWrapper = zzefc2.zza();
        zzl zzl2 = zzefc2.zzb();
        zzefa2.zzf = zzefc2.zzc();
        zzefa2.zzg = zzefc2.zzd();
        zzbcu zzbcu2 = zzbdc.zzio;
        if (!((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) {
            zzefa zzefa3 = this;
            zzefa3.zzq(zzefa3.zzf, "dialog_impression", zzfwx.zzd());
            com.google.android.gms.ads.internal.zzt.zzp();
            AlertDialog.Builder builder = zzt.zzJ((Context)iObjectWrapper);
            builder.setTitle((CharSequence)zzefa.zzp(R.string.offline_opt_in_title, "Open ad when you're back online.")).setMessage((CharSequence)zzefa.zzp(R.string.offline_opt_in_message, "We'll send you a notification with a link to the advertiser site.")).setPositiveButton((CharSequence)zzefa.zzp(R.string.offline_opt_in_confirm, "OK"), (DialogInterface.OnClickListener)new zzeev(this, (Activity)iObjectWrapper, zzl2)).setNegativeButton((CharSequence)zzefa.zzp(R.string.offline_opt_in_decline, "No thanks"), (DialogInterface.OnClickListener)new zzeew(this, zzl2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzeex(this, zzl2));
            builder.create().show();
            return;
        }
        this.zzs((Activity)iObjectWrapper, zzl2);
    }

    final /* synthetic */ void zzd(Activity activity, zzl zzl2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "rtsdc", (Map)object);
        Activity activity2 = activity;
        activity2.startActivity(com.google.android.gms.ads.internal.zzt.zzq().zzg(activity2));
        this.zzr();
        if (zzl2 != null) {
            zzl2.zzb();
            return;
        }
    }

    final /* synthetic */ void zzj(zzl zzl2, DialogInterface object, int n) {
        this.zzd.zzc(this.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "rtsdc", (Map)object);
        if (zzl2 != null) {
            zzl2.zzb();
            return;
        }
    }

    final /* synthetic */ void zzk(zzl zzl2, DialogInterface object) {
        this.zzd.zzc(this.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "rtsdc", (Map)object);
        if (zzl2 != null) {
            zzl2.zzb();
            return;
        }
    }

    final /* synthetic */ void zzl(Activity activity, zzl zzl2, DialogInterface object, int n) {
        object = new HashMap();
        object.put("dialog_action", "confirm");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "dialog_click", (Map)object);
        this.zzs(activity, zzl2);
    }

    final /* synthetic */ void zzm(zzl zzl2, DialogInterface object, int n) {
        this.zzd.zzc(this.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "dialog_click", (Map)object);
        if (zzl2 != null) {
            zzl2.zzb();
            return;
        }
    }

    final /* synthetic */ void zzn(zzl zzl2, DialogInterface object) {
        this.zzd.zzc(this.zzf);
        object = new HashMap();
        object.put("dialog_action", "dismiss");
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "dialog_click", (Map)object);
        if (zzl2 != null) {
            zzl2.zzb();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzr() {
        try {
            com.google.android.gms.ads.internal.zzt.zzp();
            boolean bl = zzt.zzy(this.zza).zzf(ObjectWrapper.wrap((Object)this.zza), this.zzg, this.zzf);
            if (bl) {
                return;
            }
        }
        catch (RemoteException remoteException) {
            zzcbn.zzh((String)"Failed to schedule offline notification poster.", (Throwable)remoteException);
        }
        this.zzd.zzc(this.zzf);
        zzefa zzefa2 = this;
        zzefa2.zzq(zzefa2.zzf, "offline_notification_worker_not_scheduled", zzfwx.zzd());
    }

    private final void zzs(Activity activity, @Nullable zzl object) {
        com.google.android.gms.ads.internal.zzt.zzp();
        if (!NotificationManagerCompat.from((Context)activity).areNotificationsEnabled()) {
            if (Build.VERSION.SDK_INT < 33) {
                com.google.android.gms.ads.internal.zzt.zzp();
                AlertDialog.Builder builder = zzt.zzJ((Context)activity);
                builder.setTitle((CharSequence)zzefa.zzp(R.string.notifications_permission_title, "Allow app to send you notifications?")).setPositiveButton((CharSequence)zzefa.zzp(R.string.notifications_permission_confirm, "Allow"), (DialogInterface.OnClickListener)new zzees(this, activity, (zzl)object)).setNegativeButton((CharSequence)zzefa.zzp(R.string.notifications_permission_decline, "Don't allow"), (DialogInterface.OnClickListener)new zzeet(this, (zzl)object)).setOnCancelListener((DialogInterface.OnCancelListener)new zzeeu(this, (zzl)object));
                builder.create().show();
                zzefa zzefa2 = this;
                zzefa2.zzq(zzefa2.zzf, "rtsdi", zzfwx.zzd());
                return;
            }
            object = "android.permission.POST_NOTIFICATIONS";
            activity.requestPermissions(new String[]{object}, 12345);
            zzefa zzefa3 = this;
            zzefa3.zzq(zzefa3.zzf, "asnpdi", zzfwx.zzd());
            return;
        }
        this.zzr();
        this.zzt(activity, (zzl)object);
    }

    public final void zzh() {
        zzeei zzeei2 = new zzeei(this.zzc);
        this.zzd.zze(zzeei2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzi(IObjectWrapper object, String string2, String string3) {
        void var1_5;
        PendingIntent pendingIntent;
        void var3_9;
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)object);
        HashMap<String, String> hashMap = "offline_notification_channel";
        String string4 = "AdMob Offline Notifications";
        com.google.android.gms.ads.internal.zzt.zzq().zzh(context, (String)((Object)hashMap), string4);
        hashMap = zzefa.zzo(context, "offline_notification_clicked", (String)var3_9, (String)pendingIntent);
        pendingIntent = zzefa.zzo(context, "offline_notification_dismissed", (String)var3_9, (String)pendingIntent);
        string4 = "offline_notification_channel";
        pendingIntent = new NotificationCompat.Builder(context, string4).setContentTitle((CharSequence)zzefa.zzp(R.string.offline_notification_title, "View the ad you saved when you were offline")).setContentText((CharSequence)zzefa.zzp(R.string.offline_notification_text, "Tap to open ad")).setAutoCancel(true).setDeleteIntent(pendingIntent).setContentIntent((PendingIntent)hashMap).setSmallIcon(context.getApplicationInfo().icon);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        hashMap = new HashMap<String, String>();
        try {
            notificationManager.notify((String)var3_9, 54321, pendingIntent.build());
            String string5 = "offline_notification_impression";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hashMap.put("notification_not_shown_reason", illegalArgumentException.getMessage());
            String string6 = "offline_notification_failed";
        }
        this.zzq((String)var3_9, (String)var1_5, hashMap);
    }

    private final void zzt(Activity activity, @Nullable zzl zzl2) {
        Object object = zzefa.zzp(R.string.offline_opt_in_confirmation, "You'll get a notification with the link when you're back online");
        com.google.android.gms.ads.internal.zzt.zzp();
        AlertDialog.Builder builder = zzt.zzJ((Context)activity);
        builder.setMessage((CharSequence)object).setOnCancelListener((DialogInterface.OnCancelListener)new zzeey(zzl2));
        activity = builder.create();
        activity.show();
        object = new Timer();
        ((Timer)object).schedule((TimerTask)new zzeez(this, (AlertDialog)activity, (Timer)object, zzl2), 3000L);
    }

    @VisibleForTesting
    public static final PendingIntent zzo(Context context, String string2, String string3, String string4) {
        Intent intent = new Intent();
        intent.setAction(string2);
        intent.putExtra("offline_notification_action", string2);
        intent.putExtra("gws_query_id", string3);
        intent.putExtra("uri", string4);
        if (Build.VERSION.SDK_INT >= 29 && string2.equals("offline_notification_clicked")) {
            intent.setClassName(context, "com.google.android.gms.ads.NotificationHandlerActivity");
            return zzfre.zza(context, 0, intent, 0xC000000);
        }
        intent.setClassName(context, "com.google.android.gms.ads.AdService");
        return zzfre.zzb(context, 0, intent, zzfre.zza | 0x40000000, 0);
    }
}

