/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzt;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzccr;
import com.google.android.gms.internal.ads.zzccs;
import com.google.android.gms.internal.ads.zzcct;
import com.google.android.gms.internal.ads.zzccu;
import com.google.android.gms.internal.ads.zzccv;
import com.google.android.gms.internal.ads.zzccw;
import com.google.android.gms.internal.ads.zzccx;
import com.google.android.gms.internal.ads.zzccy;
import com.google.android.gms.internal.ads.zzccz;
import com.google.android.gms.internal.ads.zzcdb;
import com.google.android.gms.internal.ads.zzcdc;
import com.google.android.gms.internal.ads.zzcdu;
import com.google.android.gms.internal.ads.zzcdv;
import com.google.android.gms.internal.ads.zzcdw;
import com.google.android.gms.internal.ads.zzcdx;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class zzcda
extends zzcdc
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map zzc = new HashMap();
    private final zzcdw zzd;
    private final zzcdx zze;
    private final boolean zzf;
    private int zzg = 0;
    private int zzh = 0;
    private MediaPlayer zzi;
    private Uri zzj;
    private int zzk;
    private int zzl;
    private int zzm;
    private zzcdu zzn;
    private final boolean zzo;
    private int zzp;
    private zzcdb zzq;
    private boolean zzr = false;
    private Integer zzs = null;

    @Override
    public final int zza() {
        if (this.zzH()) {
            return this.zzi.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzH()) {
            return this.zzi.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzH()) {
            return this.zzi.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzcda zzcda2 = zzcda2.zzi;
        if (zzcda2 != null) {
            return zzcda2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzcda zzcda2 = zzcda2.zzi;
        if (zzcda2 != null) {
            return zzcda2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzs != null) {
            return this.zzh() * (long)this.zzm / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzs != null) {
            return (long)this.zzc() * (long)this.zzs.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzcdb zzi(zzcda zzcda2) {
        return zzcda2.zzq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final String zzj() {
        Object object;
        if (!((zzcda)object).zzo) {
            object = "";
            return "MediaPlayer".concat((String)object);
        }
        object = " spherical";
        return "MediaPlayer".concat((String)object);
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static /* bridge */ /* synthetic */ void zzk(zzcda zzcda2, boolean bl) {
        zzcda2.zzr = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzl(zzcda zzcda2, MediaPlayer object) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzbdc.zzbO;
        if ((Boolean)zzba.zzc().zza((zzbcu)trackInfoArray) == false) return;
        if (zzcda2.zzd == null) return;
        if (object == null) {
            return;
        }
        try {
            trackInfoArray = object.getTrackInfo();
            if (trackInfoArray == null) return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = "AdMediaPlayerView.reportMetadata";
            com.google.android.gms.ads.internal.zzt.zzo().zzw(runtimeException, string2);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        while (true) {
            void var1_4;
            if (var1_4 >= trackInfoArray.length) {
                if (hashMap.isEmpty()) return;
                zzcda2.zzd.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[var1_4];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        String string3;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("mime")) {
                            string3 = mediaFormat.getString("mime");
                            hashMap.put("audioMime", string3);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string4 = mediaFormat.getString("codecs-string");
                        hashMap.put("audioCodec", string4);
                        break;
                    }
                    case 1: {
                        String string3;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(mediaFormat.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                string3 = String.valueOf(mediaFormat.getInteger("frame-rate"));
                                hashMap.put("frameRate", string3);
                            }
                        }
                        if (mediaFormat.containsKey("bitrate")) {
                            zzcda2.zzs = mediaFormat.getInteger("bitrate");
                            string3 = String.valueOf(zzcda2.zzs);
                            hashMap.put("bitRate", string3);
                        }
                        if (mediaFormat.containsKey("width") && mediaFormat.containsKey("height")) {
                            int n = mediaFormat.getInteger("width");
                            int n2 = mediaFormat.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n);
                            stringBuilder.append("x");
                            stringBuilder.append(n2);
                            string3 = stringBuilder.toString();
                            hashMap.put("resolution", string3);
                        }
                        if (mediaFormat.containsKey("mime")) {
                            string3 = mediaFormat.getString("mime");
                            hashMap.put("videoMime", string3);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string5 = mediaFormat.getString("codecs-string");
                        hashMap.put("videoCodec", string5);
                    }
                }
            }
            ++var1_4;
        }
    }

    static {
        zzc.put(-1004, "MEDIA_ERROR_IO");
        zzc.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzc.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzc.put(100, "MEDIA_ERROR_SERVER_DIED");
        Integer n = 1;
        zzc.put(n, "MEDIA_ERROR_UNKNOWN");
        String string2 = "MEDIA_INFO_UNKNOWN";
        zzc.put(n, string2);
        zzc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzc.put(701, "MEDIA_INFO_BUFFERING_START");
        zzc.put(702, "MEDIA_INFO_BUFFERING_END");
        zzc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzc.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }

    public zzcda(Context context, zzcdw zzcdw2, boolean bl, boolean bl2, zzcdv zzcdv2, zzcdx zzcdx2) {
        super(context);
        zzcda zzcda2 = this;
        zzcda2.setSurfaceTextureListener(zzcda2);
        this.zzd = zzcdw2;
        this.zze = zzcdx2;
        this.zzo = bl;
        this.zzf = bl2;
        this.zze.zza(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzD() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzj == null || surfaceTexture == null) {
            return;
        }
        this.zzE(false);
        try {
            MediaPlayer mediaPlayer;
            com.google.android.gms.ads.internal.zzt.zzk();
            this.zzi = mediaPlayer = new MediaPlayer();
            this.zzi.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzi.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzi.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzi.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzi.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzi.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzm = 0;
            boolean bl = this.zzo;
            if (bl) {
                this.zzn = new zzcdu(this.getContext());
                this.zzn.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzn.start();
                SurfaceTexture surfaceTexture2 = this.zzn.zzb();
                if (surfaceTexture2 != null) {
                    surfaceTexture = surfaceTexture2;
                } else {
                    this.zzn.zze();
                    this.zzn = null;
                }
            }
            this.zzi.setDataSource(this.getContext(), this.zzj);
            com.google.android.gms.ads.internal.zzt.zzl();
            Surface surface = new Surface(surfaceTexture);
            this.zzi.setSurface(surface);
            this.zzi.setAudioStreamType(3);
            this.zzi.setScreenOnWhilePlaying(true);
            this.zzi.prepareAsync();
            this.zzF(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(String.valueOf(this.zzj));
            zzcbn.zzk((String)"Failed to initialize MediaPlayer at ".concat(string2), (Throwable)exception);
            zzcda zzcda2 = this;
            zzcda2.onError(zzcda2.zzi, 1, 0);
            return;
        }
    }

    final /* synthetic */ void zzm(int n) {
        zzcdb zzcdb2 = ((zzcda)((Object)zzcdb2)).zzq;
        if (zzcdb2 != null) {
            zzcdb2.onWindowVisibilityChanged(n);
            return;
        }
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzm = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzF(5);
        this.zzh = 5;
        zzt.zza.post((Runnable)new zzcct(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block17: {
            int n3;
            int n4;
            block19: {
                block20: {
                    block21: {
                        int n5;
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block23: {
                                            n4 = zzcda.getDefaultSize((int)((zzcda)((Object)zzcdu2)).zzk, (int)n);
                                            n3 = zzcda.getDefaultSize((int)((zzcda)((Object)zzcdu2)).zzl, (int)n2);
                                            if (((zzcda)((Object)zzcdu2)).zzk <= 0) break block19;
                                            if (((zzcda)((Object)zzcdu2)).zzl <= 0) break block20;
                                            if (((zzcda)((Object)zzcdu2)).zzn != null) break block21;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n5 = View.MeasureSpec.getMode((int)n2);
                                            n2 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block22;
                                            if (n5 != 0x40000000) break block23;
                                            n = ((zzcda)((Object)zzcdu2)).zzk;
                                            n4 = n * n2;
                                            n5 = ((zzcda)((Object)zzcdu2)).zzl;
                                            int n6 = n3 * n5;
                                            if (n4 < n6) {
                                                n = n4 / n5;
                                                break block17;
                                            } else if (n4 > n6) {
                                                int n7 = n6 / n;
                                                n = n3;
                                                n2 = n7;
                                                break block17;
                                            } else {
                                                n = n3;
                                            }
                                            break block17;
                                        }
                                        n = 0x40000000;
                                        break block24;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block25;
                                n = n3 * ((zzcda)((Object)zzcdu2)).zzl / ((zzcda)((Object)zzcdu2)).zzk;
                                if (n5 == Integer.MIN_VALUE) {
                                    if (n > n2) {
                                        n = n3;
                                        break block17;
                                    } else {
                                        int n8 = n;
                                        n = n3;
                                        n2 = n8;
                                    }
                                    break block17;
                                } else {
                                    int n9 = n;
                                    n = n3;
                                    n2 = n9;
                                }
                                break block17;
                            }
                            if (n5 != 0x40000000) break block26;
                            n4 = n2 * ((zzcda)((Object)zzcdu2)).zzk / ((zzcda)((Object)zzcdu2)).zzl;
                            n = n == Integer.MIN_VALUE ? (n4 > n3 ? n3 : n4) : n4;
                            break block17;
                        }
                        int n10 = ((zzcda)((Object)zzcdu2)).zzk;
                        int n11 = ((zzcda)((Object)zzcdu2)).zzl;
                        if (n5 == Integer.MIN_VALUE) {
                            if (n11 > n2) {
                                int n12 = n2;
                                n2 = n12 * n10 / n11;
                                n4 = n12;
                            } else {
                                n2 = n10;
                                n4 = n11;
                            }
                        } else {
                            n2 = n10;
                            n4 = n11;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n = n3;
                                n2 = n3 * n11 / n10;
                                break block17;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block17;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block17;
                    }
                    n = n4;
                    n2 = n3;
                    break block17;
                }
                n = n4;
                n2 = n3;
                break block17;
            }
            n = n4;
            n2 = n3;
        }
        zzcdu2.setMeasuredDimension(n, n2);
        zzcdu zzcdu2 = ((zzcda)((Object)zzcdu2)).zzn;
        if (zzcdu2 != null) {
            zzcdu2.zzc(n, n2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzF(2);
        this.zze.zzb();
        zzt.zza.post((Runnable)new zzccs(this, mediaPlayer));
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = mediaPlayer.getVideoHeight();
        int n = this.zzp;
        if (n != 0) {
            this.zzq(n);
        }
        if (this.zzf && this.zzH() && this.zzi.getCurrentPosition() > 0 && this.zzh != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzG(0.0f);
            this.zzi.start();
            n = this.zzi.getCurrentPosition();
            long l = com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis();
            while (this.zzH() && this.zzi.getCurrentPosition() == n && com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis() - l <= 250L) {
            }
            this.zzi.pause();
            this.zzn();
        }
        n = this.zzk;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView stream dimensions: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(this.zzl);
        zzcbn.zzi((String)stringBuilder.toString());
        if (this.zzh == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzD();
        zzt.zza.post((Runnable)new zzccv(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzcdu zzcdu2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzh;
        int n4 = this.zzk == n ? (this.zzl == n2 ? 1 : 0) : 0;
        if (this.zzi != null && n3 == 3 && n4 != 0) {
            n4 = this.zzp;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzcdu2 = this.zzn) != null) {
            zzcdu2.zzc(n, n2);
        }
        zzt.zza.post((Runnable)new zzccw(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zze.zzf(this);
        zzcdb zzcdb2 = this.zzq;
        this.zza.zza(surfaceTexture, zzcdb2);
    }

    @Override
    public final void zzn() {
        zzcda zzcda2 = this;
        zzcda2.zzG(zzcda2.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzk = mediaPlayer.getVideoWidth();
        this.zzl = n3 = mediaPlayer.getVideoHeight();
        if (this.zzk != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        zzt.zza.post((Runnable)new zzccr(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzH() && this.zzi.isPlaying()) {
            this.zzi.pause();
            this.zzF(4);
            zzt.zza.post((Runnable)new zzccz(this));
        }
        this.zzh = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzH()) {
            this.zzi.start();
            this.zzF(3);
            this.zza.zzb();
            zzt.zza.post((Runnable)new zzccy(this));
        }
        this.zzh = 3;
    }

    private final void zzE(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzcdu zzcdu2 = this.zzn;
        if (zzcdu2 != null) {
            zzcdu2.zze();
            this.zzn = null;
        }
        if ((zzcdu2 = this.zzi) != null) {
            zzcdu2.reset();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            if (bl) {
                this.zzh = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzH()) {
            this.zzi.seekTo(n);
            this.zzp = 0;
            return;
        }
        this.zzp = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzF(int n) {
        if (n == 3) {
            this.zze.zzc();
            this.zzb.zzb();
        } else if (this.zzg == 3) {
            this.zze.zze();
            this.zzb.zzc();
        }
        this.zzg = n;
    }

    @Override
    public final void zzr(zzcdb zzcdb2) {
        this.zzq = zzcdb2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzG(float f) {
        zzcda zzcda2;
        zzcda2 = zzcda2.zzi;
        if (zzcda2 == null) {
            zzcbn.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            float f2 = f;
            zzcda2.setVolume(f2, f2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(@Nullable String string2) {
        zzayb zzayb2 = zzayb.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzayb2 == null || zzayb2.zza != null) {
            if (zzayb2 != null) {
                string2 = Uri.parse((String)zzayb2.zza);
            }
            this.zzj = string2;
            this.zzp = 0;
            this.zzD();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzi;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzi.release();
            this.zzi = null;
            this.zzF(0);
            this.zzh = 0;
        }
        this.zze.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzcdu zzcdu2 = ((zzcda)((Object)zzcdu2)).zzn;
        if (zzcdu2 != null) {
            zzcdu2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzcda zzcda2) {
        return zzcda2.zzr;
    }

    private final boolean zzH() {
        int n;
        return this.zzi != null && (n = this.zzg) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = (String)zzc.get(n);
        String string2 = (String)zzc.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        zzcbn.zzj((String)stringBuilder.toString());
        this.zzF(-1);
        this.zzh = -1;
        zzt.zza.post((Runnable)new zzccu(this, (String)object, string2));
        return true;
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = (String)zzc.get(n);
        String string3 = (String)zzc.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer info: ");
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append(string3);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzi;
        if (object != null && this.zzp == 0) {
            this.zzp = object.getCurrentPosition();
        }
        if ((object = this.zzn) != null) {
            ((zzcdu)object).zze();
        }
        zzt.zza.post((Runnable)new zzccx(this));
        this.zzE(true);
        return true;
    }
}

