/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nonagon.signalgeneration;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.nonagon.signalgeneration.zzan;
import com.google.android.gms.ads.nonagon.signalgeneration.zzao;
import com.google.android.gms.ads.nonagon.signalgeneration.zzap;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaq;
import com.google.android.gms.ads.nonagon.signalgeneration.zzar;
import com.google.android.gms.ads.nonagon.signalgeneration.zzf;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzasj;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzcca;
import com.google.android.gms.internal.ads.zzdtu;
import com.google.android.gms.internal.ads.zzfla;
import com.google.android.gms.internal.ads.zzgbl;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

final class TaggingLibraryJsInterface {
    private final Context zza;
    private final WebView zzb;
    private final zzasi zzc;
    private final int zzd;
    private final zzdtu zze;
    private final boolean zzf;
    private final zzgbl zzg = zzcca.zze;
    private final zzfla zzh;

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignals(String clickString) {
        String string2;
        block4: {
            long l;
            try {
                l = zzt.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zze(this.zza, string2, (View)this.zzb);
                boolean bl = this.zzf;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzcbn.zzh((String)"Exception getting click signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getClickSignals";
                zzt.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzt.zzB().currentTimeMillis();
            long l3 = l2 - l;
            com.google.android.gms.ads.nonagon.signalgeneration.zzf.zzc(this.zze, null, "csg", new Pair((Object)"clat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignalsWithTimeout(String clickString, int timeoutMs) {
        String string2;
        void var2_3;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting click signals. Timeout=");
            stringBuilder.append((int)var2_3);
            zzcbn.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcca.zza.zzb(new zzap((TaggingLibraryJsInterface)object, string2));
        long l = Math.min((int)var2_3, ((TaggingLibraryJsInterface)object).zzd);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzcbn.zzh((String)"Exception getting click signals with timeout. ", (Throwable)exception);
            string2 = "TaggingLibraryJsInterface.getClickSignalsWithTimeout";
            zzt.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getQueryInfo() {
        zzt.zzp();
        String string2 = UUID.randomUUID().toString();
        Bundle bundle = new Bundle();
        bundle.putString("query_info_type", "requester_type_6");
        zzar zzar2 = new zzar(this, string2);
        zzbcu zzbcu2 = zzbdc.zzjp;
        if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) {
            this.zzg.execute(new zzaq(this, bundle, zzar2));
            return string2;
        }
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.addNetworkExtrasBundle(AdMobAdapter.class, bundle);
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)builder.build(), (QueryInfoGenerationCallback)zzar2);
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignals() {
        String string2;
        block4: {
            long l;
            try {
                l = zzt.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zzh(this.zza, (View)this.zzb, null);
                boolean bl = this.zzf;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzcbn.zzh((String)"Exception getting view signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getViewSignals";
                zzt.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzt.zzB().currentTimeMillis();
            long l3 = l2 - l;
            com.google.android.gms.ads.nonagon.signalgeneration.zzf.zzc(this.zze, null, "vsg", new Pair((Object)"vlat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignalsWithTimeout(int timeoutMs) {
        void var1_2;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting view signals. Timeout=");
            stringBuilder.append((int)var1_2);
            zzcbn.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcca.zza.zzb(new zzan((TaggingLibraryJsInterface)object));
        long l = Math.min((int)var1_2, ((TaggingLibraryJsInterface)object).zzd);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzcbn.zzh((String)"Exception getting view signals with timeout. ", (Throwable)exception);
            String string2 = "TaggingLibraryJsInterface.getViewSignalsWithTimeout";
            zzt.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void recordClick(String clickUrl) {
        void var1_1;
        zzbcu zzbcu2 = zzbdc.zzjr;
        if (!((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue() || TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        zzcca.zza.execute(new zzao(this, (String)var1_1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void reportTouchEvent(String touchJson) {
        String string2;
        JSONObject jSONObject = new JSONObject(string2);
        int n = jSONObject.getInt("x");
        int n2 = jSONObject.getInt("y");
        int n3 = jSONObject.getInt("duration_ms");
        double d = jSONObject.getDouble("force");
        float f = (float)d;
        int n4 = jSONObject.getInt("type");
        switch (n4) {
            default: {
                n4 = -1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        try {
            MotionEvent motionEvent = MotionEvent.obtain((long)0L, (long)n3, (int)n4, (float)n, (float)n2, (float)f, (float)1.0f, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0);
            this.zzc.zzd(motionEvent);
            return;
        }
        catch (RuntimeException | JSONException throwable) {
            zzcbn.zzh((String)"Failed to parse the touch string. ", (Throwable)throwable);
            string2 = "TaggingLibraryJsInterface.reportTouchEvent";
            zzt.zzo().zzw(throwable, string2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ WebView zza(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzb;
    }

    TaggingLibraryJsInterface(WebView webView, zzasi zzasi2, zzdtu zzdtu2, zzfla zzfla2) {
        this.zzb = webView;
        this.zza = webView.getContext();
        this.zzc = zzasi2;
        this.zze = zzdtu2;
        zzbdc.zza((Context)this.zza);
        webView = zzbdc.zzjm;
        this.zzd = (Integer)zzba.zzc().zza((zzbcu)webView);
        webView = zzbdc.zzjn;
        this.zzf = (Boolean)zzba.zzc().zza((zzbcu)webView);
        this.zzh = zzfla2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzb(Bundle bundle, QueryInfoGenerationCallback queryInfoGenerationCallback) {
        CookieManager cookieManager = zzt.zzq().zzb(this.zza);
        boolean bl = cookieManager != null ? cookieManager.acceptThirdPartyCookies(this.zzb) : false;
        bundle.putBoolean("accept_3p_cookie", bl);
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.addNetworkExtrasBundle(AdMobAdapter.class, bundle);
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)builder.build(), (QueryInfoGenerationCallback)queryInfoGenerationCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(String string2) {
        string2 = Uri.parse((String)string2);
        try {
            zzasi zzasi2 = this.zzc;
            Context context = this.zza;
            WebView webView = this.zzb;
            string2 = zzasi2.zza((Uri)string2, context, (View)webView, null);
        }
        catch (zzasj zzasj2) {
            zzcbn.zzf((String)"Failed to append the click signal to URL: ", (Throwable)zzasj2);
            String string3 = "TaggingLibraryJsInterface.recordClick";
            zzt.zzo().zzw(zzasj2, string3);
        }
        this.zzh.zzc(string2.toString(), null);
    }
}

