/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import com.google.android.gms.ads.formats.zzg;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.zzad;
import com.google.android.gms.ads.internal.util.zzbq;
import com.google.android.gms.ads.internal.util.zzbr;
import com.google.android.gms.ads.internal.util.zzbt;
import com.google.android.gms.ads.internal.util.zzca;
import com.google.android.gms.ads.internal.util.zzch;
import com.google.android.gms.ads.internal.util.zzci;
import com.google.android.gms.ads.internal.util.zzcj;
import com.google.android.gms.ads.internal.util.zzck;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzf;
import com.google.android.gms.ads.internal.util.zzl;
import com.google.android.gms.ads.internal.util.zzm;
import com.google.android.gms.ads.internal.util.zzn;
import com.google.android.gms.ads.internal.util.zzo;
import com.google.android.gms.ads.internal.util.zzq;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbed;
import com.google.android.gms.internal.ads.zzbfe;
import com.google.android.gms.internal.ads.zzbwo;
import com.google.android.gms.internal.ads.zzcbf;
import com.google.android.gms.internal.ads.zzcbg;
import com.google.android.gms.internal.ads.zzcbm;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzcgm;
import com.google.android.gms.internal.ads.zzchs;
import com.google.android.gms.internal.ads.zzdqx;
import com.google.android.gms.internal.ads.zzfdu;
import com.google.android.gms.internal.ads.zzfdy;
import com.google.android.gms.internal.ads.zzfqv;
import com.google.android.gms.internal.ads.zzftk;
import com.google.android.gms.internal.ads.zzful;
import com.google.android.gms.internal.ads.zzgbb;
import com.google.android.gms.internal.ads.zzhed;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzt {
    public static final zzfqv zza = new zzf(Looper.getMainLooper());
    private final AtomicReference zzb = new AtomicReference<Object>(null);
    private final AtomicReference zzc = new AtomicReference<Object>(null);
    private final AtomicReference zzd = new AtomicReference<Bundle>(new Bundle());
    private final AtomicBoolean zze = new AtomicBoolean();
    private boolean zzf = true;
    private final Object zzg = new Object();
    private String zzh;
    private boolean zzi = false;
    private boolean zzj = false;
    private final Executor zzk = Executors.newSingleThreadExecutor();

    public static int zza(int n) {
        if (n >= 5000) {
            return n;
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTP timeout too low: ");
            stringBuilder.append(n);
            stringBuilder.append(" milliseconds. Reverting to default timeout: 60000 milliseconds.");
            zzcbn.zzj((String)stringBuilder.toString());
        }
        return 60000;
    }

    @Nullable
    private static KeyguardManager zzW(Context object) {
        if ((object = object.getSystemService("keyguard")) != null && object instanceof KeyguardManager) {
            return (KeyguardManager)object;
        }
        return null;
    }

    @Nullable
    private static Bundle zzX(Context context) throws RemoteException {
        try {
            context = Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            return context;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            com.google.android.gms.ads.internal.util.zze.zzb("Error getting metadata", throwable);
            return null;
        }
    }

    public final ListenableFuture zzb(Uri uri) {
        return zzgbb.zzj(new zzn(uri), this.zzk);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String zzY(Bundle object) {
        if (object == null || TextUtils.isEmpty((CharSequence)(object = object.getString("com.google.android.gms.ads.APPLICATION_ID"))) || !((String)object).matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$") && !((String)object).matches("^/\\d+~.+$")) {
            return "";
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzc(Context context, String string2) {
        Object object = ((zzt)this).zzg;
        synchronized (object) {
            boolean bl;
            String string3 = ((zzt)this).zzh;
            if (string3 != null) {
                return string3;
            }
            if (string2 == null) {
                return zzt.zzq();
            }
            try {
                zzck zzck2 = zzck.zza();
                boolean bl2 = TextUtils.isEmpty((CharSequence)zzck2.zza);
                if (bl2) {
                    Object object2;
                    bl2 = ClientLibraryUtils.isPackageSide();
                    if (bl2) {
                        Context context2 = context;
                        object2 = (String)zzch.zza((Context)context2, (Callable)new zzci(context2));
                    } else {
                        object2 = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
                        object2 = (String)zzch.zza((Context)context, (Callable)new zzcj((Context)object2, context));
                    }
                    zzck2.zza = object2;
                }
                ((zzt)this).zzh = string3 = zzck2.zza;
            }
            catch (Exception exception) {}
            if (bl = TextUtils.isEmpty((CharSequence)((zzt)this).zzh)) {
                ((zzt)this).zzh = WebSettings.getDefaultUserAgent((Context)context);
            }
            if (bl = TextUtils.isEmpty((CharSequence)((zzt)this).zzh)) {
                ((zzt)this).zzh = zzt.zzq();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((zzt)this).zzh);
            stringBuilder.append(" (Mobile; ");
            stringBuilder.append(string2);
            ((zzt)this).zzh = stringBuilder.toString();
            try {
                boolean bl3 = Wrappers.packageManager((Context)context).isCallerInstantApp();
                if (bl3) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(((zzt)this).zzh);
                    stringBuilder2.append(";aia");
                    ((zzt)this).zzh = stringBuilder2.toString();
                }
            }
            catch (Exception exception) {
                com.google.android.gms.ads.internal.zzt.zzo().zzw(exception, "AdUtil.getUserAgent");
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append(((zzt)this).zzh);
            stringBuilder3.append(")");
            ((zzt)this).zzh = stringBuilder3.toString();
            return ((zzt)this).zzh;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List zzd() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator iterator = zzba.zza().zzb().iterator();
        block2: while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            object = zzful.zzc((zzftk)zzftk.zzc((char)',')).zzd((CharSequence)object).iterator();
            while (true) {
                if (!object.hasNext()) continue block2;
                String string2 = (String)object.next();
                try {
                    arrayList.add(Long.valueOf(string2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    com.google.android.gms.ads.internal.util.zze.zza("Experiment ID is not a number");
                    continue;
                }
                break;
            }
            break;
        }
        return arrayList;
    }

    static /* bridge */ /* synthetic */ void zze(zzt zzt2, boolean bl) {
        zzt2.zzf = bl;
    }

    public final void zzf(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection, boolean bl2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = zzt.zza(n);
        stringBuilder.append("HTTP timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" milliseconds.");
        zzcbn.zzi((String)stringBuilder.toString());
        httpURLConnection.setConnectTimeout(n2);
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(n2);
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getRequestProperty("User-Agent"))) {
            String string3 = ((zzt)((Object)string3)).zzc(context, string2);
            httpURLConnection.setRequestProperty("User-Agent", string3);
        }
        httpURLConnection.setUseCaches(false);
    }

    final /* synthetic */ void zzg(Context context, String string2, SharedPreferences sharedPreferences, String string3) {
        this.zzd.set(zzad.zzb(context, string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzh(Context context, @Nullable String string2, String object, Bundle bundle, boolean bl) {
        com.google.android.gms.ads.internal.zzt.zzp();
        bundle.putString("device", zzt.zzr());
        object = zzba.zza().zza();
        object = TextUtils.join((CharSequence)",", (Iterable)object);
        bundle.putString("eids", (String)object);
        if (bundle.isEmpty()) {
            zzcbn.zze((String)"Empty or null bundle.");
        } else {
            object = zzbdc.zzjP;
            object = (String)zzba.zzc().zza((zzbcu)object);
            if (!((zzt)object2).zze.getAndSet(true)) {
                ((zzt)object2).zzd.set(zzad.zza(context, (String)object, new zzm((zzt)object2, context, (String)object)));
            }
            bundle.putAll((Bundle)((zzt)object2).zzd.get());
        }
        zzay.zzb();
        Object object2 = new zzl(context, string2);
        zzcbg.zzw((Context)context, (String)string2, (String)"gmob-apps", (Bundle)bundle, (boolean)true, (zzcbf)object2);
    }

    public final boolean zzi(String string2) {
        Object object = zzbdc.zzab;
        object = (String)zzba.zzc().zza(object);
        return zzt.zzZ(string2, this.zzb, (String)object);
    }

    public final boolean zzj(String string2) {
        Object object = zzbdc.zzac;
        object = (String)zzba.zzc().zza(object);
        return zzt.zzZ(string2, this.zzc, (String)object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzZ(String string2, AtomicReference serializable, String string3) {
        void var1_4;
        Pattern pattern;
        block7: {
            void var2_6;
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return false;
                }
                try {
                    pattern = (Pattern)((AtomicReference)serializable).get();
                    if (pattern == null) break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
                boolean bl = var2_6.equals(pattern.pattern());
                if (bl) break block7;
            }
            Pattern pattern2 = Pattern.compile((String)var2_6);
            ((AtomicReference)serializable).set(pattern2);
            Pattern pattern3 = pattern2;
            return var1_4.matcher(string2).matches();
        }
        Pattern pattern4 = pattern;
        return var1_4.matcher(string2).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzk(Context context) {
        if (this.zzj) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        zzbdc.zza((Context)context);
        zzbcu zzbcu2 = zzbdc.zzkj;
        if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzq(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzq(this, null), intentFilter);
        }
        this.zzj = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"UnprotectedReceiver"})
    public final boolean zzl(Context context) {
        if (this.zzi) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        zzbdc.zza((Context)context);
        zzbcu zzbcu2 = zzbdc.zzkj;
        if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue() && Build.VERSION.SDK_INT >= 33) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzs(this, null), intentFilter, 4);
        } else {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzs(this, null), intentFilter);
        }
        this.zzi = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int zzm(Context context, Uri uri) {
        int n;
        if (context == null) {
            com.google.android.gms.ads.internal.util.zze.zza("Trying to open chrome custom tab on a null context");
            return 3;
        }
        if (!(context instanceof Activity)) {
            com.google.android.gms.ads.internal.util.zze.zza("Chrome Custom Tabs can only work with Activity context.");
            n = 2;
        } else {
            n = 0;
        }
        zzbcu zzbcu2 = zzbdc.zzeu;
        Boolean bl = (Boolean)zzba.zzc().zza(zzbcu2);
        zzbcu2 = zzbdc.zzev;
        if (bl.equals(zzba.zzc().zza(zzbcu2))) {
            n = 9;
        }
        if (n != 0) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(uri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return n;
        }
        Object object = zzbdc.zzeu;
        if (((Boolean)zzba.zzc().zza((zzbcu)object)).booleanValue()) {
            object = new zzbed();
            ((zzbed)object).zze(new zzo(zzt2, (zzbed)object, context, uri));
            ((zzbed)object).zzb((Activity)context);
        }
        zzt zzt2 = zzbdc.zzev;
        if (((Boolean)zzba.zzc().zza((zzbcu)zzt2)).booleanValue()) {
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
            customTabsIntent.intent.setPackage(zzhed.zza(context));
            customTabsIntent.launchUrl(context, uri);
        }
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzn(View view) {
        if ((view = view.getRootView()) == null) {
            return false;
        }
        if (!((view = view.getContext()) instanceof Activity)) return false;
        view = (Activity)view;
        if (view == null) {
            return false;
        }
        if ((view = view.getWindow()) == null) {
            return false;
        }
        view = view.getAttributes();
        if (view == null) return false;
        if ((view.flags & 0x80000) == 0) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final void zzo(Context object, Intent intent) {
        void var1_2;
        if (var1_2 == null) {
            return;
        }
        Bundle bundle = var1_2.getExtras() != null ? var1_2.getExtras() : new Bundle();
        bundle.putBinder("android.support.customtabs.extra.SESSION", null);
        String string2 = object.getPackageName();
        bundle.putString("com.android.browser.application_id", string2);
        var1_2.putExtras(bundle);
    }

    public static final String zzp(Context context) throws RemoteException {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        return zzt.zzY(zzt.zzX(context));
    }

    static final String zzq() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ");
        stringBuilder.append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ");
            stringBuilder.append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/");
                stringBuilder.append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    public static final String zzr() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static final DisplayMetrics zzs(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    protected static final int[] zzt() {
        return new int[]{0, 0};
    }

    public static final Map zzu(String string2) {
        JSONObject jSONObject;
        HashMap hashMap = new HashMap();
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            String string3 = "AdUtil.getMapOfFileNamesToKeysFromJsonString";
            com.google.android.gms.ads.internal.zzt.zzo().zzw(jSONException, string3);
            return hashMap;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            JSONArray jSONArray = jSONObject.optJSONArray(string4);
            if (jSONArray == null) continue;
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string5 = jSONArray.optString(i);
                if (string5 == null) continue;
                hashSet.add(string5);
            }
            hashMap.put(string4, hashSet);
        }
        return hashMap;
    }

    public static final long zzv(View view) {
        float f = Float.MAX_VALUE;
        while (view instanceof View) {
            View view2 = view;
            f = Math.min(f, view2.getAlpha());
            view = view2.getParent();
            if (!(f <= 0.0f)) continue;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return Math.round(f * 100.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final WebResourceResponse zzw(Context object, String object2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", com.google.android.gms.ads.internal.zzt.zzp().zzc((Context)object, (String)object2));
        hashMap.put("Cache-Control", "max-stale=3600");
        object2 = new zzbq((Context)object);
        object = ((zzbq)object2).zzb(0, string2, hashMap, null);
        object = (String)object.get(60L, TimeUnit.SECONDS);
        if (object == null) return null;
        try {
            return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(((String)object).getBytes("UTF-8")));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzcbn.zzk((String)"Could not fetch MRAID JS.", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String zzx() {
        void var0_2;
        Resources resources = com.google.android.gms.ads.internal.zzt.zzo().zze();
        if (resources == null) return var0_2;
        String string2 = resources.getString(R.string.s7);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final zzbt zzy(Context object) {
        void var0_4;
        Object obj;
        try {
            obj = object.getClassLoader().loadClass("com.google.android.gms.ads.internal.util.WorkManagerUtil").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            String string2 = "Failed to instantiate WorkManagerUtil";
            com.google.android.gms.ads.internal.zzt.zzo().zzw(exception, string2);
            return null;
        }
        if (!(obj instanceof IBinder)) {
            zzcbn.zzg((String)"Instantiated WorkManagerUtil not instance of IBinder.");
            return null;
        }
        IBinder iBinder = (IBinder)obj;
        if (iBinder == null) {
            return var0_4;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.ads.internal.util.IWorkManagerUtil");
        if (iInterface instanceof zzbt) {
            zzbt zzbt2 = (zzbt)iInterface;
            return var0_4;
        }
        zzbr zzbr2 = new zzbr(iBinder);
        return var0_4;
    }

    public static final boolean zzz(Context object, String string2) {
        Context context = zzbwo.zza(object);
        object = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string2, (String)object) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzA(Context context) {
        try {
            return DeviceProperties.isBstar((Context)context);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public static final boolean zzB(String string2) {
        int n;
        String[] stringArray;
        if (!zzcbm.zzk()) {
            return false;
        }
        Object object = zzbdc.zzeP;
        if (!((Boolean)zzba.zzc().zza((zzbcu)object)).booleanValue()) {
            return false;
        }
        object = zzbdc.zzeR;
        object = (String)zzba.zzc().zza((zzbcu)object);
        if (!((String)object).isEmpty()) {
            stringArray = ((String)object).split(";");
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(string2)) continue;
                return false;
            }
        }
        Object object2 = zzbdc.zzeQ;
        object2 = (String)zzba.zzc().zza((zzbcu)object2);
        if (((String)object2).isEmpty()) {
            return true;
        }
        stringArray = ((String)object2).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean zzC(Context context) {
        if (context == null) {
            return false;
        }
        return (context = zzt.zzW(context)) != null && context.isKeyguardLocked();
    }

    public static final boolean zzD(Context object) {
        try {
            object = object.getClassLoader();
            String string2 = "com.google.android.gms.ads.internal.ClientApi";
            ((ClassLoader)object).loadClass(string2);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzcbn.zzh((String)"Error loading class.", (Throwable)throwable);
            String string3 = "AdUtil.isLiteSdk";
            com.google.android.gms.ads.internal.zzt.zzo().zzw(throwable, string3);
            return false;
        }
    }

    public static final boolean zzE() {
        int n = Process.myUid();
        return n == 0 || n == 1000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzF(Context context) {
        try {
            block5: {
                boolean bl;
                Object object = (ActivityManager)context.getSystemService("activity");
                KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
                if (object == null || keyguardManager == null) {
                    return false;
                }
                if ((object = object.getRunningAppProcesses()) == null) {
                    return false;
                }
                object = object.iterator();
                while (bl = object.hasNext()) {
                    boolean bl2;
                    int n;
                    ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                    int n2 = Process.myPid();
                    if (n2 != (n = runningAppProcessInfo.pid)) continue;
                    int n3 = runningAppProcessInfo.importance;
                    if (n3 == 100 && (n3 = (int)(keyguardManager.inKeyguardRestrictedInputMode() ? 1 : 0)) == 0 && (context = (PowerManager)context.getSystemService("power")) != null && (bl2 = context.isScreenOn())) break block5;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final boolean zzG(Context context) {
        block3: {
            boolean bl;
            String string2;
            try {
                context = zzt.zzX(context);
                string2 = context.getString("com.google.android.gms.ads.INTEGRATION_MANAGER");
                bl = TextUtils.isEmpty((CharSequence)zzt.zzY((Bundle)context));
                if (!bl) break block3;
            }
            catch (RemoteException remoteException) {
                return false;
            }
            bl = TextUtils.isEmpty((CharSequence)string2);
            if (bl) break block3;
            return true;
        }
        return false;
    }

    public static final boolean zzH(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        if ((context = ((Activity)context).getWindow()) == null || context.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        context.getDecorView().getGlobalVisibleRect(rect, null);
        context.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzI(View object, int n, MotionEvent motionEvent) {
        int[] nArray = new int[2];
        Rect rect = new Rect();
        try {
            Object object2;
            Object object3;
            int n2;
            int n3;
            int n4;
            String string2;
            String string3 = object.getContext().getPackageName();
            boolean bl = object instanceof zzdqx;
            if (bl) {
                object = ((zzdqx)((Object)object)).getChildAt(0);
            }
            if ((bl = object instanceof zzg) || (bl = object instanceof NativeAdView)) {
                string2 = "NATIVE";
                n4 = 1;
            } else {
                string2 = "UNKNOWN";
                n4 = 0;
            }
            if ((n3 = object.getLocalVisibleRect(rect)) != 0) {
                n3 = rect.width();
                n2 = rect.height();
            } else {
                n3 = 0;
                n2 = 0;
            }
            com.google.android.gms.ads.internal.zzt.zzp();
            long l = zzt.zzv((View)object);
            object.getLocationOnScreen(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            boolean bl2 = object instanceof zzchs;
            String string4 = "none";
            if (bl2) {
                object3 = ((zzchs)object).zzP();
                if (object3 != null) {
                    object3 = ((zzfdy)object3).zzb;
                    Object object4 = object;
                    int n7 = object4.hashCode();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object3);
                    stringBuilder.append(":");
                    stringBuilder.append(n7);
                    object4.setContentDescription((CharSequence)stringBuilder.toString());
                } else {
                    object3 = string4;
                }
            } else {
                object3 = string4;
            }
            boolean bl3 = object instanceof zzcgm;
            String string5 = "none";
            if (bl3) {
                object2 = ((zzcgm)object).zzD();
                if (object2 != null) {
                    string2 = zzfdu.zza(((zzfdu)object2).zzb);
                    n4 = ((zzfdu)object2).zzf;
                    object2 = ((zzfdu)object2).zzF;
                } else {
                    object2 = string5;
                }
            } else {
                object2 = string5;
            }
            object = String.format(Locale.US, "<Ad hashCode=%d, package=%s, adNetCls=%s, gwsQueryId=%s, format=%s, impType=%d, class=%s, x=%d, y=%d, width=%d, height=%d, vWidth=%d, vHeight=%d, alpha=%d, state=%s>", object.hashCode(), string3, object2, object3, string2, n4, object.getClass().getName(), n5, n6, object.getWidth(), object.getHeight(), n3, n2, l, Integer.toString(n, 2));
            zzcbn.zzi((String)object);
            return;
        }
        catch (Exception exception) {
            zzcbn.zzh((String)"Failure getting view location.", (Throwable)exception);
            return;
        }
    }

    public static final AlertDialog.Builder zzJ(Context context) {
        return new AlertDialog.Builder(context, com.google.android.gms.ads.internal.zzt.zzq().zza());
    }

    public static final void zzK(Context context, String string2, String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        for (String string3 : arrayList) {
            new zzca(context, string2, string3).zzb();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzL(Context context, Throwable throwable) {
        block4: {
            block3: {
                if (context != null) {
                    try {
                        boolean bl = (Boolean)zzbfe.zzb.zze();
                        if (!bl) break block3;
                        break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return;
                    }
                }
            }
            return;
        }
        CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable);
    }

    private static final void zzaa(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static final String zzM(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static final int zzN(String string2) {
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            zzcbn.zzj((String)"Could not parse value:".concat(((Object)numberFormatException).toString()));
            return 0;
        }
    }

    @Nullable
    public static final Map zzO(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : uri.getQueryParameterNames()) {
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            String string3 = string2;
            hashMap.put(string3, uri.getQueryParameter(string3));
        }
        return hashMap;
    }

    public static final int[] zzP(Activity activity) {
        if ((activity = activity.getWindow()) != null && (activity = activity.findViewById(0x1020002)) != null) {
            return new int[]{activity.getWidth(), activity.getHeight()};
        }
        return zzt.zzt();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int[] zzQ(Activity activity) {
        void var1_4;
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray = new int[]{view.getTop(), view.getBottom()};
            return new int[]{zzay.zzb().zzb((Context)activity, (int)var1_4[0]), zzay.zzb().zzb((Context)activity, (int)var1_4[1])};
        }
        int[] nArray = zzt.zzt();
        return new int[]{zzay.zzb().zzb((Context)activity, (int)var1_4[0]), zzay.zzb().zzb((Context)activity, (int)var1_4[1])};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean zzR(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = !com.google.android.gms.ads.internal.zzt.zzp().zzf ? (keyguardManager == null ? true : (keyguardManager.inKeyguardRestrictedInputMode() ? zzt.zzn(view) : true)) : true;
        long l = zzt.zzv(view);
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        if (powerManager != null && !powerManager.isScreenOn()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        powerManager = zzbdc.zzbj;
        if (((Boolean)zzba.zzc().zza((zzbcu)powerManager)).booleanValue() && !view.getLocalVisibleRect(new Rect()) && !view.getGlobalVisibleRect(new Rect())) {
            return false;
        }
        view = zzbdc.zzjS;
        if ((Boolean)zzba.zzc().zza((zzbcu)view) == false) return true;
        view = zzbdc.zzjU;
        if (l >= (long)((Integer)zzba.zzc().zza((zzbcu)view)).intValue()) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void zzS(Context context, Intent object) {
        zzbcu zzbcu2 = zzbdc.zzkk;
        if (!((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) {
            zzt.zzaa(context, (Intent)object);
            return;
        }
        try {
            zzt.zzaa(context, (Intent)object);
            return;
        }
        catch (SecurityException securityException) {
            zzcbn.zzk((String)"", (Throwable)securityException);
            object = "AdUtil.startActivityWithUnknownContext";
            com.google.android.gms.ads.internal.zzt.zzo().zzw(securityException, (String)object);
            return;
        }
    }

    public static final void zzT(Context object, Uri uri) {
        try {
            Context context = object;
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzt.zzo(context, intent);
            bundle.putString("com.android.browser.application_id", object.getPackageName());
            context.startActivity(intent);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Opening ");
            stringBuilder.append(uri.toString());
            stringBuilder.append(" in a new browser.");
            object = stringBuilder.toString();
            zzcbn.zze((String)object);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzcbn.zzh((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    public static final int[] zzU(Activity activity) {
        int[] nArray = zzt.zzP(activity);
        return new int[]{zzay.zzb().zzb((Context)activity, nArray[0]), zzay.zzb().zzb((Context)activity, nArray[1])};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean zzV(View view, Context context) {
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            context2 = (PowerManager)context2.getSystemService("power");
            return zzt.zzR(view, (PowerManager)context2, zzt.zzW(context));
        }
        context2 = null;
        return zzt.zzR(view, (PowerManager)context2, zzt.zzW(context));
    }
}

