/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzdd;
import com.google.android.gms.internal.ads.zzdt;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzen;
import com.google.android.gms.internal.ads.zzik;
import com.google.android.gms.internal.ads.zzil;
import com.google.android.gms.internal.ads.zzip;
import com.google.android.gms.internal.ads.zzit;
import com.google.android.gms.internal.ads.zzkh;
import com.google.android.gms.internal.ads.zzkk;
import com.google.android.gms.internal.ads.zzt;

final class zzkl {
    private final Context zza;
    private final Handler zzb;
    private final zzkh zzc;
    private final AudioManager zzd;
    @Nullable
    private zzkk zze;
    private int zzf;
    private int zzg;
    private boolean zzh;

    public final int zza() {
        return this.zzd.getStreamMaxVolume(this.zzf);
    }

    public final int zzb() {
        if (zzen.zza >= 28) {
            return this.zzd.getStreamMinVolume(this.zzf);
        }
        return 0;
    }

    private static int zzg(AudioManager audioManager, int n) {
        try {
            int n2 = audioManager.getStreamVolume(n);
            return n2;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not retrieve stream volume for stream type ");
            stringBuilder.append(n);
            zzdw.zzf("StreamVolumeManager", stringBuilder.toString(), runtimeException);
            return audioManager.getStreamMaxVolume(n);
        }
    }

    static /* bridge */ /* synthetic */ Handler zzc(zzkl zzkl2) {
        return zzkl2.zzb;
    }

    static /* bridge */ /* synthetic */ void zzd(zzkl zzkl2) {
        zzkl2.zzh();
    }

    public zzkl(Context object, Handler handler, zzkh zzkh2) {
        this.zza = object.getApplicationContext();
        this.zzb = handler;
        this.zzc = zzkh2;
        object = (AudioManager)this.zza.getSystemService("audio");
        zzdd.zzb(object);
        this.zzd = object;
        this.zzf = 3;
        this.zzg = zzkl.zzg(this.zzd, 3);
        this.zzh = zzkl.zzi(this.zzd, this.zzf);
        super(this, null);
        super("android.media.VOLUME_CHANGED_ACTION");
        try {
            zzen.zzA(this.zza, (BroadcastReceiver)object, (IntentFilter)handler);
            this.zze = object;
            return;
        }
        catch (RuntimeException runtimeException) {
            zzdw.zzf("StreamVolumeManager", "Error registering stream volume receiver", runtimeException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze() {
        zzkk zzkk2 = this.zze;
        if (zzkk2 == null) {
            return;
        }
        try {
            Context context = this.zza;
            context.unregisterReceiver((BroadcastReceiver)zzkk2);
        }
        catch (RuntimeException runtimeException) {
            zzdw.zzf("StreamVolumeManager", "Error unregistering stream volume receiver", runtimeException);
        }
        this.zze = null;
    }

    public final void zzf(int n) {
        if (((zzkl)object).zzf == 3) {
            return;
        }
        ((zzkl)object).zzf = 3;
        ((zzkl)object).zzh();
        Object object = ((zzkl)object).zzc;
        zzt zzt2 = zzit.zzy(zzit.zzB(((zzip)object).zza));
        if (!zzt2.equals(zzit.zzx(((zzip)object).zza))) {
            zzit.zzG(((zzip)object).zza, zzt2);
            object = zzit.zzz(((zzip)object).zza);
            zzil zzil2 = new zzil(zzt2);
            ((zzdt)object).zzd(29, zzil2);
            ((zzdt)object).zzc();
            return;
        }
    }

    private final void zzh() {
        int n = zzkl.zzg(((zzkl)((Object)zzdt2)).zzd, ((zzkl)((Object)zzdt2)).zzf);
        boolean bl = zzkl.zzi(((zzkl)((Object)zzdt2)).zzd, ((zzkl)((Object)zzdt2)).zzf);
        if (((zzkl)((Object)zzdt2)).zzg != n || ((zzkl)((Object)zzdt2)).zzh != bl) {
            ((zzkl)((Object)zzdt2)).zzg = n;
            ((zzkl)((Object)zzdt2)).zzh = bl;
            zzdt zzdt2 = zzit.zzz(((zzip)((zzkl)((Object)zzdt2)).zzc).zza);
            zzik zzik2 = new zzik(n, bl);
            zzdt2.zzd(30, zzik2);
            zzdt2.zzc();
            return;
        }
    }

    private static boolean zzi(AudioManager audioManager, int n) {
        if (zzen.zza >= 23) {
            return audioManager.isStreamMute(n);
        }
        return zzkl.zzg(audioManager, n) == 0;
    }
}

