/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgog;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class zzgoe {
    public static int zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzgoe.zzb(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    public static BigInteger zzb(EllipticCurve object) throws GeneralSecurityException {
        if (!((object = ((EllipticCurve)object).getField()) instanceof ECFieldFp)) {
            object = new GeneralSecurityException("Only curves over prime order fields are supported");
            throw object;
        }
        return ((ECFieldFp)object).getP();
    }

    public static KeyPair zzc(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)zzgog.zzf.zza("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    private static ECParameterSpec zzm(String object, String object2, String object3, String object4, String object5) {
        Object object6 = new BigInteger((String)object);
        object = new BigInteger((String)object2);
        object2 = new BigInteger("3");
        object2 = ((BigInteger)object6).subtract((BigInteger)object2);
        BigInteger bigInteger = new BigInteger((String)object3, 16);
        object3 = new BigInteger((String)object4, 16);
        object4 = new BigInteger((String)object5, 16);
        object5 = new ECFieldFp((BigInteger)object6);
        object6 = new EllipticCurve((ECField)object5, (BigInteger)object2, bigInteger);
        object2 = new ECPoint((BigInteger)object3, (BigInteger)object4);
        object3 = new ECParameterSpec((EllipticCurve)object6, (ECPoint)object2, (BigInteger)object, 1);
        return object3;
    }

    static void zzd(ECPoint object, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger = zzgoe.zzb(ellipticCurve);
        BigInteger bigInteger2 = ((ECPoint)object).getAffineX();
        object = ((ECPoint)object).getAffineY();
        if (bigInteger2 == null || object == null) {
            object = new GeneralSecurityException("point is at infinity");
            throw object;
        }
        if (bigInteger2.signum() == -1 || bigInteger2.compareTo(bigInteger) >= 0) {
            object = new GeneralSecurityException("x is out of range");
            throw object;
        }
        if (((BigInteger)object).signum() == -1 || ((BigInteger)object).compareTo(bigInteger) >= 0) {
            object = new GeneralSecurityException("y is out of range");
            throw object;
        }
        if (!((BigInteger)object).multiply((BigInteger)object).mod(bigInteger).equals(bigInteger2.multiply(bigInteger2).add(ellipticCurve.getA()).multiply(bigInteger2).add(ellipticCurve.getB()).mod(bigInteger))) {
            object = new GeneralSecurityException("Point is not on curve");
            throw object;
        }
    }

    public static void zze(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        zzgoe.zzf(eCPublicKey, eCPrivateKey);
        zzgoe.zzd(eCPublicKey.getW(), eCPrivateKey.getParams().getCurve());
    }

    static void zzf(ECPublicKey object, ECPrivateKey object2) throws GeneralSecurityException {
        block7: {
            block6: {
                object = object.getParams();
                object2 = object2.getParams();
                boolean bl = ((ECParameterSpec)object).getCurve().equals(((ECParameterSpec)object2).getCurve());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getGenerator().equals(((ECParameterSpec)object2).getGenerator());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getOrder().equals(((ECParameterSpec)object2).getOrder());
                if (!bl) break block6;
                int n = ((ECParameterSpec)object).getCofactor();
                int n2 = ((ECParameterSpec)object2).getCofactor();
                if (n == n2) break block7;
            }
            try {
                GeneralSecurityException generalSecurityException = new GeneralSecurityException("invalid public key spec");
                throw generalSecurityException;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                GeneralSecurityException generalSecurityException = new GeneralSecurityException(runtimeException);
                throw generalSecurityException;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zzg(ECPrivateKey var0, ECPublicKey var1_3) throws GeneralSecurityException {
        zzgoe.zzf((ECPublicKey)var1_3, (ECPrivateKey)var0);
        var1_3 = var1_3.getW();
        zzgoe.zzd((ECPoint)var1_3, var0.getParams().getCurve());
        var2_9 = var0.getParams();
        var3_12 = new ECPublicKeySpec((ECPoint)var1_3, (ECParameterSpec)var2_9);
        var1_3 = ((KeyFactory)zzgog.zzg.zza("EC")).generatePublic(var3_12);
        var2_9 = (KeyAgreement)zzgog.zze.zza("ECDH");
        var2_9.init((Key)var0);
        try {
            block21: {
                block19: {
                    block20: {
                        block18: {
                            block17: {
                                var2_9.doPhase((Key)var1_3, true);
                                var4_17 = var2_9.generateSecret();
                                var0 = var0.getParams().getCurve();
                                var1_3 = new BigInteger(1, var4_17);
                                var2_10 = var1_3.signum();
                                if (var2_10 == -1 || (var2_10 = var1_3.compareTo(zzgoe.zzb((EllipticCurve)var0))) >= 0) {
                                    var0 = new GeneralSecurityException("shared secret is out of range");
                                    throw var0;
                                }
                                var5_18 = zzgoe.zzb((EllipticCurve)var0);
                                var2_11 = var0.getA();
                                var0 = var0.getB();
                                var0 = var1_3.multiply((BigInteger)var1_3).add(var2_11).multiply((BigInteger)var1_3).add((BigInteger)var0).mod(var5_18);
                                var1_4 = var5_18.signum();
                                if (var1_4 != 1) {
                                    var0 = new InvalidAlgorithmParameterException("p must be positive");
                                    throw var0;
                                }
                                var6_19 = var0.mod(var5_18);
                                var0_1 = var6_19.equals(BigInteger.ZERO);
                                if (!var0_1) break block17;
                                var0 = BigInteger.ZERO;
                                ** GOTO lbl49
                            }
                            var0_1 = var5_18.testBit(0);
                            if (!var0_1 || !(var0_1 = var5_18.testBit(1))) break block18;
                            var0 = var6_19.modPow(var5_18.add(BigInteger.ONE).shiftRight(2), var5_18);
                            break block19;
                        }
                        var0_1 = var5_18.testBit(0);
                        if (!var0_1) break block20;
                        var0_1 = var5_18.testBit(1);
                        if (!var0_1) break block21;
                        var0 = null;
                        break block19;
                    }
                    var0 = null;
                }
lbl47:
                // 2 sources

                while (true) {
                    block22: {
                        if (var0 != null && (var1_6 = var0.multiply((BigInteger)var0).mod(var5_18).compareTo(var6_19)) != 0) break block22;
lbl49:
                        // 3 sources

                        while (true) {
                            var1_5 = var0.testBit(0);
                            if (!var1_5) {
                                var5_18.subtract((BigInteger)var0).mod(var5_18);
                            }
                            return var4_17;
                        }
                    }
                    var0 = new GeneralSecurityException("Could not find a modular square root");
                    throw var0;
                }
            }
            var0 = BigInteger.ONE;
            var2_11 = var5_18.subtract(BigInteger.ONE).shiftRight(1);
            var1_4 = 0;
            do {
                if (var3_13 = (var7_20 = var0.multiply((BigInteger)var0).subtract(var6_19).mod(var5_18)).equals(BigInteger.ZERO)) ** continue;
                var3_14 = var7_20.modPow(var2_11, var5_18);
                var8_21 = var3_14.add(BigInteger.ONE).equals(var5_18);
                if (var8_21) {
                    var8_22 = var5_18.add(BigInteger.ONE).shiftRight(1);
                    var2_11 = BigInteger.ONE;
                    var1_4 = var8_22.bitLength();
                    var1_7 = var0;
                    for (var3_15 = var1_4 + -2; var3_15 >= 0; --var3_15) {
                        var9_23 = var1_7.multiply(var2_11);
                        var1_7 = var1_7.multiply((BigInteger)var1_7).add(var2_11.multiply(var2_11).mod(var5_18).multiply(var7_20)).mod(var5_18);
                        var2_11 = var9_23.add(var9_23).mod(var5_18);
                        var9_24 = var8_22.testBit(var3_15);
                        if (!var9_24) continue;
                        var9_25 = var1_7.multiply((BigInteger)var0).add(var2_11.multiply(var7_20)).mod(var5_18);
                        var2_11 = var0.multiply(var2_11).add((BigInteger)var1_7).mod(var5_18);
                        var1_7 = var9_25;
                    }
                    var0 = var1_7;
                    ** continue;
                }
                var3_16 = var3_14.equals(BigInteger.ONE);
                if (!var3_16) {
                    var0 = new InvalidAlgorithmParameterException("p is not prime");
                    throw var0;
                }
                var0 = var0.add(BigInteger.ONE);
            } while (++var1_4 != 128 || (var3_16 = var5_18.isProbablePrime(80)));
            var0 = new InvalidAlgorithmParameterException("p is not prime");
            throw var0;
        }
        catch (IllegalStateException var0_2) {
            var1_8 = new GeneralSecurityException(var0_2);
            throw var1_8;
        }
    }

    public static ECPrivateKey zzh(int n, byte[] object) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzgoe.zzk(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new ECPrivateKeySpec;
        object(bigInteger, eCParameterSpec);
        return (ECPrivateKey)((KeyFactory)zzgog.zzg.zza("EC")).generatePrivate((KeySpec)object);
    }

    public static ECPublicKey zzi(int n, byte[] object, byte[] object2) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzgoe.zzk(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new BigInteger;
        object(1, (byte[])object2);
        object2 = new ECPoint;
        object2(bigInteger, (BigInteger)object);
        zzgoe.zzd((ECPoint)object2, eCParameterSpec.getCurve());
        object = new ECPublicKeySpec;
        object((ECPoint)object2, eCParameterSpec);
        return (ECPublicKey)((KeyFactory)zzgog.zzg.zza("EC")).generatePublic((KeySpec)object);
    }

    public static ECPublicKey zzj(ECParameterSpec object, int n, byte[] object2) throws GeneralSecurityException {
        int n2 = ((byte[])object2).length;
        Object object3 = ((ECParameterSpec)object).getCurve();
        int n3 = zzgoe.zza((EllipticCurve)object3);
        if (n2 != n3 + n3 + 1) {
            object = new GeneralSecurityException("invalid point size");
            throw object;
        }
        if (object2[0] != 4) {
            object = new GeneralSecurityException("invalid point format");
            throw object;
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object2, 1, ++n3));
        BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(object2, n3, n2));
        object2 = new ECPoint;
        object2(bigInteger, bigInteger2);
        zzgoe.zzd((ECPoint)object2, (EllipticCurve)object3);
        object3 = new ECPublicKeySpec((ECPoint)object2, (ECParameterSpec)object);
        return (ECPublicKey)((KeyFactory)zzgog.zzg.zza("EC")).generatePublic((KeySpec)object3);
    }

    public static ECParameterSpec zzk(int n) throws NoSuchAlgorithmException {
        switch (n + -1) {
            default: {
                return zzgoe.zzm("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", "c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", "11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650");
            }
            case 0: {
                return zzgoe.zzm("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5");
            }
            case 1: 
        }
        return zzgoe.zzm("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", "aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", "3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] zzl(EllipticCurve object, int n, ECPoint object2) throws GeneralSecurityException {
        zzgoe.zzd((ECPoint)object2, (EllipticCurve)object);
        int n2 = zzgoe.zza((EllipticCurve)object);
        switch (n + -1) {
            default: {
                int n3 = n2 + 1;
                byte[] byArray = new byte[n3];
                byte[] byArray2 = ((ECPoint)object2).getAffineX().toByteArray();
                int n4 = byArray2.length;
                System.arraycopy(byArray2, 0, byArray, n3 - n4, n4);
                n3 = true != ((ECPoint)object2).getAffineY().testBit(0) ? 2 : 3;
                byArray[0] = n3;
                return byArray;
            }
            case 2: {
                byte[] byArray;
                int n5;
                byte[] byArray3 = new byte[n2 + n2];
                object = ((ECPoint)object2).getAffineX().toByteArray();
                n = ((Object)object).length;
                if (n > n2) {
                    object = Arrays.copyOfRange((byte[])object, n - n2, n);
                }
                if ((n5 = (byArray = ((ECPoint)object2).getAffineY().toByteArray()).length) > n2) {
                    byArray = Arrays.copyOfRange(byArray, n5 - n2, n5);
                }
                n5 = byArray.length;
                System.arraycopy(byArray, 0, byArray3, n2 + n2 - n5, n5);
                int n6 = ((Object)object).length;
                System.arraycopy(object, 0, byArray3, n2 - n6, n6);
                return byArray3;
            }
            case 0: 
        }
        int n7 = n2 + n2 + 1;
        byte[] byArray = new byte[n7];
        byte[] byArray4 = ((ECPoint)object2).getAffineX().toByteArray();
        object2 = ((ECPoint)object2).getAffineY().toByteArray();
        int n8 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray, n7 - n8, n8);
        n7 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray, n2 + 1 - n7, n7);
        byArray[0] = 4;
        return byArray;
    }
}

