/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgdk;
import com.google.android.gms.internal.ads.zzgdp;
import com.google.android.gms.internal.ads.zzgds;
import com.google.android.gms.internal.ads.zzgnv;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;

abstract class zzgdm {
    private final zzgdk zza;
    private final zzgdk zzb;

    abstract zzgdk zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzgdm(byte[] byArray) throws GeneralSecurityException {
        if (!zzgds.zza(1)) {
            Object object = new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
            throw object;
        }
        ((zzgdm)object).zza = ((zzgdm)object).zza(byArray, 1);
        ((zzgdm)object).zzb = ((zzgdm)object).zza(byArray, 0);
    }

    public final void zzb(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        Object object;
        if (byteBuffer.remaining() < byArray2.length + 16) {
            object = new IllegalArgumentException("Given ByteBuffer output is too small");
            throw object;
        }
        int n = byteBuffer.position();
        ((zzgdm)object).zza.zzd(byteBuffer, byArray, byArray2);
        byteBuffer.position(n);
        byteBuffer.limit(byteBuffer.limit() + -16);
        object = super.zze(byArray);
        byArray = zzgdm.zzf(byArray3, byteBuffer);
        object = zzgdp.zza((byte[])object, byArray);
        byteBuffer.limit(byteBuffer.limit() + 16);
        byteBuffer.put((byte[])object);
    }

    public final byte[] zzc(ByteBuffer object, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        block5: {
            Object object2;
            if (((Buffer)object).remaining() < 16) {
                object2 = new GeneralSecurityException("ciphertext too short");
                throw object2;
            }
            n = ((Buffer)object).position();
            byte[] byArray3 = new byte[16];
            ((ByteBuffer)object).position(((Buffer)object).limit() + -16);
            ((ByteBuffer)object).get(byArray3);
            ((ByteBuffer)object).position(n);
            ((ByteBuffer)object).limit(((Buffer)object).limit() + -16);
            if (byArray2 == null) {
                byArray2 = new byte[]{};
            }
            try {
                byte[] byArray4 = super.zze(byArray);
                byArray2 = zzgdm.zzf(byArray2, (ByteBuffer)object);
                boolean bl = zzgnv.zzb(zzgdp.zza(byArray4, byArray2), byArray3);
                if (bl) break block5;
            }
            catch (GeneralSecurityException generalSecurityException) {
                object = new AEADBadTagException(generalSecurityException.toString());
                throw object;
            }
            object2 = new GeneralSecurityException("invalid MAC");
            throw object2;
        }
        ((ByteBuffer)object).position(n);
        return ((zzgdm)object2).zza.zze(byArray, (ByteBuffer)object);
    }

    public final byte[] zzd(byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        int n = byArray2.length;
        if (n > 0x7FFFFFEF) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n + 16);
        ((zzgdm)object).zzb(byteBuffer, byArray, byArray2, byArray3);
        return byteBuffer.array();
    }

    private final byte[] zze(byte[] byArray) throws GeneralSecurityException {
        Object object = ((zzgdm)object).zzb;
        object = ((zzgdk)object).zzc(byArray, 0);
        byArray = new byte[32];
        ((ByteBuffer)object).get(byArray);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] zzf(byte[] byArray, ByteBuffer byteBuffer) {
        int n = byArray.length;
        int n2 = n & 0xF;
        n2 = n2 == 0 ? n : n + 16 - n2;
        int n3 = byteBuffer.remaining();
        int n4 = n3 % 16;
        n4 = n4 == 0 ? n3 : n3 + 16 - n4;
        n4 = n2 + n4;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4 + 16).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(byArray);
        byteBuffer2.position(n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n4);
        byteBuffer2.putLong(n);
        byteBuffer2.putLong(n3);
        return byteBuffer2.array();
    }
}

