/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgdg;
import com.google.android.gms.internal.ads.zzgnv;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzgdk {
    int[] zza;
    private final int zzb;

    abstract int zza();

    final ByteBuffer zzc(byte[] objectArray, int n) {
        objectArray = this.zzb(zzgdg.zzd(objectArray), n);
        int[] nArray = (int[])objectArray.clone();
        zzgdg.zzc(nArray);
        for (int i = 0; i < 16; ++i) {
            objectArray[i] = objectArray[i] + nArray[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])objectArray, 0, 16);
        return byteBuffer;
    }

    public zzgdk(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            Object object = new InvalidKeyException("The key length in bytes must be 32.");
            throw object;
        }
        ((zzgdk)object).zza = zzgdg.zzd(byArray);
        ((zzgdk)object).zzb = n;
    }

    public final void zzd(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byteBuffer.remaining() < byArray2.length) {
            Object object = new IllegalArgumentException("Given ByteBuffer output is too small");
            throw object;
        }
        ((zzgdk)object).zzf(byArray, byteBuffer, ByteBuffer.wrap(byArray2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zzf(byte[] object, ByteBuffer comparable, ByteBuffer byteBuffer) throws GeneralSecurityException {
        void var3_4;
        StringBuilder stringBuilder;
        if (((byte[])object).length != this.zza()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("The nonce length (in bytes) must be ");
            stringBuilder.append(this.zza());
            GeneralSecurityException generalSecurityException = new GeneralSecurityException(stringBuilder.toString());
            throw generalSecurityException;
        }
        int n = var3_4.remaining();
        int n2 = n / 64 + 1;
        int n3 = 0;
        while (n3 < n2) {
            ByteBuffer byteBuffer2 = this.zzc((byte[])object, n3 + this.zzb);
            if (n3 == n2 + -1) {
                zzgnv.zza((ByteBuffer)((Object)stringBuilder), (ByteBuffer)var3_4, byteBuffer2, n % 64);
            } else {
                zzgnv.zza((ByteBuffer)((Object)stringBuilder), (ByteBuffer)var3_4, byteBuffer2, 64);
            }
            ++n3;
        }
        return;
    }

    public final byte[] zze(byte[] byArray, ByteBuffer byteBuffer) throws GeneralSecurityException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        this.zzf(byArray, byteBuffer2, byteBuffer);
        return byteBuffer2.array();
    }

    abstract int[] zzb(int[] var1, int var2);
}

