/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzamk;
import com.google.android.gms.internal.ads.zzana;
import com.google.android.gms.internal.ads.zzfmx;
import com.google.android.gms.internal.ads.zzfmz;
import com.google.android.gms.internal.ads.zzfnf;
import com.google.android.gms.internal.ads.zzfnk;
import com.google.android.gms.internal.ads.zzfnl;
import com.google.android.gms.internal.ads.zzfnm;
import com.google.android.gms.internal.ads.zzfnn;
import com.google.android.gms.internal.ads.zzfno;
import com.google.android.gms.internal.ads.zzfnp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfnq {
    private final Context zza;
    private final Executor zzb;
    private final zzfmx zzc;
    private final zzfmz zzd;
    private final zzfnp zze;
    private final zzfnp zzf;
    private Task zzg;
    private Task zzh;

    public final zzana zza() {
        return zzfnq.zzg(this.zzg, this.zze.zza());
    }

    public final zzana zzb() {
        return zzfnq.zzg(this.zzh, this.zzf.zza());
    }

    private static zzana zzg(@NonNull Task task, @NonNull zzana zzana2) {
        if (!task.isSuccessful()) {
            return zzana2;
        }
        return (zzana)task.getResult();
    }

    final /* synthetic */ zzana zzc() throws Exception {
        Object object = ((zzfnq)object).zza;
        zzamk zzamk2 = zzana.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)object);
        if ((object = info.getId()) != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzamk2.zzs((String)object);
            zzamk2.zzr(info.isLimitAdTrackingEnabled());
            zzamk2.zzab(6);
        }
        return (zzana)zzamk2.zzam();
    }

    final /* synthetic */ zzana zzd() throws Exception {
        zzfnq zzfnq2 = zzfnq2.zza;
        PackageManager packageManager = zzfnq2.getPackageManager();
        String string2 = zzfnq2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzfnf.zza((Context)zzfnq2, zzfnq2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzfnq zze(@NonNull Context object, @NonNull Executor executor, @NonNull zzfmx zzfmx2, @NonNull zzfmz zzfmz2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzfnn zzfnn2 = new zzfnn();
        zzfno zzfno2 = new zzfno();
        zzfnq zzfnq2 = new zzfnq((Context)object, (Executor)var1_4, (zzfmx)var2_5, (zzfmz)var3_6, zzfnn2, zzfno2);
        if (zzfnq2.zzd.zzd()) {
            zzfnk zzfnk2 = new zzfnk(zzfnq2);
            zzfnq2.zzg = zzfnq2.zzh(zzfnk2);
        } else {
            zzfnq2.zzg = Tasks.forResult((Object)zzfnq2.zze.zza());
        }
        zzfnl zzfnl2 = new zzfnl(zzfnq2);
        zzfnq2.zzh = zzfnq2.zzh(zzfnl2);
        return zzfnq2;
    }

    private final Task zzh(@NonNull Callable callable) {
        Executor executor = this.zzb;
        callable = Tasks.call((Executor)executor, (Callable)callable);
        executor = this.zzb;
        zzfnm zzfnm2 = new zzfnm(this);
        return callable.addOnFailureListener(executor, zzfnm2);
    }

    @VisibleForTesting
    zzfnq(Context context, Executor executor, zzfmx zzfmx2, zzfmz zzfmz2, zzfnn zzfnn2, zzfno zzfno2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfmx2;
        this.zzd = zzfmz2;
        this.zze = zzfnn2;
        this.zzf = zzfno2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

