/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.internal.ads.zzad;
import com.google.android.gms.internal.ads.zzaf;
import com.google.android.gms.internal.ads.zzca;
import com.google.android.gms.internal.ads.zzcc;
import com.google.android.gms.internal.ads.zzcg;
import com.google.android.gms.internal.ads.zzdd;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzem;
import com.google.android.gms.internal.ads.zzfse;
import com.google.android.gms.internal.ads.zzfsk;
import com.google.android.gms.internal.ads.zzm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzen {
    public static final int zza;
    public static final String zzb;
    public static final String zzc;
    public static final String zzd;
    public static final String zze;
    public static final byte[] zzf;
    private static final Pattern zzg;
    private static final Pattern zzh;
    private static final Pattern zzi;
    private static final Pattern zzj;
    @Nullable
    private static HashMap zzk;
    private static final String[] zzl;
    private static final String[] zzm;
    private static final int[] zzn;
    private static final int[] zzo;

    public static float zza(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f, f3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzb(long[] lArray, long l, boolean bl, boolean n) {
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            return ~n;
        }
        while (++n < lArray.length && lArray[n] == l) {
        }
        if (bl) return n + -1;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzc(int[] nArray, int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = Arrays.binarySearch(nArray, n);
        if (n3 < 0) {
            n2 = -(n3 + 2);
        } else {
            while (--n3 >= 0 && nArray[n3] == n) {
            }
            n2 = bl ? n3 + 1 : n3;
        }
        if (bl2) {
            return Math.max(0, n2);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzd(long[] lArray, long l, boolean n, boolean bl) {
        int n2;
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            n2 = -(n + 2);
        } else {
            while (--n >= 0 && lArray[n] == l) {
            }
            n2 = n + 1;
        }
        if (bl) {
            return Math.max(0, n2);
        }
        return n2;
    }

    public static int zze(int n, int n2) {
        return (n + n2 + -1) / n2;
    }

    public static int zzf(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    public static int zzg(byte[] byArray, int n, int n2, int n3) {
        n = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            n = n << 8 ^ zzn[n >>> 24 ^ byArray[n3] & 0xFF];
        }
        return n;
    }

    public static int zzh(byte[] byArray, int n, int n2, int n3) {
        n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = zzo[n3 ^ byArray[i] & 0xFF];
        }
        return n3;
    }

    @RequiresApi(value=21)
    public static int zzi(Context context) {
        if ((context = (AudioManager)context.getSystemService("audio")) == null) {
            return -1;
        }
        return context.generateAudioSessionId();
    }

    public static int zzj(int n) {
        switch (n) {
            case 8: {
                n = zza;
                if (n >= 23) {
                    return 6396;
                }
                if (n >= 21) {
                    return 6396;
                }
                return 0;
            }
            case 12: {
                if (zza >= 32) {
                    return 743676;
                }
                return 0;
            }
            default: {
                return 0;
            }
            case 7: {
                return 1276;
            }
            case 6: {
                return 252;
            }
            case 5: {
                return 220;
            }
            case 4: {
                return 204;
            }
            case 3: {
                return 28;
            }
            case 2: {
                return 12;
            }
            case 1: 
        }
        return 4;
    }

    public static int zzk(ByteBuffer byteBuffer, int n) {
        n = byteBuffer.getInt(n);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    public static int zzl(int n) {
        switch (n) {
            default: {
                return 6006;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 6002;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return 6004;
            }
            case 8: 
            case 15: {
                return 6003;
            }
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 18: 
        }
        return 6005;
    }

    /*
     * Unable to fully structure code
     */
    public static int zzm(@Nullable String var0) {
        block9: {
            block7: {
                block8: {
                    if (var0 == null) {
                        return 0;
                    }
                    var1_2 = (var0 = var0.split("_", -1)).length;
                    if (var1_2 < 2) {
                        return 0;
                    }
                    var2_3 = var0[var1_2 + -1];
                    if (var1_2 < 3) break block7;
                    if (!"neg".equals(var0[var1_2 + -2])) break block8;
                    var0_1 = true;
lbl10:
                    // 3 sources

                    while (var2_3 != null) {
                        block6: {
                            var1_2 = Integer.parseInt(var2_3);
                            if (!var0_1) break block6;
                            return -var1_2;
                        }
                        return var1_2;
                    }
                    break block9;
                }
                var0_1 = false;
                ** GOTO lbl10
            }
            var0_1 = false;
            ** GOTO lbl10
        }
        try {
            throw null;
        }
        catch (NumberFormatException v0) {
            return 0;
        }
    }

    public static int zzn(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 32: {
                return 0x30000000;
            }
            case 24: {
                return 0x20000000;
            }
            case 16: {
                return 2;
            }
            case 8: 
        }
        return 3;
    }

    public static int zzo(int n, int n2) {
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                throw illegalArgumentException;
            }
            case 0x20000000: {
                return n2 * 3;
            }
            case 4: 
            case 0x30000000: {
                return n2 * 4;
            }
            case 3: {
                return n2;
            }
            case 2: 
            case 0x10000000: 
        }
        return n2 + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzp(Uri object) {
        block16: {
            int n;
            block17: {
                String string2 = object.getScheme();
                if (string2 != null && zzfse.zzc((CharSequence)"rtsp", (CharSequence)string2)) {
                    return 3;
                }
                string2 = object.getLastPathSegment();
                if (string2 == null) {
                    return 4;
                }
                int n2 = string2.lastIndexOf(46);
                if (n2 < 0) break block16;
                string2 = zzfse.zza((String)string2.substring(n2 + 1));
                switch (string2.hashCode()) {
                    case 3299913: {
                        if (!string2.equals("m3u8")) break;
                        n = 1;
                        break block17;
                    }
                    case 3242057: {
                        if (!string2.equals("isml")) break;
                        n = 3;
                        break block17;
                    }
                    case 108321: {
                        if (!string2.equals("mpd")) break;
                        n = 0;
                        break block17;
                    }
                    case 104579: {
                        if (!string2.equals("ism")) break;
                        n = 2;
                        break block17;
                    }
                }
                n = -1;
            }
            switch (n) {
                default: {
                    n = 4;
                    break;
                }
                case 2: 
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            if (n != 4) {
                return n;
            }
        }
        Pattern pattern = zzj;
        if ((object = object.getPath()) == null) throw null;
        if (!((Matcher)(object = pattern.matcher((CharSequence)object))).matches()) {
            return 4;
        }
        if ((object = ((Matcher)object).group(2)) == null) return 1;
        if (((String)object).contains("format=mpd-time-csf")) {
            return 0;
        }
        if (!((String)object).contains("format=m3u8-aapl")) return 1;
        return 2;
    }

    public static long zzq(long l, long l2, long l3) {
        long l4 = l + l2;
        if (((l ^ l4) & (l2 ^ l4)) < 0L) {
            return Long.MAX_VALUE;
        }
        return l4;
    }

    public static long zzr(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l, l3));
    }

    public static long zzs(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l * (double)f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long zzt(long l) {
        if (l != -9223372036854775807L) return SystemClock.elapsedRealtime() + l;
        return System.currentTimeMillis();
    }

    public static long zzu(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l / (double)f);
    }

    public static long zzv(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l * 1000L;
    }

    public static long zzw(long l, long l2, long l3) {
        if (l3 < l2 || l3 % l2 != 0L) {
            if (l3 < l2 && l2 % l3 == 0L) {
                return l * (l2 / l3);
            }
            return (long)((double)l * ((double)l2 / (double)l3));
        }
        return l / (l3 / l2);
    }

    public static long zzx(long l, long l2, long l3) {
        long l4 = l - l2;
        if (((l ^ l2) & (l ^ l4)) < 0L) {
            return Long.MIN_VALUE;
        }
        return l4;
    }

    public static long zzy(int n, int n2) {
        return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static long zzz(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l / 1000L;
    }

    @Nullable
    public static Intent zzA(Context context, @Nullable BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        if (zza < 33) {
            return context.registerReceiver(broadcastReceiver, intentFilter);
        }
        return context.registerReceiver(broadcastReceiver, intentFilter, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point zzB(Context context) {
        Object object = (DisplayManager)context.getSystemService("display");
        object = object != null ? object.getDisplay(0) : null;
        if (object == null) {
            object = (WindowManager)context.getSystemService("window");
            if (object == null) throw null;
            object = object.getDefaultDisplay();
        }
        if (object.getDisplayId() == 0 && zzen.zzX(context)) {
            String string2 = zza < 28 ? zzen.zzai("sys.display-size") : zzen.zzai("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    String[] stringArray = string2.trim();
                    String string3 = "x";
                    stringArray = stringArray.split(string3, -1);
                    int n = stringArray.length;
                    if (n == 2) {
                        n = Integer.parseInt(stringArray[0]);
                        int n2 = Integer.parseInt(stringArray[1]);
                        if (n > 0 && n2 > 0) {
                            Point point = new Point(n, n2);
                            return point;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                zzdw.zzb("Util", "Invalid display size: ".concat(String.valueOf(string2)));
            }
            if ("Sony".equals(zzc) && zzd.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
        }
        context = new Point();
        if (zza >= 23) {
            object = object.getMode();
            context.x = object.getPhysicalWidth();
            context.y = object.getPhysicalHeight();
            return context;
        }
        object.getRealSize((Point)context);
        return context;
    }

    public static Handler zzC(Looper looper, @Nullable Handler.Callback callback) {
        Handler handler = new Handler(looper, callback);
        return handler;
    }

    public static Handler zzD(@Nullable Handler.Callback callback) {
        callback = Looper.myLooper();
        zzdd.zzb(callback);
        Handler handler = new Handler((Looper)callback, null);
        return handler;
    }

    public static Looper zzE() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    public static zzaf zzF(int n, int n2, int n3) {
        zzad zzad2 = new zzad();
        zzad2.zzS("audio/raw");
        zzad2.zzw(n2);
        zzad2.zzT(n3);
        zzad2.zzN(n);
        return zzad2.zzY();
    }

    /*
     * Unable to fully structure code
     */
    public static zzcc zzG(zzcg var0, zzcc var1_2) {
        block30: {
            block10: {
                var4_3 = var0.zzs();
                var5_4 = var0.zzc();
                var2_5 = ((zzm)var0).zzn();
                if (!var2_5.zzo()) break block10;
                var2_6 = false;
lbl6:
                // 3 sources

                while (true) {
                    block29: {
                        block11: {
                            var3_8 = ((zzm)var0).zzn();
                            if (!var3_8.zzo()) break block11;
                            var3_9 = false;
lbl10:
                            // 3 sources

                            while (true) {
                                block12: {
                                    block13: {
                                        var6_11 = var0.zzb();
                                        var7_13 = var0.zza();
                                        var8_14 = var0.zzn().zzo();
                                        var9_15 = new zzca();
                                        var9_15.zzb(var1_2);
                                        var9_15.zzd(4, var4_3 ^ true);
                                        if (!var5_4) break block12;
                                        if (var4_3) break block13;
                                        var0_1 = true;
lbl22:
                                        // 3 sources

                                        while (true) {
                                            block14: {
                                                block15: {
                                                    var9_15.zzd(5, var0_1);
                                                    if (!var2_6) break block14;
                                                    if (var4_3) break block15;
                                                    var0_1 = true;
lbl28:
                                                    // 3 sources

                                                    while (true) {
                                                        block16: {
                                                            block17: {
                                                                block18: {
                                                                    var9_15.zzd(6, var0_1);
                                                                    if (var8_14) break block16;
                                                                    if (!var2_6 && var6_11 != 0 && !var5_4) break block17;
                                                                    if (var4_3) break block18;
                                                                    var0_1 = true;
lbl35:
                                                                    // 4 sources

                                                                    while (true) {
                                                                        block19: {
                                                                            block20: {
                                                                                var9_15.zzd(7, var0_1);
                                                                                if (!var3_9) break block19;
                                                                                if (var4_3) break block20;
                                                                                var0_1 = true;
lbl41:
                                                                                // 3 sources

                                                                                while (true) {
                                                                                    block21: {
                                                                                        block23: {
                                                                                            block24: {
                                                                                                block25: {
                                                                                                    block22: {
                                                                                                        var9_15.zzd(8, var0_1);
                                                                                                        if (var8_14) break block21;
                                                                                                        if (var3_9) break block22;
                                                                                                        if (var6_11 == 0) break block23;
                                                                                                        if (!var7_13) break block24;
                                                                                                    }
                                                                                                    if (var4_3) break block25;
                                                                                                    var0_1 = true;
lbl51:
                                                                                                    // 5 sources

                                                                                                    while (true) {
                                                                                                        block26: {
                                                                                                            block27: {
                                                                                                                var9_15.zzd(9, var0_1);
                                                                                                                var9_15.zzd(10, var4_3 ^ true);
                                                                                                                if (!var5_4) break block26;
                                                                                                                if (var4_3) break block27;
                                                                                                                var0_1 = true;
lbl59:
                                                                                                                // 3 sources

                                                                                                                while (true) {
                                                                                                                    block28: {
                                                                                                                        var9_15.zzd(11, var0_1);
                                                                                                                        if (!var5_4) break block28;
                                                                                                                        if (!var4_3) {
                                                                                                                            var0_1 = true;
lbl65:
                                                                                                                            // 3 sources

                                                                                                                            while (true) {
                                                                                                                                var9_15.zzd(12, var0_1);
                                                                                                                                return var9_15.zze();
                                                                                                                            }
                                                                                                                        }
                                                                                                                        var0_1 = false;
                                                                                                                        ** GOTO lbl65
                                                                                                                    }
                                                                                                                    var0_1 = false;
                                                                                                                    ** continue;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var0_1 = false;
                                                                                                            ** GOTO lbl59
                                                                                                        }
                                                                                                        var0_1 = false;
                                                                                                        ** continue;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var0_1 = false;
                                                                                                ** GOTO lbl51
                                                                                            }
                                                                                            var0_1 = false;
                                                                                            ** GOTO lbl51
                                                                                        }
                                                                                        var0_1 = false;
                                                                                        ** GOTO lbl51
                                                                                    }
                                                                                    var0_1 = false;
                                                                                    ** continue;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var0_1 = false;
                                                                            ** GOTO lbl41
                                                                        }
                                                                        var0_1 = false;
                                                                        ** continue;
                                                                        break;
                                                                    }
                                                                }
                                                                var0_1 = false;
                                                                ** GOTO lbl35
                                                            }
                                                            var0_1 = false;
                                                            ** GOTO lbl35
                                                        }
                                                        var0_1 = false;
                                                        ** continue;
                                                        break;
                                                    }
                                                }
                                                var0_1 = false;
                                                ** GOTO lbl28
                                            }
                                            var0_1 = false;
                                            ** continue;
                                            break;
                                        }
                                    }
                                    var0_1 = false;
                                    ** GOTO lbl22
                                }
                                var0_1 = false;
                                ** continue;
                                break;
                            }
                        }
                        var6_12 = (zzm)var0;
                        var6_11 = var6_12.zzf();
                        ((zzm)var0).zzj();
                        ((zzm)var0).zzr();
                        if (var3_8.zzj(var6_11, 0, false) == -1) break block29;
                        var3_9 = true;
                        ** GOTO lbl10
                    }
                    var3_9 = false;
                    ** continue;
                    break;
                }
            }
            var3_10 = (zzm)var0;
            var3_7 = var3_10.zzf();
            ((zzm)var0).zzj();
            ((zzm)var0).zzr();
            if (var2_5.zzk(var3_7, 0, false) == -1) break block30;
            var2_6 = true;
            ** GOTO lbl6
        }
        var2_6 = false;
        ** while (true)
    }

    @EnsuresNonNull(value={"#1"})
    public static Object zzH(@Nullable Object object) {
        return object;
    }

    public static String zzI(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static String zzJ(byte[] byArray, int n, int n2) {
        String string2 = new String(byArray, n, n2, zzfsk.zzc);
        return string2;
    }

    public static String zzK(Object[] objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < (n = objectArray.length); ++i) {
            stringBuilder.append(objectArray[i].getClass().getSimpleName());
            if (i >= n + -1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String zzL(@Nullable Context object) {
        if (object != null && (object = (TelephonyManager)object.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(object = object.getNetworkCountryIso()))) {
            return zzfse.zzb((String)object);
        }
        return zzfse.zzb((String)Locale.getDefault().getCountry());
    }

    public static String zzM(int n) {
        switch (n) {
            default: {
                IllegalStateException illegalStateException = new IllegalStateException();
                throw illegalStateException;
            }
            case 4: {
                return "YES";
            }
            case 3: {
                return "NO_EXCEEDS_CAPABILITIES";
            }
            case 2: {
                return "NO_UNSUPPORTED_DRM";
            }
            case 1: {
                return "NO_UNSUPPORTED_TYPE";
            }
            case 0: 
        }
        return "NO";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String zzN(Locale object) {
        if (zza < 21) return ((Locale)object).toString();
        return ((Locale)object).toLanguageTag();
    }

    @Nullable
    private static String zzai(String string2) {
        try {
            Object object = Class.forName("android.os.SystemProperties");
            Object object2 = new Class[]{String.class};
            object2 = ((Class)object).getMethod("get", (Class<?>)object2);
            Object[] objectArray = new Object[]{string2};
            object = (String)((Method)object2).invoke(object, objectArray);
            return object;
        }
        catch (Exception exception) {
            zzdw.zzc("Util", "Failed to read system property ".concat(string2), exception);
            return null;
        }
    }

    public static String zzO(int n) {
        switch (n) {
            default: {
                return "camera motion";
            }
            case -2: {
                return "none";
            }
            case 5: {
                return "metadata";
            }
            case 4: {
                return "image";
            }
            case 3: {
                return "text";
            }
            case 2: {
                return "video";
            }
            case 1: {
                return "audio";
            }
            case 0: {
                return "default";
            }
            case -1: 
        }
        return "unknown";
    }

    public static String zzP(String string2) {
        block8: {
            String[] stringArray;
            if (string2 == null) {
                return null;
            }
            String[] stringArray2 = string2.replace('_', '-');
            if (!stringArray2.isEmpty() && !stringArray2.equals("und")) {
                string2 = stringArray2;
            }
            string2 = zzfse.zza((String)string2);
            stringArray2 = string2.split("-", 2)[0];
            if (zzk == null) {
                zzk = zzen.zzaj();
            }
            if ((stringArray = (String[])zzk.get(stringArray2)) != null) {
                string2 = stringArray.concat(String.valueOf(string2.substring(stringArray2.length())));
                stringArray2 = stringArray;
            }
            if (!"no".equals(stringArray2) && !"i".equals(stringArray2) && !"zh".equals(stringArray2)) break block8;
            int n = 0;
            while (true) {
                block10: {
                    block9: {
                        stringArray = zzm;
                        int cfr_ignored_0 = stringArray.length;
                        if (n >= 18) break block9;
                        if (!string2.startsWith(stringArray[n])) break block10;
                        stringArray = zzm;
                        string2 = String.valueOf(stringArray[n + 1]).concat(String.valueOf(string2.substring(stringArray[n].length())));
                    }
                    return string2;
                }
                n += 2;
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap zzaj() {
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int cfr_ignored_0 = zzl.length;
        HashMap<Object, String> hashMap = new HashMap<Object, String>(n + 88);
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 < n) {
                    String string2 = stringArray[n2];
                    Object object = new Locale(string2);
                    object = ((Locale)object).getISO3Language();
                    boolean bl = TextUtils.isEmpty((CharSequence)object);
                    if (!bl) {
                        hashMap.put(object, string2);
                    }
                    break block7;
                }
                n2 = 0;
                while (true) {
                    stringArray = zzl;
                    int cfr_ignored_1 = stringArray.length;
                    if (n2 >= 88) {
                        return hashMap;
                    }
                    hashMap.put(stringArray[n2], stringArray[n2 + 1]);
                    n2 += 2;
                }
                catch (MissingResourceException missingResourceException) {}
            }
            ++n2;
        }
    }

    public static ExecutorService zzQ(String string2) {
        zzem zzem2 = new zzem(string2);
        return Executors.newSingleThreadExecutor(zzem2);
    }

    static {
        int n;
        zza = n = Build.VERSION.SDK_INT;
        zzb = Build.DEVICE;
        zzc = Build.MANUFACTURER;
        zzd = Build.MODEL;
        Object[] objectArray = zzb;
        String string2 = zzd;
        String string3 = zzc;
        int n2 = zza;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)objectArray);
        stringBuilder.append(", ");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(n2);
        zze = stringBuilder.toString();
        zzf = new byte[0];
        zzg = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
        zzh = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
        zzi = Pattern.compile("%([A-Fa-f0-9]{2})");
        zzj = Pattern.compile("(?:.*\\.)?isml?(?:/(manifest(.*))?)?", 2);
        objectArray = new String[]{"alb", "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "arb", "ar-arb", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        zzl = objectArray;
        objectArray = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        zzm = objectArray;
        objectArray = new int[256];
        objectArray[0] = (String)false;
        objectArray[1] = (String)79764919;
        objectArray[2] = (String)159529838;
        objectArray[3] = (String)222504665;
        objectArray[4] = (String)319059676;
        objectArray[5] = (String)398814059;
        objectArray[6] = (String)445009330;
        objectArray[7] = (String)507990021;
        objectArray[8] = (String)638119352;
        objectArray[9] = (String)583659535;
        objectArray[10] = (String)797628118;
        objectArray[11] = (String)726387553;
        objectArray[12] = (String)890018660;
        objectArray[13] = (String)835552979;
        objectArray[14] = (String)1015980042;
        objectArray[15] = (String)944750013;
        objectArray[16] = (String)1276238704;
        objectArray[17] = (String)1221641927;
        objectArray[18] = (String)1167319070;
        objectArray[19] = (String)1095957929;
        objectArray[20] = (String)1595256236;
        objectArray[21] = (String)1540665371;
        objectArray[22] = (String)1452775106;
        objectArray[23] = (String)1381403509;
        objectArray[24] = (String)1780037320;
        objectArray[25] = (String)1859660671;
        objectArray[26] = (String)1671105958;
        objectArray[27] = (String)1733955601;
        objectArray[28] = (String)2031960084;
        objectArray[29] = (String)2111593891;
        objectArray[30] = (String)1889500026;
        objectArray[31] = (String)1952343757;
        objectArray[32] = (String)-1742489888;
        objectArray[33] = (String)-1662866601;
        objectArray[34] = (String)-1851683442;
        objectArray[35] = (String)-1788833735;
        objectArray[36] = (String)-1960329156;
        objectArray[37] = (String)-1880695413;
        objectArray[38] = (String)-2103051438;
        objectArray[39] = (String)-2040207643;
        objectArray[40] = (String)-1104454824;
        objectArray[41] = (String)-1159051537;
        objectArray[42] = (String)-1213636554;
        objectArray[43] = (String)-1284997759;
        objectArray[44] = (String)-1389417084;
        objectArray[45] = (String)-1444007885;
        objectArray[46] = (String)-1532160278;
        objectArray[47] = (String)-1603531939;
        objectArray[48] = (String)-734892656;
        objectArray[49] = (String)-789352409;
        objectArray[50] = (String)-575645954;
        objectArray[51] = (String)-646886583;
        objectArray[52] = (String)-952755380;
        objectArray[53] = (String)-1007220997;
        objectArray[54] = (String)-827056094;
        objectArray[55] = (String)-898286187;
        objectArray[56] = (String)-231047128;
        objectArray[57] = (String)-151282273;
        objectArray[58] = (String)-71779514;
        objectArray[59] = (String)-8804623;
        objectArray[60] = (String)-515967244;
        objectArray[61] = (String)-436212925;
        objectArray[62] = (String)-390279782;
        objectArray[63] = (String)-327299027;
        objectArray[64] = (String)881225847;
        objectArray[65] = (String)809987520;
        objectArray[66] = (String)1023691545;
        objectArray[67] = (String)969234094;
        objectArray[68] = (String)662832811;
        objectArray[69] = (String)591600412;
        objectArray[70] = (String)771767749;
        objectArray[71] = (String)717299826;
        objectArray[72] = (String)311336399;
        objectArray[73] = (String)374308984;
        objectArray[74] = (String)453813921;
        objectArray[75] = (String)533576470;
        objectArray[76] = (String)25881363;
        objectArray[77] = (String)88864420;
        objectArray[78] = (String)134795389;
        objectArray[79] = (String)214552010;
        objectArray[80] = (String)2023205639;
        objectArray[81] = (String)2086057648;
        objectArray[82] = (String)1897238633;
        objectArray[83] = (String)1976864222;
        objectArray[84] = (String)1804852699;
        objectArray[85] = (String)1867694188;
        objectArray[86] = (String)1645340341;
        objectArray[87] = (String)1724971778;
        objectArray[88] = (String)1587496639;
        objectArray[89] = (String)1516133128;
        objectArray[90] = (String)1461550545;
        objectArray[91] = (String)1406951526;
        objectArray[92] = (String)1302016099;
        objectArray[93] = (String)1230646740;
        objectArray[94] = (String)1142491917;
        objectArray[95] = (String)1087903418;
        objectArray[96] = (String)-1398421865;
        objectArray[97] = (String)-1469785312;
        objectArray[98] = (String)-1524105735;
        objectArray[99] = (String)-1578704818;
        objectArray[100] = (String)-1079922613;
        objectArray[101] = (String)-1151291908;
        objectArray[102] = (String)-1239184603;
        objectArray[103] = (String)-1293773166;
        objectArray[104] = (String)-1968362705;
        objectArray[105] = (String)-1905510760;
        objectArray[106] = (String)-2094067647;
        objectArray[107] = (String)-2014441994;
        objectArray[108] = (String)-1716953613;
        objectArray[109] = (String)-1654112188;
        objectArray[110] = (String)-1876203875;
        objectArray[111] = (String)-1796572374;
        objectArray[112] = (String)-525066777;
        objectArray[113] = (String)-462094256;
        objectArray[114] = (String)-382327159;
        objectArray[115] = (String)-302564546;
        objectArray[116] = (String)-206542021;
        objectArray[117] = (String)-143559028;
        objectArray[118] = (String)-97365931;
        objectArray[119] = (String)-17609246;
        objectArray[120] = (String)-960696225;
        objectArray[121] = (String)-1031934488;
        objectArray[122] = (String)-817968335;
        objectArray[123] = (String)-872425850;
        objectArray[124] = (String)-709327229;
        objectArray[125] = (String)-780559564;
        objectArray[126] = (String)-600130067;
        objectArray[127] = (String)-654598054;
        objectArray[128] = (String)1762451694;
        objectArray[129] = (String)1842216281;
        objectArray[130] = (String)1619975040;
        objectArray[131] = (String)1682949687;
        objectArray[132] = (String)2047383090;
        objectArray[133] = (String)2127137669;
        objectArray[134] = (String)1938468188;
        objectArray[135] = (String)2001449195;
        objectArray[136] = (String)1325665622;
        objectArray[137] = (String)1271206113;
        objectArray[138] = (String)1183200824;
        objectArray[139] = (String)1111960463;
        objectArray[140] = (String)1543535498;
        objectArray[141] = (String)1489069629;
        objectArray[142] = (String)1434599652;
        objectArray[143] = (String)1363369299;
        objectArray[144] = (String)622672798;
        objectArray[145] = (String)568075817;
        objectArray[146] = (String)748617968;
        objectArray[147] = (String)677256519;
        objectArray[148] = (String)907627842;
        objectArray[149] = (String)853037301;
        objectArray[150] = (String)1067152940;
        objectArray[151] = (String)995781531;
        objectArray[152] = (String)51762726;
        objectArray[153] = (String)131386257;
        objectArray[154] = (String)177728840;
        objectArray[155] = (String)240578815;
        objectArray[156] = (String)269590778;
        objectArray[157] = (String)349224269;
        objectArray[158] = (String)429104020;
        objectArray[159] = (String)491947555;
        objectArray[160] = (String)-248556018;
        objectArray[161] = (String)-168932423;
        objectArray[162] = (String)-122852000;
        objectArray[163] = (String)-60002089;
        objectArray[164] = (String)-500490030;
        objectArray[165] = (String)-420856475;
        objectArray[166] = (String)-341238852;
        objectArray[167] = (String)-278395381;
        objectArray[168] = (String)-685261898;
        objectArray[169] = (String)-739858943;
        objectArray[170] = (String)-559578920;
        objectArray[171] = (String)-630940305;
        objectArray[172] = (String)-1004286614;
        objectArray[173] = (String)-1058877219;
        objectArray[174] = (String)-845023740;
        objectArray[175] = (String)-916395085;
        objectArray[176] = (String)-1119974018;
        objectArray[177] = (String)-1174433591;
        objectArray[178] = (String)-1262701040;
        objectArray[179] = (String)-1333941337;
        objectArray[180] = (String)-1371866206;
        objectArray[181] = (String)-1426332139;
        objectArray[182] = (String)-1481064244;
        objectArray[183] = (String)-1552294533;
        objectArray[184] = (String)-1690935098;
        objectArray[185] = (String)-1611170447;
        objectArray[186] = (String)-1833673816;
        objectArray[187] = (String)-1770699233;
        objectArray[188] = (String)-2009983462;
        objectArray[189] = (String)-1930228819;
        objectArray[190] = (String)-2119160460;
        objectArray[191] = (String)-2056179517;
        objectArray[192] = (String)1569362073;
        objectArray[193] = (String)1498123566;
        objectArray[194] = (String)1409854455;
        objectArray[195] = (String)1355396672;
        objectArray[196] = (String)1317987909;
        objectArray[197] = (String)1246755826;
        objectArray[198] = (String)1192025387;
        objectArray[199] = (String)1137557660;
        objectArray[200] = (String)2072149281;
        objectArray[201] = (String)2135122070;
        objectArray[202] = (String)1912620623;
        objectArray[203] = (String)1992383480;
        objectArray[204] = (String)1753615357;
        objectArray[205] = (String)1816598090;
        objectArray[206] = (String)1627664531;
        objectArray[207] = (String)1707420964;
        objectArray[208] = (String)295390185;
        objectArray[209] = (String)358241886;
        objectArray[210] = (String)404320391;
        objectArray[211] = (String)483945776;
        objectArray[212] = (String)43990325;
        objectArray[213] = (String)106832002;
        objectArray[214] = (String)186451547;
        objectArray[215] = (String)266083308;
        objectArray[216] = (String)932423249;
        objectArray[217] = (String)861060070;
        objectArray[218] = (String)1041341759;
        objectArray[219] = (String)986742920;
        objectArray[220] = (String)613929101;
        objectArray[221] = (String)542559546;
        objectArray[222] = (String)756411363;
        objectArray[223] = (String)701822548;
        objectArray[224] = (String)-978770311;
        objectArray[225] = (String)-1050133554;
        objectArray[226] = (String)-869589737;
        objectArray[227] = (String)-924188512;
        objectArray[228] = (String)-693284699;
        objectArray[229] = (String)-764654318;
        objectArray[230] = (String)-550540341;
        objectArray[231] = (String)-605129092;
        objectArray[232] = (String)-475935807;
        objectArray[233] = (String)-413084042;
        objectArray[234] = (String)-366743377;
        objectArray[235] = (String)-287118056;
        objectArray[236] = (String)-257573603;
        objectArray[237] = (String)-194731862;
        objectArray[238] = (String)-114850189;
        objectArray[239] = (String)-35218492;
        objectArray[240] = (String)-1984365303;
        objectArray[241] = (String)-1921392450;
        objectArray[242] = (String)-2143631769;
        objectArray[243] = (String)-2063868976;
        objectArray[244] = (String)-1698919467;
        objectArray[245] = (String)-1635936670;
        objectArray[246] = (String)-1824608069;
        objectArray[247] = (String)-1744851700;
        objectArray[248] = (String)-1347415887;
        objectArray[249] = (String)-1418654458;
        objectArray[250] = (String)-1506661409;
        objectArray[251] = (String)-1561119128;
        objectArray[252] = (String)-1129027987;
        objectArray[253] = (String)-1200260134;
        objectArray[254] = (String)-1254728445;
        objectArray[255] = (String)-1309196108;
        zzn = (int[])objectArray;
        objectArray = new int[256];
        objectArray[0] = (String)false;
        objectArray[1] = (String)7;
        objectArray[2] = (String)14;
        objectArray[3] = (String)9;
        objectArray[4] = (String)28;
        objectArray[5] = (String)27;
        objectArray[6] = (String)18;
        objectArray[7] = (String)21;
        objectArray[8] = (String)56;
        objectArray[9] = (String)63;
        objectArray[10] = (String)54;
        objectArray[11] = (String)49;
        objectArray[12] = (String)36;
        objectArray[13] = (String)35;
        objectArray[14] = (String)42;
        objectArray[15] = (String)45;
        objectArray[16] = (String)112;
        objectArray[17] = (String)119;
        objectArray[18] = (String)126;
        objectArray[19] = (String)121;
        objectArray[20] = (String)108;
        objectArray[21] = (String)107;
        objectArray[22] = (String)98;
        objectArray[23] = (String)101;
        objectArray[24] = (String)72;
        objectArray[25] = (String)79;
        objectArray[26] = (String)70;
        objectArray[27] = (String)65;
        objectArray[28] = (String)84;
        objectArray[29] = (String)83;
        objectArray[30] = (String)90;
        objectArray[31] = (String)93;
        objectArray[32] = (String)224;
        objectArray[33] = (String)231;
        objectArray[34] = (String)238;
        objectArray[35] = (String)233;
        objectArray[36] = (String)252;
        objectArray[37] = (String)251;
        objectArray[38] = (String)242;
        objectArray[39] = (String)245;
        objectArray[40] = (String)216;
        objectArray[41] = (String)223;
        objectArray[42] = (String)214;
        objectArray[43] = (String)209;
        objectArray[44] = (String)196;
        objectArray[45] = (String)195;
        objectArray[46] = (String)202;
        objectArray[47] = (String)205;
        objectArray[48] = (String)144;
        objectArray[49] = (String)151;
        objectArray[50] = (String)158;
        objectArray[51] = (String)153;
        objectArray[52] = (String)140;
        objectArray[53] = (String)139;
        objectArray[54] = (String)130;
        objectArray[55] = (String)133;
        objectArray[56] = (String)168;
        objectArray[57] = (String)175;
        objectArray[58] = (String)166;
        objectArray[59] = (String)161;
        objectArray[60] = (String)180;
        objectArray[61] = (String)179;
        objectArray[62] = (String)186;
        objectArray[63] = (String)189;
        objectArray[64] = (String)199;
        objectArray[65] = (String)192;
        objectArray[66] = (String)201;
        objectArray[67] = (String)206;
        objectArray[68] = (String)219;
        objectArray[69] = (String)220;
        objectArray[70] = (String)213;
        objectArray[71] = (String)210;
        objectArray[72] = (String)255;
        objectArray[73] = (String)248;
        objectArray[74] = (String)241;
        objectArray[75] = (String)246;
        objectArray[76] = (String)227;
        objectArray[77] = (String)228;
        objectArray[78] = (String)237;
        objectArray[79] = (String)234;
        objectArray[80] = (String)183;
        objectArray[81] = (String)176;
        objectArray[82] = (String)185;
        objectArray[83] = (String)190;
        objectArray[84] = (String)171;
        objectArray[85] = (String)172;
        objectArray[86] = (String)165;
        objectArray[87] = (String)162;
        objectArray[88] = (String)143;
        objectArray[89] = (String)136;
        objectArray[90] = (String)129;
        objectArray[91] = (String)134;
        objectArray[92] = (String)147;
        objectArray[93] = (String)148;
        objectArray[94] = (String)157;
        objectArray[95] = (String)154;
        objectArray[96] = (String)39;
        objectArray[97] = (String)32;
        objectArray[98] = (String)41;
        objectArray[99] = (String)46;
        objectArray[100] = (String)59;
        objectArray[101] = (String)60;
        objectArray[102] = (String)53;
        objectArray[103] = (String)50;
        objectArray[104] = (String)31;
        objectArray[105] = (String)24;
        objectArray[106] = (String)17;
        objectArray[107] = (String)22;
        objectArray[108] = (String)3;
        objectArray[109] = (String)4;
        objectArray[110] = (String)13;
        objectArray[111] = (String)10;
        objectArray[112] = (String)87;
        objectArray[113] = (String)80;
        objectArray[114] = (String)89;
        objectArray[115] = (String)94;
        objectArray[116] = (String)75;
        objectArray[117] = (String)76;
        objectArray[118] = (String)69;
        objectArray[119] = (String)66;
        objectArray[120] = (String)111;
        objectArray[121] = (String)104;
        objectArray[122] = (String)97;
        objectArray[123] = (String)102;
        objectArray[124] = (String)115;
        objectArray[125] = (String)116;
        objectArray[126] = (String)125;
        objectArray[127] = (String)122;
        objectArray[128] = (String)137;
        objectArray[129] = (String)142;
        objectArray[130] = (String)135;
        objectArray[131] = (String)128;
        objectArray[132] = (String)149;
        objectArray[133] = (String)146;
        objectArray[134] = (String)155;
        objectArray[135] = (String)156;
        objectArray[136] = (String)177;
        objectArray[137] = (String)182;
        objectArray[138] = (String)191;
        objectArray[139] = (String)184;
        objectArray[140] = (String)173;
        objectArray[141] = (String)170;
        objectArray[142] = (String)163;
        objectArray[143] = (String)164;
        objectArray[144] = (String)249;
        objectArray[145] = (String)254;
        objectArray[146] = (String)247;
        objectArray[147] = (String)240;
        objectArray[148] = (String)229;
        objectArray[149] = (String)226;
        objectArray[150] = (String)235;
        objectArray[151] = (String)236;
        objectArray[152] = (String)193;
        objectArray[153] = (String)198;
        objectArray[154] = (String)207;
        objectArray[155] = (String)200;
        objectArray[156] = (String)221;
        objectArray[157] = (String)218;
        objectArray[158] = (String)211;
        objectArray[159] = (String)212;
        objectArray[160] = (String)105;
        objectArray[161] = (String)110;
        objectArray[162] = (String)103;
        objectArray[163] = (String)96;
        objectArray[164] = (String)117;
        objectArray[165] = (String)114;
        objectArray[166] = (String)123;
        objectArray[167] = (String)124;
        objectArray[168] = (String)81;
        objectArray[169] = (String)86;
        objectArray[170] = (String)95;
        objectArray[171] = (String)88;
        objectArray[172] = (String)77;
        objectArray[173] = (String)74;
        objectArray[174] = (String)67;
        objectArray[175] = (String)68;
        objectArray[176] = (String)25;
        objectArray[177] = (String)30;
        objectArray[178] = (String)23;
        objectArray[179] = (String)16;
        objectArray[180] = (String)5;
        objectArray[181] = (String)2;
        objectArray[182] = (String)11;
        objectArray[183] = (String)12;
        objectArray[184] = (String)33;
        objectArray[185] = (String)38;
        objectArray[186] = (String)47;
        objectArray[187] = (String)40;
        objectArray[188] = (String)61;
        objectArray[189] = (String)58;
        objectArray[190] = (String)51;
        objectArray[191] = (String)52;
        objectArray[192] = (String)78;
        objectArray[193] = (String)73;
        objectArray[194] = (String)64;
        objectArray[195] = (String)71;
        objectArray[196] = (String)82;
        objectArray[197] = (String)85;
        objectArray[198] = (String)92;
        objectArray[199] = (String)91;
        objectArray[200] = (String)118;
        objectArray[201] = (String)113;
        objectArray[202] = (String)120;
        objectArray[203] = (String)127;
        objectArray[204] = (String)106;
        objectArray[205] = (String)109;
        objectArray[206] = (String)100;
        objectArray[207] = (String)99;
        objectArray[208] = (String)62;
        objectArray[209] = (String)57;
        objectArray[210] = (String)48;
        objectArray[211] = (String)55;
        objectArray[212] = (String)34;
        objectArray[213] = (String)37;
        objectArray[214] = (String)44;
        objectArray[215] = (String)43;
        objectArray[216] = (String)6;
        objectArray[217] = (String)true;
        objectArray[218] = (String)8;
        objectArray[219] = (String)15;
        objectArray[220] = (String)26;
        objectArray[221] = (String)29;
        objectArray[222] = (String)20;
        objectArray[223] = (String)19;
        objectArray[224] = (String)174;
        objectArray[225] = (String)169;
        objectArray[226] = (String)160;
        objectArray[227] = (String)167;
        objectArray[228] = (String)178;
        objectArray[229] = (String)181;
        objectArray[230] = (String)188;
        objectArray[231] = (String)187;
        objectArray[232] = (String)150;
        objectArray[233] = (String)145;
        objectArray[234] = (String)152;
        objectArray[235] = (String)159;
        objectArray[236] = (String)138;
        objectArray[237] = (String)141;
        objectArray[238] = (String)132;
        objectArray[239] = (String)131;
        objectArray[240] = (String)222;
        objectArray[241] = (String)217;
        objectArray[242] = (String)208;
        objectArray[243] = (String)215;
        objectArray[244] = (String)194;
        objectArray[245] = (String)197;
        objectArray[246] = (String)204;
        objectArray[247] = (String)203;
        objectArray[248] = (String)230;
        objectArray[249] = (String)225;
        objectArray[250] = (String)232;
        objectArray[251] = (String)239;
        objectArray[252] = (String)250;
        objectArray[253] = (String)253;
        objectArray[254] = (String)244;
        objectArray[255] = (String)243;
        zzo = (int[])objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzR(long[] lArray, long l, long l2) {
        if (l2 >= 1000000L && l2 % 1000000L == 0L) {
            long l3 = l2 / 1000000L;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = lArray[i] / l3;
            }
            return;
        } else if (l2 < 1000000L && 1000000L % l2 == 0L) {
            long l4 = 1000000L / l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = lArray[i] * l4;
            }
            return;
        } else {
            double d = 1000000.0 / (double)l2;
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = (long)((double)lArray[i] * d);
            }
        }
    }

    public static void zzS(Parcel parcel, boolean bl) {
        parcel.writeInt(bl ? 1 : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzT(@Nullable Object object, @Nullable Object object2) {
        if (object != null) return object.equals(object2);
        if (object2 == null) return true;
        return false;
    }

    public static boolean zzU(int n) {
        return n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static boolean zzV(int n) {
        return n == 3 || n == 2 || n == 0x10000000 || n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static boolean zzW(Uri object) {
        return TextUtils.isEmpty((CharSequence)(object = object.getScheme())) || "file".equals(object);
    }

    public static boolean zzX(Context context) {
        return (context = (UiModeManager)context.getApplicationContext().getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
    }

    public static boolean zzY(Handler handler, Runnable runnable) {
        if (!handler.getLooper().getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    public static boolean zzZ(Parcel parcel) {
        return parcel.readInt() != 0;
    }

    public static byte[] zzaa(String string2) {
        return string2.getBytes(zzfsk.zzc);
    }

    public static byte[] zzab(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @EnsuresNonNull(value={"#1"})
    public static Object[] zzac(Object[] objectArray) {
        return objectArray;
    }

    public static Object[] zzad(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        objectArray = Arrays.copyOf(objectArray, n + n2);
        System.arraycopy(objectArray2, 0, objectArray, n, n2);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object[] zzae(Object[] objectArray, int n) {
        boolean bl = n <= objectArray.length;
        zzdd.zzd(bl);
        return Arrays.copyOf(objectArray, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] zzaf() {
        String[] stringArray = Resources.getSystem().getConfiguration();
        if (zza >= 24) {
            stringArray = stringArray.getLocales().toLanguageTags().split(",", -1);
        } else {
            String[] stringArray2 = new String[]{zzen.zzN(stringArray.locale)};
            stringArray = stringArray2;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = zzen.zzP(stringArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static String[] zzag(String string2, String string3) {
        return string2.split(string3, -1);
    }

    public static String[] zzah(String string2, String string3) {
        return string2.split(string3, 2);
    }
}

