/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdk;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzblp;
import com.google.android.gms.internal.ads.zzbmb;
import com.google.android.gms.internal.ads.zzbse;
import com.google.android.gms.internal.ads.zzbsi;
import com.google.android.gms.internal.ads.zzchp;
import com.google.android.gms.internal.ads.zzcze;
import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdoq;
import com.google.android.gms.internal.ads.zzdsm;
import java.util.Collections;

public final class zzdsn
extends zzbse
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzblp {
    private View zza;
    private zzdk zzb;
    private zzdol zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdk zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbmb zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdsn)((Object)zzdol2)).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdol zzdol2 = ((zzdsn)((Object)zzdol2)).zzc;
        if (zzdol2 != null && zzdol2.zza() != null) {
            return zzdol2.zza().zza();
        }
        return null;
    }

    public zzdsn(zzdol zzdol2, zzdoq zzdoq2) {
        this.zza = zzdoq2.zzf();
        this.zzb = zzdoq2.zzj();
        this.zzc = zzdol2;
        this.zzd = false;
        this.zze = false;
        if (zzdoq2.zzr() != null) {
            zzdoq2.zzr().zzao(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdol zzdol2 = this.zzc;
        if (zzdol2 != null) {
            ((zzcze)zzdol2).zzV();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdol zzdol2 = this.zzc;
        if (zzdol2 != null && (view = this.zza) != null) {
            zzdol2.zzv(view, Collections.emptyMap(), Collections.emptyMap(), zzdol.zzP(this.zza));
            return;
        }
    }

    private final void zzh() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdsm zzdsm2 = new zzdsm(this);
        this.zzf(iObjectWrapper, (zzbsi)zzdsm2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper object, zzbsi zzbsi2) throws RemoteException {
        void var2_5;
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdsn)((Object)string2)).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad can not be shown after destroy().");
            zzdsn.zzi((zzbsi)var2_5, 2);
            return;
        }
        View view = ((zzdsn)((Object)string2)).zza;
        if (view == null || ((zzdsn)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream internal error: ".concat(string2));
            zzdsn.zzi((zzbsi)var2_5, 0);
            return;
        }
        if (((zzdsn)((Object)string2)).zze) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad should not be used again.");
            zzdsn.zzi((zzbsi)var2_5, 1);
            return;
        }
        ((zzdsn)((Object)string2)).zze = true;
        super.zzh();
        Object object2 = ObjectWrapper.unwrap((IObjectWrapper)object);
        ViewGroup viewGroup = (ViewGroup)object2;
        view = ((zzdsn)((Object)string2)).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        viewGroup.addView(view, layoutParams);
        zzt.zzx();
        zzchp.zza(((zzdsn)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzt.zzx();
        zzchp.zzb(((zzdsn)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            var2_5.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbsi zzbsi2, int n) {
        try {
            zzbsi2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

