/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbeb;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzcht;
import com.google.android.gms.internal.ads.zzchu;
import com.google.android.gms.internal.ads.zzchv;
import com.google.android.gms.internal.ads.zzchw;
import com.google.android.gms.internal.ads.zzchx;
import com.google.android.gms.internal.ads.zzchy;
import com.google.android.gms.internal.ads.zzchz;
import com.google.android.gms.internal.ads.zzcia;
import com.google.android.gms.internal.ads.zzcib;
import com.google.android.gms.internal.ads.zzcid;
import com.google.android.gms.internal.ads.zzcie;
import com.google.android.gms.internal.ads.zzciw;
import com.google.android.gms.internal.ads.zzcix;
import com.google.android.gms.internal.ads.zzciy;
import com.google.android.gms.internal.ads.zzciz;
import com.google.android.gms.internal.ads.zzfpz;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class zzcic
extends zzcie
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map zzd;
    private final zzciy zze;
    private final zzciz zzf;
    private final boolean zzg;
    private int zzh = 0;
    private int zzi = 0;
    private MediaPlayer zzj;
    private Uri zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private zzciw zzo;
    private final boolean zzp;
    private int zzq;
    private zzcid zzr;
    private boolean zzs = false;
    private Integer zzt = null;

    @Override
    public final int zza() {
        if (this.zzG()) {
            return this.zzj.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzG()) {
            return this.zzj.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzG()) {
            return this.zzj.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzcic zzcic2 = zzcic2.zzj;
        if (zzcic2 != null) {
            return zzcic2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzcic zzcic2 = zzcic2.zzj;
        if (zzcic2 != null) {
            return zzcic2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzt != null) {
            return this.zzh() * (long)this.zzn / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzt != null) {
            return (long)this.zzc() * (long)this.zzt.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzcid zzi(zzcic zzcic2) {
        return zzcic2.zzr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final String zzj() {
        Object object;
        if (!((zzcic)object).zzp) {
            object = "";
            return "MediaPlayer".concat((String)object);
        }
        object = " spherical";
        return "MediaPlayer".concat((String)object);
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        int n = this.hashCode();
        String string3 = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static /* bridge */ /* synthetic */ void zzk(zzcic zzcic2, boolean bl) {
        zzcic2.zzs = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzl(zzcic zzcic2, MediaPlayer mediaPlayer) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzbjc.zzbD;
        if ((Boolean)zzay.zzc().zzb((zzbiu)trackInfoArray) == false) return;
        if (zzcic2.zze == null) return;
        if (mediaPlayer == null) {
            return;
        }
        trackInfoArray = mediaPlayer.getTrackInfo();
        if (trackInfoArray == null) return;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = trackInfoArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (hashMap.isEmpty()) return;
                zzcic2.zze.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[n2];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("audioMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("audioCodec", trackInfo.getString("codecs-string"));
                        break;
                    }
                    case 1: {
                        if ((trackInfo = trackInfo.getFormat()) == null) break;
                        if (trackInfo.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                hashMap.put("frameRate", String.valueOf(trackInfo.getInteger("frame-rate")));
                            }
                        }
                        if (trackInfo.containsKey("bitrate")) {
                            zzcic2.zzt = trackInfo.getInteger("bitrate");
                            hashMap.put("bitRate", String.valueOf(zzcic2.zzt));
                        }
                        if (trackInfo.containsKey("width") && trackInfo.containsKey("height")) {
                            int n3 = trackInfo.getInteger("width");
                            int n4 = trackInfo.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n3);
                            stringBuilder.append("x");
                            stringBuilder.append(n4);
                            hashMap.put("resolution", stringBuilder.toString());
                        }
                        if (trackInfo.containsKey("mime")) {
                            hashMap.put("videoMime", trackInfo.getString("mime"));
                        }
                        if (Build.VERSION.SDK_INT < 30 || !trackInfo.containsKey("codecs-string")) break;
                        hashMap.put("videoCodec", trackInfo.getString("codecs-string"));
                    }
                }
            }
            ++n2;
        }
    }

    static {
        Map<Integer, String> map = new Map<Integer, String>();
        zzd = map;
        zzd.put(-1004, "MEDIA_ERROR_IO");
        zzd.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzd.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzd.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzd.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzd.put(100, "MEDIA_ERROR_SERVER_DIED");
        map = zzd;
        Integer n = 1;
        map.put(n, "MEDIA_ERROR_UNKNOWN");
        zzd.put(n, "MEDIA_INFO_UNKNOWN");
        zzd.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzd.put(701, "MEDIA_INFO_BUFFERING_START");
        zzd.put(702, "MEDIA_INFO_BUFFERING_END");
        zzd.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzd.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzd.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzd.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzd.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }

    public zzcic(Context context, zzciy zzciy2, boolean bl, boolean bl2, zzcix zzcix2, zzciz zzciz2, @Nullable Integer n) {
        super(context, n);
        this.setSurfaceTextureListener(this);
        this.zze = zzciy2;
        this.zzf = zzciz2;
        this.zzp = bl;
        this.zzg = bl2;
        this.zzf.zza(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzC() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzk == null || surfaceTexture == null) {
            return;
        }
        this.zzD(false);
        try {
            void var1_3;
            MediaPlayer mediaPlayer;
            com.google.android.gms.ads.internal.zzt.zzk();
            this.zzj = mediaPlayer = new MediaPlayer();
            this.zzj.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzj.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzj.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzj.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzj.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzj.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzn = 0;
            boolean bl = this.zzp;
            if (bl) {
                zzciw zzciw2;
                this.zzo = zzciw2 = new zzciw(this.getContext());
                this.zzo.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzo.start();
                zzciw2 = this.zzo.zzb();
                if (zzciw2 != null) {
                    zzciw zzciw3 = zzciw2;
                } else {
                    this.zzo.zze();
                    this.zzo = null;
                }
            }
            this.zzj.setDataSource(this.getContext(), this.zzk);
            com.google.android.gms.ads.internal.zzt.zzl();
            Surface surface = new Surface((SurfaceTexture)var1_3);
            this.zzj.setSurface(surface);
            this.zzj.setAudioStreamType(3);
            this.zzj.setScreenOnWhilePlaying(true);
            this.zzj.prepareAsync();
            this.zzE(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            com.google.android.gms.ads.internal.util.zze.zzk((String)"Failed to initialize MediaPlayer at ".concat(String.valueOf(String.valueOf(this.zzk))), (Throwable)exception);
            this.onError(this.zzj, 1, 0);
            return;
        }
    }

    final /* synthetic */ void zzm(int n) {
        zzcid zzcid2 = ((zzcic)((Object)zzcid2)).zzr;
        if (zzcid2 != null) {
            zzcid2.onWindowVisibilityChanged(n);
            return;
        }
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzn = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzE(5);
        this.zzi = 5;
        mediaPlayer = com.google.android.gms.ads.internal.util.zzs.zza;
        zzchv zzchv2 = new zzchv(this);
        mediaPlayer.post((Runnable)zzchv2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block21: {
            int n3;
            int n4;
            block23: {
                block24: {
                    block25: {
                        int n5;
                        int n6;
                        block30: {
                            block29: {
                                block28: {
                                    block26: {
                                        block27: {
                                            n4 = zzcic.getDefaultSize((int)((zzcic)((Object)zzciw2)).zzl, (int)n);
                                            n3 = zzcic.getDefaultSize((int)((zzcic)((Object)zzciw2)).zzm, (int)n2);
                                            if (((zzcic)((Object)zzciw2)).zzl <= 0) break block23;
                                            if (((zzcic)((Object)zzciw2)).zzm <= 0) break block24;
                                            if (((zzcic)((Object)zzciw2)).zzo != null) break block25;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n6 = View.MeasureSpec.getMode((int)n2);
                                            n5 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block26;
                                            if (n6 != 0x40000000) break block27;
                                            n = ((zzcic)((Object)zzciw2)).zzl;
                                            n2 = n * n5;
                                            n4 = ((zzcic)((Object)zzciw2)).zzm;
                                            n6 = n3 * n4;
                                            if (n2 < n6) {
                                                n = n2 / n4;
                                                n2 = n5;
                                                break block21;
                                            } else if (n2 > n6) {
                                                n2 = n6 / n;
                                                n = n3;
                                                break block21;
                                            } else {
                                                n = n3;
                                                n2 = n5;
                                            }
                                            break block21;
                                        }
                                        n = 0x40000000;
                                        break block28;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block29;
                                n2 = n3 * ((zzcic)((Object)zzciw2)).zzm / ((zzcic)((Object)zzciw2)).zzl;
                                if (n6 == Integer.MIN_VALUE) {
                                    if (n2 > n5) {
                                        n = n3;
                                        n2 = n5;
                                        break block21;
                                    } else {
                                        n = n3;
                                    }
                                    break block21;
                                } else {
                                    n = n3;
                                }
                                break block21;
                            }
                            if (n6 != 0x40000000) break block30;
                            n2 = n5 * ((zzcic)((Object)zzciw2)).zzl / ((zzcic)((Object)zzciw2)).zzm;
                            if (n == Integer.MIN_VALUE) {
                                if (n2 > n3) {
                                    n = n3;
                                    n2 = n5;
                                    break block21;
                                } else {
                                    n = n2;
                                    n2 = n5;
                                }
                                break block21;
                            } else {
                                n = n2;
                                n2 = n5;
                            }
                            break block21;
                        }
                        int n7 = ((zzcic)((Object)zzciw2)).zzl;
                        int n8 = ((zzcic)((Object)zzciw2)).zzm;
                        if (n6 == Integer.MIN_VALUE) {
                            if (n8 > n5) {
                                n2 = n5 * n7 / n8;
                                n4 = n5;
                            } else {
                                n2 = n7;
                                n4 = n8;
                            }
                        } else {
                            n2 = n7;
                            n4 = n8;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n2 = n3 * n8 / n7;
                                n = n3;
                                break block21;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block21;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block21;
                    }
                    n = n4;
                    n2 = n3;
                    break block21;
                }
                n = n4;
                n2 = n3;
                break block21;
            }
            n = n4;
            n2 = n3;
        }
        zzciw2.setMeasuredDimension(n, n2);
        zzciw zzciw2 = ((zzcic)((Object)zzciw2)).zzo;
        if (zzciw2 != null) {
            zzciw2.zzc(n, n2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzE(2);
        this.zzf.zzb();
        zzfpz zzfpz2 = com.google.android.gms.ads.internal.util.zzs.zza;
        Object object = new zzchu(this, mediaPlayer);
        zzfpz2.post((Runnable)object);
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = mediaPlayer.getVideoHeight();
        int n = this.zzq;
        if (n != 0) {
            this.zzq(n);
        }
        if (this.zzg && this.zzG() && this.zzj.getCurrentPosition() > 0 && this.zzi != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzF(0.0f);
            this.zzj.start();
            n = this.zzj.getCurrentPosition();
            long l = com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis();
            while (this.zzG() && this.zzj.getCurrentPosition() == n && com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis() - l <= 250L) {
            }
            this.zzj.pause();
            this.zzn();
        }
        n = this.zzl;
        int n2 = this.zzm;
        object = new StringBuilder();
        ((StringBuilder)object).append("AdMediaPlayerView stream dimensions: ");
        ((StringBuilder)object).append(n);
        ((StringBuilder)object).append(" x ");
        ((StringBuilder)object).append(n2);
        com.google.android.gms.ads.internal.util.zze.zzi((String)((StringBuilder)object).toString());
        if (this.zzi == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzC();
        surfaceTexture = com.google.android.gms.ads.internal.util.zzs.zza;
        zzchx zzchx2 = new zzchx(this);
        surfaceTexture.post((Runnable)zzchx2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzciw zzciw2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzi;
        int n4 = this.zzl == n ? (this.zzm == n2 ? 1 : 0) : 0;
        if (this.zzj != null && n3 == 3 && n4 != 0) {
            n4 = this.zzq;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzciw2 = this.zzo) != null) {
            zzciw2.zzc(n, n2);
        }
        zzciw2 = com.google.android.gms.ads.internal.util.zzs.zza;
        zzchy zzchy2 = new zzchy(this, n, n2);
        zzciw2.post(zzchy2);
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzf.zzf(this);
        this.zza.zza(surfaceTexture, this.zzr);
    }

    @Override
    public final void zzn() {
        this.zzF(this.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = n3 = mediaPlayer.getVideoHeight();
        if (this.zzl != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        stringBuilder = com.google.android.gms.ads.internal.util.zzs.zza;
        zzcht zzcht2 = new zzcht(this, n);
        stringBuilder.post(zzcht2);
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzG() && this.zzj.isPlaying()) {
            this.zzj.pause();
            this.zzE(4);
            zzfpz zzfpz2 = com.google.android.gms.ads.internal.util.zzs.zza;
            zzcib zzcib2 = new zzcib(this);
            zzfpz2.post((Runnable)zzcib2);
        }
        this.zzi = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzG()) {
            this.zzj.start();
            this.zzE(3);
            this.zza.zzb();
            zzfpz zzfpz2 = com.google.android.gms.ads.internal.util.zzs.zza;
            zzcia zzcia2 = new zzcia(this);
            zzfpz2.post((Runnable)zzcia2);
        }
        this.zzi = 3;
    }

    private final void zzD(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzciw zzciw2 = this.zzo;
        if (zzciw2 != null) {
            zzciw2.zze();
            this.zzo = null;
        }
        if ((zzciw2 = this.zzj) != null) {
            zzciw2.reset();
            this.zzj.release();
            this.zzj = null;
            this.zzE(0);
            if (bl) {
                this.zzi = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzG()) {
            this.zzj.seekTo(n);
            this.zzq = 0;
            return;
        }
        this.zzq = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(int n) {
        if (n == 3) {
            this.zzf.zzc();
            this.zzb.zzb();
        } else if (this.zzh == 3) {
            this.zzf.zze();
            this.zzb.zzc();
        }
        this.zzh = n;
    }

    @Override
    public final void zzr(zzcid zzcid2) {
        this.zzr = zzcid2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzF(float f) {
        zzcic zzcic2;
        zzcic2 = zzcic2.zzj;
        if (zzcic2 == null) {
            com.google.android.gms.ads.internal.util.zze.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            zzcic2.setVolume(f, f);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(String string2) {
        zzbeb zzbeb2 = zzbeb.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzbeb2 == null || zzbeb2.zza != null) {
            if (zzbeb2 != null) {
                string2 = Uri.parse((String)zzbeb2.zza);
            }
            this.zzk = string2;
            this.zzq = 0;
            this.zzC();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzj;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzj.release();
            this.zzj = null;
            this.zzE(0);
            this.zzi = 0;
        }
        this.zzf.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzciw zzciw2 = ((zzcic)((Object)zzciw2)).zzo;
        if (zzciw2 != null) {
            zzciw2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzcic zzcic2) {
        return zzcic2.zzs;
    }

    private final boolean zzG() {
        int n;
        return this.zzj != null && (n = this.zzh) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = (String)zzd.get(n);
        String string2 = (String)zzd.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        com.google.android.gms.ads.internal.util.zze.zzj((String)stringBuilder.toString());
        this.zzE(-1);
        this.zzi = -1;
        stringBuilder = com.google.android.gms.ads.internal.util.zzs.zza;
        zzchw zzchw2 = new zzchw(this, (String)object, string2);
        stringBuilder.post(zzchw2);
        return true;
    }

    public final boolean onInfo(MediaPlayer object, int n, int n2) {
        Object object2 = zzd;
        object = n;
        object2 = object2.get(object);
        object2 = (String)object2;
        object = zzd;
        Comparable<Integer> comparable = n2;
        object = object.get(comparable);
        object = (String)object;
        comparable = new Comparable<Integer>();
        ((StringBuilder)comparable).append("AdMediaPlayerView MediaPlayer info: ");
        ((StringBuilder)comparable).append((String)object2);
        ((StringBuilder)comparable).append(":");
        ((StringBuilder)comparable).append((String)object);
        com.google.android.gms.ads.internal.util.zze.zza(((StringBuilder)comparable).toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzj;
        if (object != null && this.zzq == 0) {
            this.zzq = object.getCurrentPosition();
        }
        if ((object = this.zzo) != null) {
            ((zzciw)object).zze();
        }
        object = com.google.android.gms.ads.internal.util.zzs.zza;
        zzchz zzchz2 = new zzchz(this);
        object.post((Runnable)zzchz2);
        this.zzD(true);
        return true;
    }
}

