/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzapu;
import com.google.android.gms.internal.ads.zzapx;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqj;
import com.google.android.gms.internal.ads.zzaqk;
import java.lang.ref.WeakReference;

public final class zzaql
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
Application.ActivityLifecycleCallbacks {
    private static final Handler zza;
    private final Context zzb;
    private Application zzc;
    @Nullable
    private final PowerManager zzd;
    @Nullable
    private final KeyguardManager zze;
    private BroadcastReceiver zzf;
    private final zzapx zzg;
    private WeakReference zzh;
    @Nullable
    private WeakReference zzi;
    private zzapu zzj;
    private byte zzk = (byte)-1;
    private int zzl = -1;
    private long zzm = -3L;

    public final long zza() {
        if (this.zzm <= -2L && this.zzb() == null) {
            this.zzm = -3L;
        }
        return this.zzm;
    }

    @Nullable
    final View zzb() {
        WeakReference weakReference = ((zzaql)((Object)weakReference)).zzi;
        if (weakReference != null) {
            return (View)weakReference.get();
        }
        return null;
    }

    static /* bridge */ /* synthetic */ void zzc(zzaql zzaql2) {
        zzaql2.zzf();
    }

    static {
        Handler handler;
        zza = handler = new Handler(Looper.getMainLooper());
    }

    public zzaql(Context context, zzapx object) {
        this.zzb = context.getApplicationContext();
        this.zzg = object;
        this.zzd = (PowerManager)this.zzb.getSystemService("power");
        this.zze = (KeyguardManager)this.zzb.getSystemService("keyguard");
        context = this.zzb;
        if (context instanceof Application) {
            context = (Application)context;
            this.zzc = context;
            super((Application)context, this);
            this.zzj = object;
        }
        this.zzd(null);
    }

    private final void zze(Activity activity, int n) {
        if (this.zzi == null) {
            return;
        }
        if ((activity = activity.getWindow()) == null) {
            return;
        }
        activity = activity.peekDecorView();
        View view = this.zzb();
        if (view != null && activity != null && view.getRootView() == activity.getRootView()) {
            this.zzl = n;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzf() {
        long l;
        long l2;
        Object object;
        if (this.zzi == null) {
            return;
        }
        View view = this.zzb();
        if (view == null) {
            this.zzm = -3L;
            this.zzk = (byte)-1;
            return;
        }
        byte by = view.getVisibility() != 0 ? (byte)1 : 0;
        if (!view.isShown()) {
            by |= 2;
        }
        if ((object = this.zzd) != null && !object.isScreenOn()) {
            by |= 4;
        }
        if (!(this.zzg.zza() || (object = this.zze) != null && object.inKeyguardRestrictedInputMode() && (object = zzaqh.zzb(view)) != null && (object = (object = object.getWindow()) == null ? null : object.getAttributes()) != null && (object.flags & 0x80000) != 0)) {
            by |= 8;
        }
        if (!view.getGlobalVisibleRect((Rect)(object = new Rect()))) {
            by |= 0x10;
        }
        if (!view.getLocalVisibleRect((Rect)(object = new Rect()))) {
            by |= 0x20;
        }
        int n = view.getWindowVisibility();
        int n2 = this.zzl;
        if (n2 != -1) {
            n = n2;
        }
        if (n != 0) {
            by |= 0x40;
        }
        if (this.zzk == by) {
            return;
        }
        this.zzk = by;
        long l3 = by == 0 ? (l2 = SystemClock.elapsedRealtime()) : (l = -3L - (long)by);
        this.zzm = l3;
    }

    private final void zzg() {
        Handler handler = zza;
        zzaqj zzaqj2 = new zzaqj(this);
        handler.post((Runnable)zzaqj2);
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zze(activity, 0);
        this.zzf();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzf();
    }

    public final void onActivityPaused(Activity activity) {
        this.zze(activity, 4);
        this.zzf();
    }

    public final void onActivityResumed(Activity activity) {
        this.zze(activity, 0);
        this.zzf();
        this.zzg();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzf();
    }

    public final void onActivityStarted(Activity activity) {
        this.zze(activity, 0);
        this.zzf();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzf();
    }

    public final void onGlobalLayout() {
        this.zzf();
    }

    public final void onScrollChanged() {
        this.zzf();
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzl = -1;
        this.zzh(view);
        this.zzf();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzl = -1;
        this.zzf();
        this.zzg();
        this.zzi(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzh(View view) {
        if ((view = view.getViewTreeObserver()).isAlive()) {
            WeakReference<View> weakReference;
            this.zzh = weakReference = new WeakReference<View>(view);
            view.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            view.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        if (this.zzf == null) {
            view = new IntentFilter();
            view.addAction("android.intent.action.SCREEN_ON");
            view.addAction("android.intent.action.SCREEN_OFF");
            view.addAction("android.intent.action.USER_PRESENT");
            zzaqk zzaqk2 = new zzaqk(this);
            this.zzf = zzaqk2;
            this.zzb.registerReceiver(this.zzf, (IntentFilter)view);
        }
        if ((view = this.zzc) == null) return;
        try {
            view.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    final void zzd(View view) {
        Object object = this.zzb();
        if (object != null) {
            object.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzi((View)object);
        }
        object = new WeakReference(view);
        this.zzi = object;
        if (view != null) {
            if (view.getWindowToken() != null || view.getWindowVisibility() != 8) {
                this.zzh(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzm = -2L;
            return;
        }
        this.zzm = -3L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void zzi(View view) {
        try {
            WeakReference weakReference = this.zzh;
            if (weakReference != null) {
                boolean bl;
                if ((weakReference = (ViewTreeObserver)weakReference.get()) != null && (bl = weakReference.isAlive())) {
                    weakReference.removeOnScrollChangedListener(this);
                    weakReference.removeGlobalOnLayoutListener(this);
                }
                this.zzh = null;
            }
        }
        catch (Exception exception) {}
        try {
            view = view.getViewTreeObserver();
            boolean bl = view.isAlive();
            if (bl) {
                view.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                view.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        if ((view = this.zzf) != null) {
            try {
                Context context = this.zzb;
                context.unregisterReceiver((BroadcastReceiver)view);
            }
            catch (Exception exception) {}
            this.zzf = null;
        }
        if ((view = this.zzc) == null) return;
        try {
            view.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

