/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzay;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzz;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbiu;
import com.google.android.gms.internal.ads.zzbjc;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzz zzz2, zzx zzx2) {
        int n;
        try {
            n = zzt.zzp().zzk(context, uri);
            if (zzz2 != null) {
                zzz2.zzg();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zze.zzj((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzx2 != null) {
            zzx2.zzb(n);
        }
        return n == 5;
    }

    public static final boolean zza(Context context, Intent intent, zzz zzz2, @Nullable zzx zzx2, boolean bl) {
        block7: {
            if (bl) {
                return zza.zzc(context, intent.getData(), zzz2, zzx2);
            }
            try {
                String string2 = intent.toURI();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Launching an intent: ");
                stringBuilder.append(string2);
                string2 = stringBuilder.toString();
                zze.zza(string2);
                zzt.zzp();
                zzs.zzJ(context, intent);
                if (zzz2 == null) break block7;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                zze.zzj((String)activityNotFoundException.getMessage());
                if (zzx2 != null) {
                    zzx2.zza(false);
                }
                return false;
            }
            zzz2.zzg();
        }
        if (zzx2 != null) {
            zzx2.zza(true);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context context, @Nullable zzc zzc2, zzz zzz2, @Nullable zzx zzx2) {
        if (zzc2 == null) {
            zze.zzj((String)"No intent data for launcher overlay.");
            return false;
        }
        zzbjc.zzc((Context)context);
        String[] stringArray = zzc2.zzh;
        if (stringArray != null) {
            return zza.zza(context, (Intent)stringArray, zzz2, zzx2, zzc2.zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.zzb)) {
            zze.zzj((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzc)) {
            intent.setDataAndType(Uri.parse((String)zzc2.zzb), zzc2.zzc);
        } else {
            intent.setData(Uri.parse((String)zzc2.zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzd)) {
            intent.setPackage(zzc2.zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zze)) {
            stringArray = zzc2.zze.split("/", 2);
            if (stringArray.length < 2) {
                zze.zzj((String)"Could not parse component name from open GMSG: ".concat(String.valueOf(zzc2.zze)));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = zzc2.zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zze.zzj((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzbiu zzbiu2 = zzbjc.zzdG;
        if (((Boolean)zzay.zzc().zzb(zzbiu2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza(context, intent, zzz2, zzx2, zzc2.zzj);
        }
        zzbiu2 = zzbjc.zzdF;
        if ((Boolean)zzay.zzc().zzb(zzbiu2) == false) return zza.zza(context, intent, zzz2, zzx2, zzc2.zzj);
        zzt.zzp();
        zzs.zzm(context, intent);
        return zza.zza(context, intent, zzz2, zzx2, zzc2.zzj);
    }
}

