/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzaaa;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzzz;
import java.util.Map;

@zzadh
public final class zzzy
extends zzaal {
    private final Map<String, String> zzbgp;
    private final Context mContext;
    private String zzbvs;
    private long zzbvt;
    private long zzbvu;
    private String zzbvv;
    private String zzbvw;

    public zzzy(zzaqw zzaqw2, Map<String, String> map) {
        super(zzaqw2, "createCalendarEvent");
        this.zzbgp = map;
        this.mContext = zzaqw2.zzto();
        zzzy zzzy2 = this;
        zzzy2.zzbvs = zzzy2.zzbu("description");
        zzzy2.zzbvv = zzzy2.zzbu("summary");
        zzzy2.zzbvt = zzzy2.zzbv("start_ticks");
        zzzy2.zzbvu = zzzy2.zzbv("end_ticks");
        zzzy2.zzbvw = zzzy2.zzbu("location");
    }

    private final String zzbu(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbgp.get(string2))) {
            return "";
        }
        return this.zzbgp.get(string2);
    }

    private final long zzbv(String string2) {
        String string3 = this.zzbgp.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbw("Activity context is not available.");
            return;
        }
        zzbv.zzek();
        if (!zzakk.zzao(this.mContext).zziz()) {
            this.zzbw("This feature is not available on the device.");
            return;
        }
        zzbv.zzek();
        AlertDialog.Builder builder = zzakk.zzan(this.mContext);
        Resources resources = zzbv.zzeo().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzzz(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzaaa(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzbvs);
        intent.putExtra("eventLocation", this.zzbvw);
        intent.putExtra("description", this.zzbvv);
        if (this.zzbvt > -1L) {
            intent.putExtra("beginTime", this.zzbvt);
        }
        if (this.zzbvu > -1L) {
            intent.putExtra("endTime", this.zzbvu);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzzy zzzy2) {
        return zzzy2.mContext;
    }
}

