/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzjj;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzpl;
import com.google.android.gms.internal.ads.zzwx;
import com.google.android.gms.internal.ads.zzwy;
import com.google.android.gms.internal.ads.zzxa;
import com.google.android.gms.internal.ads.zzxc;
import com.google.android.gms.internal.ads.zzxd;
import com.google.android.gms.internal.ads.zzxe;
import com.google.android.gms.internal.ads.zzxf;
import com.google.android.gms.internal.ads.zzxn;
import com.google.android.gms.internal.ads.zzxq;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzxw;
import com.google.android.gms.internal.ads.zzyk;
import com.google.android.gms.internal.ads.zzzv;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
public final class zzxb
implements zzxf {
    private final String zzbth;
    private final zzxn zzwh;
    private final long zzbti;
    private final zzwy zzbtj;
    private final zzwx zzbtk;
    private zzjj zzaao;
    private final zzjn zzaau;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzang zzyf;
    private final boolean zzael;
    private final zzpl zzyb;
    private final List<String> zzyc;
    private final List<String> zzbtl;
    private final List<String> zzbtm;
    private final boolean zzbtn;
    private final boolean zzbto;
    @GuardedBy(value="mLock")
    private zzxq zzbtp;
    @GuardedBy(value="mLock")
    private int zzbtq = -2;
    private zzxw zzbtr;

    public zzxb(Context context, String string2, zzxn zzxn2, zzwy zzwy2, zzwx zzwx2, zzjj zzjj2, zzjn zzjn2, zzang zzang2, boolean bl, boolean bl2, zzpl zzpl2, List<String> list, List<String> list2, List<String> list3, boolean bl3) {
        this.mContext = context;
        this.zzwh = zzxn2;
        this.zzbtk = zzwx2;
        this.zzbth = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzmh() : string2;
        this.zzbtj = zzwy2;
        this.zzbti = zzwx2.zzbsl != -1L ? zzwx2.zzbsl : (zzwy2.zzbsl != -1L ? zzwy2.zzbsl : 10000L);
        this.zzaao = zzjj2;
        this.zzaau = zzjn2;
        this.zzyf = zzang2;
        this.zzael = bl;
        this.zzbtn = bl2;
        this.zzyb = zzpl2;
        this.zzyc = list;
        this.zzbtl = list2;
        this.zzbtm = list3;
        this.zzbto = bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzbtp != null) {
                    this.zzbtp.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzakb.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzbtq = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzmh() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzbtk.zzbrv)) {
                if (this.zzwh.zzbn(this.zzbtk.zzbrv)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzdk((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzx(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbtq = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzxw zzxw2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzbtq = 0;
            this.zzbtr = zzxw2;
            this.mLock.notify();
            return;
        }
    }

    @VisibleForTesting
    private static zzxq zza(MediationAdapter mediationAdapter) {
        return new zzyk(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzxe zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzxa zzxa2 = new zzxa();
            zzakk.zzcrm.post((Runnable)new zzxc(this, zzxa2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzbti;
            zzxb zzxb2 = this;
            while (zzxb2.zzbtq == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzxb zzxb3 = zzxb2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzakb.zzdj((String)"Timed out waiting for adapter.");
                    zzxb3.zzbtq = 3;
                    continue;
                }
                try {
                    zzxb3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzxb3.zzbtq = 5;
                }
            }
            long l14 = zzbv.zzer().elapsedRealtime() - l3;
            return new zzxe(this.zzbtk, this.zzbtp, this.zzbth, zzxa2, this.zzbtq, this.zzmi(), l14);
        }
    }

    @GuardedBy(value="mLock")
    private final zzxw zzmi() {
        if (this.zzbtq != 0 || !this.zzmk()) {
            return null;
        }
        try {
            if (this.zzy(4) && this.zzbtr != null && this.zzbtr.zzmm() != 0) {
                return this.zzbtr;
            }
        }
        catch (RemoteException remoteException) {
            zzakb.zzdk((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzml();
        return new zzxd(n);
    }

    @GuardedBy(value="mLock")
    private final zzxq zzmj() {
        String string2 = String.valueOf(this.zzbth);
        zzakb.zzdj((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzael && !this.zzbtk.zzmg()) {
            zzna zzna2 = zznk.zzbai;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbth)) {
                return zzxb.zza((MediationAdapter)new AdMobAdapter());
            }
            zzna2 = zznk.zzbaj;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzbth)) {
                return zzxb.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzbth)) {
                return new zzyk((MediationAdapter)new zzzv());
            }
        }
        try {
            return this.zzwh.zzbm(this.zzbth);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzbth);
            zzakb.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    @GuardedBy(value="mLock")
    private final void zza(zzxa zzxa2) {
        String string2 = this.zzbk(this.zzbtk.zzbsb);
        try {
            if (this.zzyf.zzcvf < 4100000) {
                if (this.zzaau.zzarc) {
                    this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaao, string2, (zzxt)zzxa2);
                    return;
                }
                this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaau, this.zzaao, string2, (zzxt)zzxa2);
                return;
            }
            if (this.zzael || this.zzbtk.zzmg()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zzyc);
                if (this.zzbtl != null) {
                    for (String string3 : this.zzbtl) {
                        String string4 = ":false";
                        if (this.zzbtm != null && this.zzbtm.contains(string3)) {
                            string4 = ":true";
                        }
                        String string5 = string4;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("custom:").append(string3).append(string5).toString());
                    }
                }
                this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaao, string2, this.zzbtk.zzbrr, (zzxt)zzxa2, this.zzyb, arrayList);
                return;
            }
            if (this.zzaau.zzarc) {
                this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaao, string2, this.zzbtk.zzbrr, (zzxt)zzxa2);
                return;
            }
            if (this.zzbtn) {
                if (this.zzbtk.zzbsf != null) {
                    this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaao, string2, this.zzbtk.zzbrr, (zzxt)zzxa2, new zzpl(zzxb.zzbl(this.zzbtk.zzbsj)), this.zzbtk.zzbsi);
                    return;
                }
                this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaau, this.zzaao, string2, this.zzbtk.zzbrr, (zzxt)zzxa2);
                return;
            }
            this.zzbtp.zza(ObjectWrapper.wrap((Object)this.mContext), this.zzaau, this.zzaao, string2, this.zzbtk.zzbrr, (zzxt)zzxa2);
            return;
        }
        catch (RemoteException remoteException) {
            zzakb.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzx(5);
            return;
        }
    }

    @GuardedBy(value="mLock")
    private final boolean zzy(int n) {
        Bundle bundle;
        try {
            bundle = this.zzael ? this.zzbtp.zzmr() : (this.zzaau.zzarc ? this.zzbtp.getInterstitialAdapterInfo() : this.zzbtp.zzmq());
        }
        catch (RemoteException remoteException) {
            zzakb.zzdk((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzmk() {
        return this.zzbtj.zzbsx != -1;
    }

    @GuardedBy(value="mLock")
    private final String zzbk(String string2) {
        if (string2 == null || !this.zzmk() || this.zzy(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzakb.zzdk((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    @GuardedBy(value="mLock")
    private final int zzml() {
        JSONObject jSONObject;
        if (this.zzbtk.zzbsb == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzbtk.zzbsb);
        }
        catch (JSONException jSONException) {
            zzakb.zzdk((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbth)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzy(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzbl(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string4 = string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string4) ? 2 : ("portrait".equals(string4) ? 1 : ("any".equals(string4) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzakb.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzxb zzxb2) {
        return zzxb2.mLock;
    }

    static /* synthetic */ int zzb(zzxb zzxb2) {
        return zzxb2.zzbtq;
    }

    static /* synthetic */ zzxq zza(zzxb zzxb2, zzxq zzxq2) {
        zzxb2.zzbtp = zzxq2;
        return zzxb2.zzbtp;
    }

    static /* synthetic */ zzxq zzc(zzxb zzxb2) {
        return zzxb2.zzmj();
    }

    static /* synthetic */ zzxq zzd(zzxb zzxb2) {
        return zzxb2.zzbtp;
    }

    static /* synthetic */ boolean zze(zzxb zzxb2) {
        return zzxb2.zzmk();
    }

    static /* synthetic */ boolean zza(zzxb zzxb2, int n) {
        return zzxb2.zzy(1);
    }

    static /* synthetic */ String zzf(zzxb zzxb2) {
        return zzxb2.zzbth;
    }

    static /* synthetic */ void zza(zzxb zzxb2, zzxa zzxa2) {
        zzxb2.zza(zzxa2);
    }
}

