/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzagb;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzjj;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzss;
import com.google.android.gms.internal.ads.zztx;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzua;
import com.google.android.gms.internal.ads.zzuc;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zztw {
    private final Map<zztx, zzty> zzbok = new HashMap<zztx, zzty>();
    private final LinkedList<zztx> zzbol = new LinkedList();
    @Nullable
    private zzss zzbom;

    final void zza(zzss zzss2) {
        if (this.zzbom == null) {
            this.zzbom = zzss2.zzlc();
            zztw zztw2 = this;
            if (zztw2.zzbom != null) {
                SharedPreferences sharedPreferences = zztw2.zzbom.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zztw zztw3 = zztw2;
                while (zztw3.zzbol.size() > 0) {
                    zztx zztx2 = zztw3.zzbol.remove();
                    zzty zzty2 = zztw3.zzbok.get(zztx2);
                    zztw.zza("Flushing interstitial queue for %s.", zztx2);
                    while (zzty2.size() > 0) {
                        zzty2.zzl(null).zzbor.zzdj();
                    }
                    zztw3.zzbok.remove(zztx2);
                }
                try {
                    zztx zztx2;
                    HashMap<String, zztx> hashMap = new HashMap<String, zztx>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zzuc zzuc2 = zzuc.zzba((String)stringArray.getValue());
                        zztx2 = new zztx(zzuc2.zzaao, zzuc2.zzye, zzuc2.zzbop);
                        if (zztw2.zzbok.containsKey(zztx2)) continue;
                        zzty zzty2 = new zzty(zzuc2.zzaao, zzuc2.zzye, zzuc2.zzbop);
                        zztw2.zzbok.put(zztx2, zzty2);
                        hashMap.put(zztx2.toString(), zztx2);
                        zztw.zza("Restored interstitial queue for %s.", zztx2);
                    }
                    for (String string2 : zztw.zzax(sharedPreferences.getString("PoolKeys", ""))) {
                        zztx2 = (zztx)hashMap.get(string2);
                        if (!zztw2.zzbok.containsKey(zztx2)) continue;
                        zztw2.zzbol.add(zztx2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbv.zzeo().zza(exception, "InterstitialAdPool.restore");
                    zzakb.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zztw2.zzbok.clear();
                    zztw2.zzbol.clear();
                }
            }
        }
    }

    @Nullable
    final zztz zza(zzjj zzjj2, String string2) {
        Object object;
        Object object2;
        zzna zzna2;
        String string3;
        if (zztw.zzay(string2)) {
            return null;
        }
        Context context = this.zzbom.getApplicationContext();
        int n = new zzagb((Context)context).zzoo().zzcjx;
        zzjj zzjj3 = zztw.zzj(zzjj2);
        zztx zztx2 = new zztx(zzjj3, string3 = zztw.zzaz(string2), n);
        zzty zzty2 = this.zzbok.get(zztx2);
        if (zzty2 == null) {
            zztw.zza("Interstitial pool created at %s.", zztx2);
            zzty2 = new zzty(zzjj3, string3, n);
            this.zzbok.put(zztx2, zzty2);
        }
        this.zzbol.remove(zztx2);
        this.zzbol.add(zztx2);
        zzty2.zzli();
        while (true) {
            zzna2 = zznk.zzazc;
            if (this.zzbol.size() <= (Integer)zzkb.zzik().zzd(zzna2)) break;
            object2 = this.zzbol.remove();
            object = this.zzbok.get(object2);
            zztw.zza("Evicting interstitial queue for %s.", (zztx)object2);
            while (((zzty)object).size() > 0) {
                zztz zztz2 = ((zzty)object).zzl(null);
                if (zztz2.zzwa) {
                    zzua.zzlk().zzlm();
                }
                zztz2.zzbor.zzdj();
            }
            this.zzbok.remove(object2);
        }
        while (zzty2.size() > 0) {
            object2 = zzty2.zzl(zzjj3);
            if (((zztz)object2).zzwa) {
                zzna2 = zznk.zzaze;
                if (zzbv.zzer().currentTimeMillis() - ((zztz)object2).zzbou > 1000L * (long)((Integer)zzkb.zzik().zzd(zzna2)).intValue()) {
                    zztw.zza("Expired interstitial at %s.", zztx2);
                    zzua.zzlk().zzll();
                    continue;
                }
            }
            object = ((zztz)object2).zzbos != null ? " (inline) " : " ";
            zztw.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zztx2);
            return object2;
        }
        return null;
    }

    final void zzb(zzjj zzjj2, String string2) {
        String string3;
        if (this.zzbom == null) {
            return;
        }
        Context context = this.zzbom.getApplicationContext();
        int n = new zzagb((Context)context).zzoo().zzcjx;
        zzjj zzjj3 = zztw.zzj(zzjj2);
        zztx zztx2 = new zztx(zzjj3, string3 = zztw.zzaz(string2), n);
        zzty zzty2 = this.zzbok.get(zztx2);
        if (zzty2 == null) {
            zztw.zza("Interstitial pool created at %s.", zztx2);
            zzty2 = new zzty(zzjj3, string3, n);
            this.zzbok.put(zztx2, zzty2);
        }
        zzty2.zza(this.zzbom, zzjj2);
        zzty2.zzli();
        zztw.zza("Inline entry added to the queue at %s.", zztx2);
    }

    final void zzld() {
        zztw zztw2;
        if (this.zzbom == null) {
            return;
        }
        for (Map.Entry<zztx, zzty> entry : this.zzbok.entrySet()) {
            int n;
            zztx zztx2 = entry.getKey();
            zzty zzty2 = entry.getValue();
            if (zzakb.isLoggable((int)2)) {
                n = zzty2.size();
                int n2 = zzty2.zzlg();
                if (n2 < n) {
                    zzakb.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zztx2));
                }
            }
            n = 0 + zzty2.zzlh();
            while (true) {
                zztw2 = zznk.zzazd;
                if (zzty2.size() >= (Integer)zzkb.zzik().zzd((zzna)zztw2)) break;
                zztw.zza("Pooling and loading one new interstitial for %s.", zztx2);
                if (!zzty2.zzb(this.zzbom)) continue;
                ++n;
            }
            zzua.zzlk().zzw(n);
        }
        zztw2 = this;
        if (zztw2.zzbom != null) {
            SharedPreferences.Editor editor = zztw2.zzbom.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zztx, zzty> entry : zztw2.zzbok.entrySet()) {
                zztx zztx3 = entry.getKey();
                zzty zzty3 = entry.getValue();
                if (!zzty3.zzlj()) continue;
                String string2 = new zzuc(zzty3).zzlu();
                String string3 = zztx3.toString();
                editor.putString(string3, string2);
                zztw.zza("Saved interstitial queue for %s.", zztx3);
            }
            editor.putString("PoolKeys", zztw2.zzle());
            editor.apply();
        }
    }

    private final String zzle() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbol.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zztx)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzax(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzay(String string2) {
        try {
            zzna zzna2 = zznk.zzazf;
            return Pattern.matches((String)zzkb.zzik().zzd(zzna2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbv.zzeo().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzh(zzjj zzjj2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzjj2.extras.keySet());
        Bundle bundle = zzjj2.zzaqg.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzjj zzi(zzjj zzjj2) {
        zzjj zzjj3 = zztw.zzk(zzjj2);
        String string2 = "_skipMediation";
        zzjj zzjj4 = zzjj3;
        Bundle bundle = zzjj3.zzaqg.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzjj4.extras.putBoolean(string2, true);
        return zzjj3;
    }

    @VisibleForTesting
    private static zzjj zzj(zzjj zzjj2) {
        zzjj zzjj3 = zztw.zzk(zzjj2);
        zzna zzna2 = zznk.zzazb;
        for (String string2 : ((String)zzkb.zzik().zzd(zzna2)).split(",")) {
            zztw.zzb(zzjj3.zzaqg, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zztw.zzb(zzjj3.extras, string4);
        }
        return zzjj3;
    }

    @VisibleForTesting
    private static String zzaz(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    @VisibleForTesting
    private static zzjj zzk(zzjj zzjj2) {
        Parcel parcel = Parcel.obtain();
        zzjj2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzjj zzjj3 = (zzjj)zzjj.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzna zzna2 = zznk.zzayo;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            zzjj3 = zzjj3.zzhv();
        }
        return zzjj3;
    }

    private static void zzb(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zztx zztx2) {
        if (zzakb.isLoggable((int)2)) {
            zzakb.v(String.format(string2, zztx2));
        }
    }
}

