/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzacm;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzaix;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzakq;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzanm;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzarc;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzce;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzoj;
import com.google.android.gms.internal.ads.zzok;
import com.google.android.gms.internal.ads.zzom;
import com.google.android.gms.internal.ads.zzox;
import com.google.android.gms.internal.ads.zzoz;
import com.google.android.gms.internal.ads.zzpa;
import com.google.android.gms.internal.ads.zzpb;
import com.google.android.gms.internal.ads.zzpc;
import com.google.android.gms.internal.ads.zzpf;
import com.google.android.gms.internal.ads.zzpw;
import com.google.android.gms.internal.ads.zzpx;
import com.google.android.gms.internal.ads.zzro;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
public class zzpd
implements zzoz {
    private final Object mLock = new Object();
    private final zzpa zzbiw;
    private final Context mContext;
    private final zzok zzbiz;
    @Nullable
    private final JSONObject zzbja;
    @Nullable
    private final zzacm zzaad;
    @Nullable
    private final zzpb zzbjb;
    private final zzci zzbjc;
    @Nullable
    private final zzang zzyf;
    @VisibleForTesting
    boolean zzbjd;
    @VisibleForTesting
    boolean zzbje;
    @Nullable
    private String zzaae;
    @Nullable
    private zzaix zzyv;
    private WeakReference<View> zzbjf = null;

    public zzpd(Context context, zzpa zzpa2, @Nullable zzacm zzacm2, zzci zzci2, @Nullable JSONObject jSONObject, @Nullable zzpb zzpb2, @Nullable zzang zzang2, @Nullable String string2) {
        this.mContext = context;
        this.zzbiw = zzpa2;
        this.zzaad = zzacm2;
        this.zzbjc = zzci2;
        this.zzbja = jSONObject;
        this.zzbjb = zzpb2;
        this.zzyf = zzang2;
        this.zzaae = string2;
        this.zzbiz = new zzok(this.zzaad);
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zzoj zzoj2 = this.zzbjb.zzkc();
        if (zzoj2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zzoj2.zzju()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zzom zzom2 = new zzom(this.mContext, zzoj2, layoutParams);
        zzom2.setOnClickListener(onClickListener);
        zzna zzna2 = zznk.zzbbz;
        zzom2.setContentDescription((CharSequence)zzkb.zzik().zzd(zzna2));
        return zzom2;
    }

    @Override
    public boolean zzkj() {
        zzoj zzoj2 = this.zzbjb.zzkc();
        return zzoj2 != null && zzoj2.zzjv();
    }

    @Override
    public boolean zzkk() {
        return this.zzbja != null && this.zzbja.optBoolean("allow_pub_owned_ad_view", false);
    }

    private final boolean zzaq(String string2) {
        JSONObject jSONObject = this.zzbja == null ? null : this.zzbja.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, String string2, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzo(view2);
        JSONObject jSONObject3 = zzpd.zzp(view2);
        JSONObject jSONObject4 = this.zzq(view2);
        JSONObject jSONObject5 = null;
        try {
            JSONObject jSONObject6 = zzbv.zzek().zza(bundle, null);
            jSONObject5 = new JSONObject();
            jSONObject5.put("click_point", (Object)jSONObject6);
            jSONObject5.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (map != null) {
            Map<String, WeakReference<View>> map2 = map;
            synchronized (map2) {
                for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                    View view3 = (View)entry.getValue().get();
                    if (!view.equals(view3)) continue;
                    this.zza(view, entry.getKey(), bundle, map, view2);
                    return;
                }
            }
        }
        if ("6".equals(this.zzbjb.zzkb())) {
            this.zza(view, "3099", bundle, map, view2);
            return;
        }
        if ("2".equals(this.zzbjb.zzkb())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzbjb.zzkb())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzakb.zzck((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzaq("click_reporting")) {
            zzakb.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string2 = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbv.zzek().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, String string2, JSONObject jSONObject5, JSONObject jSONObject6) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzbja);
            if (jSONObject2 != null) {
                jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject7.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject5 != null) {
                jSONObject7.put("click_signal", (Object)jSONObject5);
            }
            if (jSONObject3 != null) {
                jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            }
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", (Object)this.zzbjb.zzkb());
            zzbv.zzem();
            jSONObject8.put("is_privileged_process", zzakq.zzrp());
            zzna zzna2 = zznk.zzbcf;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && this.zzbiz.zzjw() != null && this.zzbja.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject8.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject8.put("timestamp", zzbv.zzer().currentTimeMillis());
            jSONObject8.put("has_custom_click_handler", this.zzbiw.zzr(this.zzbjb.getCustomTemplateId()) != null);
            jSONObject7.put("has_custom_click_handler", this.zzbiw.zzr(this.zzbjb.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject9 = this.zzbja.optJSONObject("tracking_urls_and_actions");
                if (jSONObject9 == null) {
                    jSONObject9 = new JSONObject();
                }
                String string3 = jSONObject9.optString("click_string");
                String string4 = this.zzbjc.zzaa().zza(this.mContext, string3, view);
                jSONObject8.put("click_signals", (Object)string4);
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject7.put("click", (Object)jSONObject8);
            if (jSONObject6 != null) {
                jSONObject7.put("provided_signals", (Object)jSONObject6);
            }
            jSONObject7.put("ads_id", (Object)this.zzaae);
            zzanm.zza(this.zzaad.zzi(jSONObject7), "NativeAdEngineImpl.performClick");
            return;
        }
        catch (JSONException jSONException) {
            zzakb.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzbjc.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzakb.zzck((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzaq("touch_reporting")) {
            zzakb.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbjc.zzaa().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbjd) {
                return;
            }
            if (zzpd.zzm(view)) {
                this.zza(view, map);
                return;
            }
            zzna zzna2 = zznk.zzbce;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && map != null) {
                Map<String, WeakReference<View>> map2 = map;
                synchronized (map2) {
                    Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        View view2 = (View)iterator.next().getValue().get();
                        if (view2 == null || !zzpd.zzm(view2)) continue;
                        this.zza(view, map);
                        return;
                    }
                }
            }
            return;
        }
    }

    private static boolean zzm(View view) {
        return view.isShown() && view.getGlobalVisibleRect(new Rect(), null);
    }

    @Override
    public void zzcr() {
        this.zzbiw.zzcr();
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzo(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzpd.zzp(view);
        JSONObject jSONObject4 = this.zzq(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, jSONObject4, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzaq("impression_reporting")) {
            zzakb.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbv.zzek().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4, JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (this.zzbjd) {
            return true;
        }
        this.zzbjd = true;
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbja);
            jSONObject6.put("ads_id", (Object)this.zzaae);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            }
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            zzanm.zza(this.zzaad.zzj(jSONObject6), "NativeAdEngineImpl.recordImpression");
        }
        catch (JSONException jSONException) {
            zzakb.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbiw.zza(this);
        this.zzbiw.zzbv();
        this.zzcr();
        return true;
    }

    @Override
    public void zzkl() {
        Preconditions.checkMainThread((String)"Invalid call from a non-UI thread.");
        if (this.zzbje) {
            return;
        }
        this.zzbje = true;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzbja);
            jSONObject.put("ads_id", (Object)this.zzaae);
            zzanm.zza(this.zzaad.zzk(jSONObject), "NativeAdEngineImpl.recordDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzane.zzb((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final View zzkr() {
        if (this.zzbjf != null) {
            return (View)this.zzbjf.get();
        }
        return null;
    }

    @Override
    public final void zzl(View view) {
        this.zzbjf = new WeakReference<View>(view);
    }

    @Override
    public final void zzj(View view) {
        zzce zzce2;
        zzna zzna2 = zznk.zzbat;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return;
        }
        if (this.zzbjc != null && (zzce2 = this.zzbjc.zzaa()) != null) {
            zzce2.zzb(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        Map<String, WeakReference<View>> map3;
        zzna zzna2 = zznk.zzbbw;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map != null) {
            map3 = map;
            synchronized (map3) {
                iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                    view2.setClickable(true);
                    view2.setOnClickListener(onClickListener);
                }
            }
        }
        if (map2 != null) {
            map3 = map2;
            synchronized (map3) {
                iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    view2 = (View)iterator.next().getValue().get();
                    if (view2 == null) continue;
                    view2.setOnTouchListener(onTouchListener);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzna zzna2 = zznk.zzbbv;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                View view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(null);
                view2.setClickable(false);
                view2.setOnClickListener(null);
            }
            return;
        }
    }

    public zzaqw zzko() throws zzarg {
        if (this.zzbja == null || this.zzbja.optJSONObject("overlay") == null) {
            return null;
        }
        zzpd zzpd2 = this;
        zzbv.zzel();
        zzang zzang2 = zzpd2.zzyf;
        zzci zzci2 = zzpd2.zzbjc;
        zzjn zzjn2 = zzjn.zzf((Context)zzpd2.mContext);
        Context context = zzpd2.mContext;
        zzaqw zzaqw2 = zzarc.zza(context, zzasi.zzb(zzjn2), zzjn2.zzarb, false, false, zzci2, zzang2, null, null, null, zzhs.zzhm());
        if (zzaqw2 != null) {
            zzaqw2.getView().setVisibility(8);
            new zzpf(zzaqw2).zza(this.zzaad);
        }
        return zzaqw2;
    }

    public final void zzf(Map<String, WeakReference<View>> map) {
        if (this.zzbjb.zzkd() != null) {
            if ("2".equals(this.zzbjb.zzkb())) {
                zzbv.zzeo().zzqh().zza(this.zzbiw.getAdUnitId(), this.zzbjb.zzkb(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzbjb.zzkb())) {
                zzbv.zzeo().zzqh().zza(this.zzbiw.getAdUnitId(), this.zzbjb.zzkb(), map.containsKey("1009"));
            }
        }
    }

    public final boolean zzb(View view, zzox zzox2) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        View view2 = this.zzbjb.zzkd();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).removeAllViews();
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbiw.zza(zzox2);
            return true;
        }
        return false;
    }

    public final void zzi(View view) {
        this.zzbiw.zzi(view);
    }

    @Override
    public final void zza(View view, zzox zzox2) {
        Object object;
        zzpw zzpw2;
        if (this.zzb(view, zzox2)) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        ((FrameLayout)view).removeAllViews();
        if (!(this.zzbjb instanceof zzpc)) {
            return;
        }
        zzpc zzpc2 = (zzpc)this.zzbjb;
        if (zzpc2.getImages() != null && zzpc2.getImages().size() > 0 && (zzpw2 = (object = zzpc2.getImages().get(0)) instanceof IBinder ? zzpx.zzh((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzpw2.zzjy();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzpd)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzakb.zzdk((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public void zza(zzro zzro2) {
        zzna zzna2 = zznk.zzbcf;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return;
        }
        if (!this.zzbja.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzakb.zzdk((String)"Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzbiz.zza(zzro2);
    }

    @Override
    public void cancelUnconfirmedClick() {
        zzna zzna2 = zznk.zzbcf;
        if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            return;
        }
        if (!this.zzbja.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzakb.zzdk((String)"Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzbiz.cancelUnconfirmedClick();
    }

    @Override
    public void setClickConfirmingView(View view) {
        Object object = zznk.zzbcf;
        if (!((Boolean)zzkb.zzik().zzd(object)).booleanValue()) {
            return;
        }
        if (!this.zzbja.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzakb.zzdk((String)"Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        object = this.zzbiz;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)object);
            view2.setClickable(true);
            object.zzbhq = new WeakReference<View>(view2);
        }
    }

    @Override
    public void zzkq() {
        this.zzbiw.zzct();
    }

    @Override
    public void zzcs() {
        this.zzbiw.zzcs();
    }

    @Override
    public void zzkp() {
        this.zzaad.zzmc();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @VisibleForTesting
    private static int[] zzn(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    @VisibleForTesting
    private final int zzv(int n) {
        zzkb.zzif();
        return zzamu.zzb((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzv(rect.right - rect.left));
        jSONObject.put("height", this.zzv(rect.bottom - rect.top));
        jSONObject.put("x", this.zzv(rect.left));
        jSONObject.put("y", this.zzv(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzo(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzpd.zzn(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzv(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzv(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzv(nArray[0]));
            jSONObject3.put("y", this.zzv(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzv(nArray[0]));
                jSONObject2.put("y", this.zzv(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzakb.zzdk((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzp(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzek();
            int n = zzakk.zzx(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzq(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzek();
            jSONObject.put("can_show_on_lock_screen", zzakk.zzw(view));
            zzbv.zzek();
            jSONObject.put("is_keyguard_locked", zzakk.zzau(this.mContext));
        }
        catch (JSONException jSONException) {
            zzakb.zzdk((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzpd.zzn(view);
        Map<String, WeakReference<View>> map2 = map;
        synchronized (map2) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (view2 == null) continue;
                int[] nArray2 = zzpd.zzn(view2);
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = new JSONObject();
                try {
                    JSONObject jSONObject4;
                    jSONObject3.put("width", this.zzv(view2.getMeasuredWidth()));
                    jSONObject3.put("height", this.zzv(view2.getMeasuredHeight()));
                    jSONObject3.put("x", this.zzv(nArray2[0] - nArray[0]));
                    jSONObject3.put("y", this.zzv(nArray2[1] - nArray[1]));
                    jSONObject3.put("relative_to", (Object)"ad_view");
                    jSONObject2.put("frame", (Object)jSONObject3);
                    Rect rect = new Rect();
                    if (view2.getLocalVisibleRect(rect)) {
                        jSONObject4 = this.zzb(rect);
                    } else {
                        jSONObject4 = new JSONObject();
                        jSONObject4.put("width", 0);
                        jSONObject4.put("height", 0);
                        jSONObject4.put("x", this.zzv(nArray2[0] - nArray[0]));
                        jSONObject4.put("y", this.zzv(nArray2[1] - nArray[1]));
                        jSONObject4.put("relative_to", (Object)"ad_view");
                    }
                    jSONObject2.put("visible_bounds", (Object)jSONObject4);
                    if (view2 instanceof TextView) {
                        TextView textView = (TextView)view2;
                        jSONObject2.put("text_color", textView.getCurrentTextColor());
                        jSONObject2.put("font_size", (double)textView.getTextSize());
                        jSONObject2.put("text", (Object)textView.getText());
                    }
                    jSONObject.put(entry.getKey(), (Object)jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzakb.zzdk((String)"Unable to get asset views information");
                }
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzaix zzks() {
        if (zzbv.zzfh().zzu(this.mContext)) {
            if (this.zzyv == null) {
                this.zzyv = new zzaix(this.mContext, this.zzbiw.getAdUnitId());
            }
            return this.zzyv;
        }
        return null;
    }
}

