/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzge;
import com.google.android.gms.internal.ads.zzgf;
import com.google.android.gms.internal.ads.zzgl;
import com.google.android.gms.internal.ads.zzgm;
import com.google.android.gms.internal.ads.zzgo;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzgk
extends Thread {
    private boolean mStarted = false;
    private boolean zzahy = false;
    private boolean zzbm = false;
    private final Object mLock;
    private final zzgf zzahz;
    private final zzadf zzaia;
    private final int zzaib;
    private final int zzagx;
    private final int zzaic;
    private final int zzagz;
    private final int zzaid;
    private final int zzaie;
    private final int zzaif;
    private final int zzaig;
    private final String zzaih;
    private final boolean zzaii;

    public zzgk(zzgf zzgf2, zzadf zzadf2) {
        this.zzahz = zzgf2;
        this.zzaia = zzadf2;
        this.mLock = new Object();
        zzna zzna2 = zznk.zzawl;
        this.zzagx = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawm;
        this.zzaic = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawn;
        this.zzagz = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawo;
        this.zzaid = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawr;
        this.zzaie = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawt;
        this.zzaif = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawu;
        this.zzaig = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawp;
        this.zzaib = (Integer)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzaww;
        this.zzaih = (String)zzkb.zzik().zzd(zzna2);
        zzna2 = zznk.zzawy;
        this.zzaii = (Boolean)zzkb.zzik().zzd(zzna2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgw() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzakb.zzck((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgk.zzgx()) {
                    object = zzbv.zzen().getActivity();
                    if (object == null) {
                        zzakb.zzck((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgz();
                    } else {
                        Activity activity = object;
                        zzgk zzgk2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbv.zzeo().zza(exception, "ContentFetchTask.extractContent");
                                zzakb.zzck((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgk zzgk3 = zzgk2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzgl(zzgk3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzakb.zzck((String)"ContentFetchTask: sleeping");
                    this.zzgz();
                }
                Thread.sleep(this.zzaib * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzakb.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                this.zzaia.zza((Throwable)exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzahy) {
                    try {
                        zzakb.zzck((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzk(View view) {
        try {
            zzge zzge2 = new zzge(this.zzagx, this.zzaic, this.zzagz, this.zzaid, this.zzaie, this.zzaif, this.zzaig);
            Context context = zzbv.zzen().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzaih)) {
                zzna zzna2 = zznk.zzawv;
                int n = context.getResources().getIdentifier((String)zzkb.zzik().zzd(zzna2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzaih)) {
                    return;
                }
            }
            zzgo zzgo2 = this.zza(view, zzge2);
            zzge2.zzgt();
            if (zzgo2.zzaiq == 0 && zzgo2.zzair == 0) {
                return;
            }
            if (zzgo2.zzair == 0 && zzge2.zzgu() == 0) {
                return;
            }
            if (zzgo2.zzair == 0 && this.zzahz.zza(zzge2)) {
                return;
            }
            this.zzahz.zzc(zzge2);
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzaia.zza((Throwable)exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzgx() {
        try {
            Context context = zzbv.zzen().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbv.zzeo().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzgo zza(@Nullable View view, zzge zzge2) {
        if (view == null) {
            return new zzgo(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzge2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzgo(this, 1, 0);
            }
            return new zzgo(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzaqw)) {
            boolean bl2;
            zzge2.zzgs();
            zzge zzge3 = zzge2;
            WebView webView = (WebView)view;
            zzgk zzgk2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzge3.zzgs();
                webView.post((Runnable)new zzgm(zzgk2, zzge3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzgo(this, 0, 1);
            }
            return new zzgo(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzgo zzgo2 = this.zza(viewGroup.getChildAt(i), zzge2);
                n += zzgo2.zzaiq;
                n2 += zzgo2.zzair;
            }
            return new zzgo(this, n, n2);
        }
        return new zzgo(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzge zzge2, WebView webView, String string2, boolean bl) {
        zzge2.zzgr();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzaii && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzge2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzge2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzge2.zzgn()) {
                this.zzahz.zzb(zzge2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzakb.zzck((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzakb.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzaia.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzge zzgy() {
        return this.zzahz.zzgv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzahy = false;
            this.mLock.notifyAll();
            zzakb.zzck((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgz() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzahy = true;
            zzakb.zzck((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzha() {
        return this.zzahy;
    }
}

