/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzfq;
import com.google.android.gms.internal.ads.zzfr;
import com.google.android.gms.internal.ads.zzfs;
import com.google.android.gms.internal.ads.zzft;
import com.google.android.gms.internal.ads.zzfu;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzadh
@TargetApi(value=14)
public final class zzfp
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzagc;
    private final Context zzaeo;
    private Application zzagd;
    private final WindowManager zzaeu;
    private final PowerManager zzaev;
    private final KeyguardManager zzaew;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzafe;
    private WeakReference<ViewTreeObserver> zzage;
    private WeakReference<View> zzagf;
    private zzfu zzagg;
    private zzamj zzadz = new zzamj(zzagc);
    private boolean zzafd = false;
    private int zzagh = -1;
    private final HashSet<zzft> zzagi = new HashSet();
    private final DisplayMetrics zzagj;
    private final Rect zzafh;

    public zzfp(Context context, View view) {
        this.zzaeo = context.getApplicationContext();
        this.zzaeu = (WindowManager)context.getSystemService("window");
        this.zzaev = (PowerManager)this.zzaeo.getSystemService("power");
        this.zzaew = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzaeo instanceof Application) {
            this.zzagd = (Application)this.zzaeo;
            this.zzagg = new zzfu((Application)this.zzaeo, this);
        }
        this.zzagj = context.getResources().getDisplayMetrics();
        this.zzafh = new Rect();
        this.zzafh.right = this.zzaeu.getDefaultDisplay().getWidth();
        this.zzafh.bottom = this.zzaeu.getDefaultDisplay().getHeight();
        View view2 = view;
        zzfp zzfp2 = this;
        View view3 = zzfp2.zzagf != null ? (View)zzfp2.zzagf.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfp2);
            zzfp2.zzf(view3);
        }
        zzfp2.zzagf = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbv.zzem().isAttachedToWindow(view2)) {
                zzfp2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzfp2);
        }
    }

    public final void zza(zzft zzft2) {
        this.zzagi.add(zzft2);
        this.zzm(3);
    }

    public final void zzb(zzft zzft2) {
        this.zzagi.remove(zzft2);
    }

    private final void zzao() {
        zzbv.zzek();
        zzakk.zzcrm.post((Runnable)new zzfq(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzagh = -1;
        this.zze(view);
        this.zzm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzagh = -1;
        this.zzm(3);
        this.zzao();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzagf == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzagf.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzagh = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzm(3);
        this.zzao();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzm(3);
        this.zzao();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzm(3);
        this.zzao();
    }

    public final void onGlobalLayout() {
        this.zzm(2);
        this.zzao();
    }

    public final void onScrollChanged() {
        this.zzm(1);
    }

    public final void zzgm() {
        this.zzm(4);
    }

    private final void zzm(int n) {
        boolean bl;
        if (this.zzagi.size() == 0) {
            return;
        }
        if (this.zzagf == null) {
            return;
        }
        View view = (View)this.zzagf.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzagh != -1 ? this.zzagh : n2;
        boolean bl6 = bl = !bl3 && zzbv.zzek().zza(view, this.zzaev, this.zzaew) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzadz.tryAcquire() && bl == this.zzafd) {
            return;
        }
        if (!bl && !this.zzafd && n == 1) {
            return;
        }
        zzfs zzfs2 = new zzfs(zzbv.zzer().elapsedRealtime(), this.zzaev.isScreenOn(), view != null ? zzbv.zzem().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(this.zzafh), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzagj.density, bl);
        Iterator<zzft> iterator = this.zzagi.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzfs2);
        }
        this.zzafd = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzn(rect.left), this.zzn(rect.top), this.zzn(rect.right), this.zzn(rect.bottom));
    }

    private final int zzn(int n) {
        float f = this.zzagj.density;
        return (int)((float)n / f);
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzage = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzfp zzfp2 = this;
        if (zzfp2.zzafe == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzfp2.zzafe = new zzfr(zzfp2);
            zzbv.zzfk().zza(zzfp2.zzaeo, zzfp2.zzafe, intentFilter);
        }
        if (this.zzagd != null) {
            try {
                this.zzagd.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzagg);
                return;
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzage != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzage.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzage = null;
            }
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzfp zzfp2 = this;
        if (zzfp2.zzafe != null) {
            try {
                zzbv.zzfk().zza(zzfp2.zzaeo, zzfp2.zzafe);
            }
            catch (IllegalStateException illegalStateException) {
                zzakb.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbv.zzeo().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzfp2.zzafe = null;
        }
        if (this.zzagd != null) {
            try {
                this.zzagd.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzagg);
                return;
            }
            catch (Exception exception) {
                zzakb.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzfp zzfp2, int n) {
        zzfp2.zzm(3);
    }

    static {
        zzna zzna2 = zznk.zzazt;
        zzagc = (Long)zzkb.zzik().zzd(zzna2);
    }
}

