/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzajh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzalb;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzeq;
import com.google.android.gms.internal.ads.zzer;
import com.google.android.gms.internal.ads.zzeu;
import com.google.android.gms.internal.ads.zzew;
import com.google.android.gms.internal.ads.zzfa;
import com.google.android.gms.internal.ads.zzfo;
import com.google.android.gms.internal.ads.zzgd;
import com.google.android.gms.internal.ads.zzjn;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
public final class zzet
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object mLock = new Object();
    private final WeakReference<zzajh> zzaeq;
    private WeakReference<ViewTreeObserver> zzaer;
    private final zzgd zzaes;
    protected final zzer zzaet;
    private final Context zzaeo;
    private final WindowManager zzaeu;
    private final PowerManager zzaev;
    private final KeyguardManager zzaew;
    private final DisplayMetrics zzaex;
    @Nullable
    private zzfa zzaey;
    private boolean zzaez;
    private boolean zzaaq = false;
    private boolean zzafa = false;
    private boolean zzafb;
    private boolean zzafc;
    private boolean zzafd;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzafe;
    private final HashSet<zzeq> zzaff = new HashSet();
    private zzamj zzadz;
    private final HashSet<zzfo> zzafg = new HashSet();
    private final Rect zzafh = new Rect();
    private final zzew zzafi;
    private float zzafj;

    public zzet(Context context, zzjn zzjn2, zzajh zzajh2, zzang zzang2, zzgd zzgd2) {
        this.zzaeq = new WeakReference<zzajh>(zzajh2);
        this.zzaes = zzgd2;
        this.zzaer = new WeakReference<Object>(null);
        this.zzafb = true;
        this.zzafd = false;
        this.zzadz = new zzamj(200L);
        this.zzaet = new zzer(UUID.randomUUID().toString(), zzang2, zzjn2.zzarb, zzajh2.zzcob, zzajh2.zzfz(), zzjn2.zzare);
        this.zzaeu = (WindowManager)context.getSystemService("window");
        this.zzaev = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzaew = (KeyguardManager)context.getSystemService("keyguard");
        this.zzaeo = context;
        this.zzafi = new zzew(this, new Handler());
        this.zzaeo.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzafi);
        this.zzaex = context.getResources().getDisplayMetrics();
        Display display = this.zzaeu.getDefaultDisplay();
        this.zzafh.right = display.getWidth();
        this.zzafh.bottom = display.getHeight();
        this.zzgb();
    }

    public final void zzgb() {
        this.zzafj = zzalb.zzay(this.zzaeo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgc() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzafb) {
                this.zzafc = true;
                try {
                    JSONObject jSONObject = this.zzgg();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzakb.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzakb.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzaet.zzfy());
                zzakb.zzck((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzl(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzfo> iterator = this.zzafg.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzgk()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzafb) {
                return;
            }
            View view = this.zzaes.zzgh();
            boolean bl3 = view != null && zzbv.zzek().zza(view, this.zzaev, this.zzaew);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzaes.zzgi()) {
                this.zzgc();
                return;
            }
            if (n == 1 && !this.zzadz.tryAcquire() && bl == this.zzafd) {
                return;
            }
            if (!bl && !this.zzafd && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzafd = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzakb.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzet zzet2 = this;
            View view2 = zzet2.zzaes.zzgj().zzgh();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzet2.zzaer.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzet2.zzgf();
                    if (!zzet2.zzaez || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzet2.zzaez = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzet2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzet2);
                    }
                    zzet2.zzaer = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzgd();
            return;
        }
    }

    private final void zzgd() {
        if (this.zzaey != null) {
            this.zzaey.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzge() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzafb;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzc(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzaet.zzfy());
    }

    final void zzd(Map<String, String> map) {
        this.zzl(3);
    }

    final void zza(zzfo zzfo2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzaet.zzfy());
        zzakb.zzck((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzfo2);
    }

    final void zze(Map<String, String> map) {
        boolean bl;
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl2 = bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        zzet zzet2 = this;
        Iterator<zzeq> iterator = zzet2.zzaff.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzet2, bl2);
        }
    }

    private final void zzgf() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzaer.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzgg() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzaet.zzfw()).put("activeViewJSON", (Object)this.zzaet.zzfx()).put("timestamp", zzbv.zzer().elapsedRealtime()).put("adFormat", (Object)this.zzaet.zzfv()).put("hashCode", (Object)this.zzaet.zzfy()).put("isMraid", this.zzaet.zzfz()).put("isStopped", this.zzafa).put("isPaused", this.zzaaq).put("isNative", this.zzaet.zzga()).put("isScreenOn", this.isScreenOn()).put("appMuted", zzbv.zzfj().zzdp()).put("appVolume", (double)zzbv.zzfj().zzdo()).put("deviceVolume", (double)this.zzafj);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzet.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzet zzet2 = this;
            ArrayList<zzfo> arrayList = new ArrayList<zzfo>(zzet2.zzafg);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzfo zzfo2 = arrayList.get(i);
                zzfo2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzakb.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfo zzfo2) {
        if (this.zzafg.isEmpty()) {
            zzet zzet2 = this;
            Object object = zzet2.mLock;
            synchronized (object) {
                if (zzet2.zzafe != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzet2.zzafe = new zzeu(zzet2);
                    zzbv.zzfk().zza(zzet2.zzaeo, zzet2.zzafe, intentFilter);
                }
            }
            this.zzl(3);
        }
        this.zzafg.add(zzfo2);
        try {
            JSONObject jSONObject = zzet.zza(this.zza(this.zzaes.zzgh(), null));
            zzfo2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzakb.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzfo zzfo2) {
        this.zzafg.remove(zzfo2);
        zzfo2.zzgl();
        if (this.zzafg.isEmpty()) {
            zzet zzet2 = this;
            Object object = zzet2.mLock;
            synchronized (object) {
                zzet2.zzgf();
                zzet zzet3 = zzet2;
                Object object2 = zzet3.mLock;
                synchronized (object2) {
                    if (zzet3.zzafe != null) {
                        try {
                            zzbv.zzfk().zza(zzet3.zzaeo, zzet3.zzafe);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzakb.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbv.zzeo().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzet3.zzafe = null;
                    }
                }
                zzet2.zzaeo.getContentResolver().unregisterContentObserver((ContentObserver)zzet2.zzafi);
                zzet2.zzafb = false;
                zzet2.zzgd();
                zzet3 = zzet2;
                ArrayList<zzfo> arrayList = new ArrayList<zzfo>(zzet3.zzafg);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzfo zzfo3 = arrayList.get(i);
                    zzfo zzfo4 = zzfo3;
                    zzet3.zzb(zzfo4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzet zzet2 = this;
            return zzet2.zzgg().put("isAttachedToWindow", false).put("isScreenOn", zzet2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbv.zzem().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzgg();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzet.zza(this.zzafh.top, this.zzaex)).put("bottom", zzet.zza(this.zzafh.bottom, this.zzaex)).put("left", zzet.zza(this.zzafh.left, this.zzaex)).put("right", zzet.zza(this.zzafh.right, this.zzaex))).put("adBox", (Object)new JSONObject().put("top", zzet.zza(rect.top, this.zzaex)).put("bottom", zzet.zza(rect.bottom, this.zzaex)).put("left", zzet.zza(rect.left, this.zzaex)).put("right", zzet.zza(rect.right, this.zzaex))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzet.zza(rect2.top, this.zzaex)).put("bottom", zzet.zza(rect2.bottom, this.zzaex)).put("left", zzet.zza(rect2.left, this.zzaex)).put("right", zzet.zza(rect2.right, this.zzaex))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzet.zza(rect3.top, this.zzaex)).put("bottom", zzet.zza(rect3.bottom, this.zzaex)).put("left", zzet.zza(rect3.left, this.zzaex)).put("right", zzet.zza(rect3.right, this.zzaex))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzet.zza(rect4.top, this.zzaex)).put("bottom", zzet.zza(rect4.bottom, this.zzaex)).put("left", zzet.zza(rect4.left, this.zzaex)).put("right", zzet.zza(rect4.right, this.zzaex))).put("screenDensity", (double)this.zzaex.density);
        if (bl == null) {
            bl = zzbv.zzek().zza(view, this.zzaev, this.zzaew);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    @VisibleForTesting
    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzaev.isInteractive();
        }
        return this.zzaev.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzl(1);
    }

    public final void onGlobalLayout() {
        this.zzl(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfa zzfa2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaey = zzfa2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzafa = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaaq = true;
            this.zzl(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaaq = false;
            this.zzl(3);
            return;
        }
    }
}

