/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzcn;
import com.google.android.gms.internal.ads.zzcz;
import com.google.android.gms.internal.ads.zzdg;
import com.google.android.gms.internal.ads.zzdj;
import com.google.android.gms.internal.ads.zzdk;
import java.lang.ref.WeakReference;

public final class zzdi
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zzsy = new Handler(Looper.getMainLooper());
    private final Context zzsz;
    private Application zzrk;
    private final PowerManager zzta;
    private final KeyguardManager zztb;
    private final zzcz zzps;
    private BroadcastReceiver zztc;
    private WeakReference<ViewTreeObserver> zztd;
    private WeakReference<View> zzte;
    private zzcn zztf;
    private boolean zztg = false;
    private int zzth = -1;
    private long zzti = -3L;

    public zzdi(zzcz zzcz2, View view) {
        this.zzps = zzcz2;
        this.zzsz = zzcz2.zzrt;
        this.zzta = (PowerManager)this.zzsz.getSystemService("power");
        this.zztb = (KeyguardManager)this.zzsz.getSystemService("keyguard");
        if (this.zzsz instanceof Application) {
            this.zzrk = (Application)this.zzsz;
            this.zztf = new zzcn((Application)this.zzsz, this);
        }
        this.zzd(view);
    }

    final void zzd(View view) {
        View view2 = this.zzte != null ? (View)this.zzte.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzf(view2);
        }
        this.zzte = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zze(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzti = -2L;
            return;
        }
        this.zzti = -3L;
    }

    private final void zzao() {
        zzsy.post((Runnable)new zzdj(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzth = -1;
        this.zze(view);
        this.zzaq();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzth = -1;
        this.zzaq();
        this.zzao();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzte == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzte.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzth = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzaq();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzaq();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzaq();
        this.zzao();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzaq();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzaq();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzaq();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzaq();
    }

    public final void onGlobalLayout() {
        this.zzaq();
    }

    public final void onScrollChanged() {
        this.zzaq();
    }

    public final long zzap() {
        if (this.zzti == -2L && this.zzte.get() == null) {
            this.zzti = -3L;
        }
        return this.zzti;
    }

    private final void zzaq() {
        boolean bl;
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        if (this.zzte == null) {
            return;
        }
        View view2 = (View)this.zzte.get();
        if (view2 == null) {
            this.zzti = -3L;
            this.zztg = false;
            return;
        }
        boolean bl2 = view2.getGlobalVisibleRect(new Rect());
        boolean bl3 = view2.getLocalVisibleRect(new Rect());
        boolean bl4 = this.zzps.zzai() || this.zztb.inKeyguardRestrictedInputMode() && (activity = zzdg.zzc(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0;
        int n = view2.getWindowVisibility();
        int n2 = this.zzth != -1 ? this.zzth : n;
        boolean bl5 = bl = view2.getVisibility() == 0 && view2.isShown() && this.zzta.isScreenOn() && bl4 && bl3 && bl2 && n2 == 0;
        if (this.zztg != bl) {
            this.zzti = bl ? SystemClock.elapsedRealtime() : -2L;
            this.zztg = bl;
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zztd = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzdi zzdi2 = this;
        if (zzdi2.zztc == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzdi2.zztc = new zzdk(zzdi2);
            zzdi2.zzsz.registerReceiver(zzdi2.zztc, intentFilter);
        }
        if (this.zzrk != null) {
            try {
                this.zzrk.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zztf);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zztd != null) {
                viewTreeObserver = (ViewTreeObserver)this.zztd.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zztd = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzdi zzdi2 = this;
        if (zzdi2.zztc != null) {
            try {
                zzdi2.zzsz.unregisterReceiver(zzdi2.zztc);
            }
            catch (Exception exception) {}
            zzdi2.zztc = null;
        }
        if (this.zzrk != null) {
            try {
                this.zzrk.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zztf);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzdi zzdi2) {
        zzdi2.zzaq();
    }
}

