/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.ads.zzatq;
import com.google.android.gms.internal.ads.zzba;
import com.google.android.gms.internal.ads.zzbe;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbk;
import com.google.android.gms.internal.ads.zzcc;
import com.google.android.gms.internal.ads.zzck;
import com.google.android.gms.internal.ads.zzcl;
import com.google.android.gms.internal.ads.zzcw;
import com.google.android.gms.internal.ads.zzda;
import com.google.android.gms.internal.ads.zzdb;
import com.google.android.gms.internal.ads.zzdc;
import com.google.android.gms.internal.ads.zzdd;
import com.google.android.gms.internal.ads.zzdg;
import com.google.android.gms.internal.ads.zzeg;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzcz {
    private static final String TAG = zzcz.class.getSimpleName();
    protected Context zzrt;
    private ExecutorService zzru;
    private DexClassLoader zzrv;
    private zzck zzrw;
    private byte[] zzrx;
    private volatile AdvertisingIdClient zzry = null;
    private volatile boolean zzqt = false;
    private Future zzrz = null;
    private boolean zzsa;
    private volatile zzba zzsb = null;
    private Future zzsc = null;
    private zzcc zzsd;
    private boolean zzse = false;
    private boolean zzsf = false;
    private Map<Pair<String, String>, zzeg> zzsg;
    private boolean zzsh = false;
    private boolean zzsi = true;
    private boolean zzsj = false;

    public static zzcz zza(Context context, String string2, String string3, boolean bl) {
        zzcz zzcz2 = new zzcz(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzcz zzcz3 = zzcz2;
            zzcz2.zzru = Executors.newCachedThreadPool(new zzda());
            boolean bl3 = bl2;
            zzcz zzcz4 = zzcz3;
            zzcz3.zzqt = bl3;
            if (bl3) {
                zzcz4.zzrz = zzcz4.zzru.submit(new zzdb(zzcz4));
            }
            zzcz zzcz5 = zzcz3;
            zzcz5.zzru.execute(new zzdd(zzcz5));
            try {
                object = GoogleApiAvailabilityLight.getInstance();
                zzcz5.zzse = object.getApkVersion(zzcz5.zzrt) > 0;
                zzcz5.zzsf = object.isGooglePlayServicesAvailable(zzcz5.zzrt) == 0;
            }
            catch (Throwable throwable) {}
            zzcz3.zza(0, true);
            if (zzdg.isMainThread()) {
                zzcz4 = zznk.zzbaz;
                if (((Boolean)zzkb.zzik().zzd((zzna)zzcz4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzcz5 = zzcz3;
            zzcz3.zzrw = new zzck(null);
            try {
                zzcz5.zzrx = zzcz5.zzrw.zzl((String)object);
            }
            catch (zzcl zzcl2) {
                throw new zzcw(zzcl2);
            }
            object = string4;
            zzcz5 = zzcz3;
            try {
                String string6;
                File file = zzcz5.zzrt.getCacheDir();
                if (file == null && (file = zzcz5.zzrt.getDir("dex", 0)) == null) {
                    throw new zzcw();
                }
                String string7 = string6 = "1521499837408";
                File file2 = file;
                Object object2 = object;
                zzcz zzcz6 = zzcz5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzcz6.zzrw.zza(zzcz6.zzrx, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzcz5.zzb(file, string6);
                try {
                    zzcz5.zzrv = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzcz5.zzrt.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzcz.zzb(file4);
                    zzcz5.zza(file, string6);
                    zzcz.zzm(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzcz.zzb(file4);
                zzcz5.zza(file, string6);
                zzcz.zzm(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcw(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcw(iOException);
            }
            catch (zzcl zzcl3) {
                throw new zzcw(zzcl3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcw(nullPointerException);
            }
            zzcz4 = zzcz3;
            if (!zzcz4.zzsj) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzcz4.zzrt.registerReceiver((BroadcastReceiver)zzcz4.new zza(null), intentFilter);
                zzcz4.zzsj = true;
            }
            zzcz3.zzsd = new zzcc(zzcz3);
            zzcz3.zzsh = true;
        }
        catch (zzcw zzcw2) {}
        return zzcz2;
    }

    public final Context getContext() {
        return this.zzrt;
    }

    public final boolean isInitialized() {
        return this.zzsh;
    }

    public final ExecutorService zzab() {
        return this.zzru;
    }

    public final DexClassLoader zzac() {
        return this.zzrv;
    }

    public final zzck zzad() {
        return this.zzrw;
    }

    public final byte[] zzae() {
        return this.zzrx;
    }

    public final boolean zzaf() {
        return this.zzse;
    }

    public final zzcc zzag() {
        return this.zzsd;
    }

    public final boolean zzah() {
        return this.zzsf;
    }

    public final boolean zzai() {
        return this.zzsi;
    }

    public final zzba zzaj() {
        return this.zzsb;
    }

    public final Future zzak() {
        return this.zzsc;
    }

    private zzcz(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzsa = context2 != null;
        this.zzrt = this.zzsa ? context2 : context;
        this.zzsg = new HashMap<Pair<String, String>, zzeg>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzcz.zzb(file2);
            return;
        }
        zzbe zzbe2 = new zzbe();
        new zzbe().zzgs = Build.VERSION.SDK.getBytes();
        zzbe2.zzgr = string2.getBytes();
        byte[] byArray2 = this.zzrw.zzb(this.zzrx, byArray).getBytes();
        zzbe2.data = byArray2;
        zzbe2.zzgq = zzbk.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = zzbfi.zzb((zzbfi)zzbe2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzcz.zzb(file2);
        return;
        catch (zzcl | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzcz.zzb(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzcz.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbe zzbe2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzcz.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzcz.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbe2 = (zzbe)zzbfi.zza((zzbfi)new zzbe(), (byte[])byArray2);
                if (string2.equals(new String(zzbe2.zzgr)) && Arrays.equals(zzbe2.zzgq, zzbk.zzb(zzbe2.data)) && Arrays.equals(zzbe2.zzgs, Build.VERSION.SDK.getBytes())) break block30;
                zzcz.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzrw.zza(this.zzrx, new String(zzbe2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcl | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzsg.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzsg.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzeg(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzeg zzeg2 = this.zzsg.get(new Pair((Object)string2, (Object)string3));
        if (zzeg2 == null) {
            return null;
        }
        return zzeg2.zzaw();
    }

    private final void zzal() {
        try {
            if (this.zzry == null && this.zzsa) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzrt);
                advertisingIdClient.start();
                this.zzry = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzry = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzsf) {
            return;
        }
        Future<?> future = this.zzru.submit(new zzdc(this, n, bl));
        if (n == 0) {
            this.zzsc = future;
        }
    }

    @VisibleForTesting
    final zzba zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzam();
    }

    private static boolean zza(int n, zzba zzba2) {
        if (n < 4) {
            if (zzba2 == null) {
                return true;
            }
            zzna zzna2 = zznk.zzbbc;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && (zzba2.zzcx == null || zzba2.zzcx.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzna2 = zznk.zzbbd;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue() && (zzba2.zzfn == null || zzba2.zzfn.zzgl == null || zzba2.zzfn.zzgl == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzba zzam() {
        zzba zzba2 = null;
        try {
            PackageInfo packageInfo = this.zzrt.getPackageManager().getPackageInfo(this.zzrt.getPackageName(), 0);
            zzba2 = zzatq.zzl((Context)this.zzrt, (String)this.zzrt.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzba2;
    }

    public final AdvertisingIdClient zzan() {
        if (!this.zzqt) {
            return null;
        }
        if (this.zzry != null) {
            return this.zzry;
        }
        if (this.zzrz != null) {
            try {
                this.zzrz.get(2000L, TimeUnit.MILLISECONDS);
                this.zzrz = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzrz.cancel(true);
            }
        }
        return this.zzry;
    }

    public final int zzx() {
        int n = Integer.MIN_VALUE;
        if (this.zzsd != null) {
            n = zzcc.zzx();
        }
        return n;
    }

    static /* synthetic */ void zza(zzcz zzcz2) {
        zzcz2.zzal();
    }

    static /* synthetic */ zzba zza(zzcz zzcz2, zzba zzba2) {
        zzcz2.zzsb = zzba2;
        return zzcz2.zzsb;
    }

    static /* synthetic */ boolean zzb(int n, zzba zzba2) {
        return zzcz.zza(n, zzba2);
    }

    final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzcz.this.zzsi = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzcz.this.zzsi = false;
            }
        }

        /* synthetic */ zza(zzda zzda2) {
            this();
        }
    }
}

