/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzazi;
import com.google.android.gms.internal.ads.zzazl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzazn
implements zzazi {
    static final int[] zzdoo = zzazn.zza(ByteBuffer.wrap(new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107}));
    final zzazh zzdop;
    private final int zzdoq;

    abstract ByteBuffer zzb(byte[] var1, int var2);

    abstract int zzaao();

    zzazn(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzdop = zzazh.zzm(byArray);
        this.zzdoq = n;
    }

    @Override
    public final byte[] zzk(byte[] byArray) throws GeneralSecurityException {
        int n = byArray.length;
        this.zzaao();
        if (n > 0x7FFFFFF3) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.zzaao() + byArray.length);
        this.zza(byteBuffer, byArray);
        return byteBuffer.array();
    }

    final void zza(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byteBuffer.remaining() - this.zzaao() < byArray.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        byte[] byArray2 = zzazl.zzbh(this.zzaao());
        byteBuffer.put(byArray2);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        ByteBuffer byteBuffer3 = byteBuffer;
        byte[] byArray3 = byArray2;
        zzazn zzazn2 = this;
        int n = byteBuffer2.remaining();
        int n2 = n / 64 + 1;
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer4 = zzazn2.zzb(byArray3, i + zzazn2.zzdoq);
            if (i == n2 - 1) {
                zzayk.zza(byteBuffer3, byteBuffer2, byteBuffer4, n % 64);
                continue;
            }
            zzayk.zza(byteBuffer3, byteBuffer2, byteBuffer4, 64);
        }
    }

    static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    static int[] zza(ByteBuffer byteBuffer) {
        IntBuffer intBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }
}

