/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzauk;
import com.google.android.gms.internal.ads.zzayy;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzazj
implements zzauk {
    private Mac zzdoj;
    private final int zzdok;
    private final String zzdol;
    private final Key zzdom;

    public zzazj(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzdol = string2;
        this.zzdok = n;
        this.zzdom = key;
        this.zzdoj = zzayy.zzdoa.zzek(string2);
        this.zzdoj.init(key);
    }

    @Override
    public final byte[] zzg(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzdoj.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzayy.zzdoa.zzek(this.zzdol);
            mac.init(this.zzdom);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzdok];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzdok);
        return byArray2;
    }
}

