/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzayy;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;

public final class zzayt {
    static void zza(ECPoint eCPoint, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = zzayt.zza(ellipticCurve);
        BigInteger bigInteger3 = eCPoint.getAffineX();
        BigInteger bigInteger4 = eCPoint.getAffineY();
        if (bigInteger3 == null || bigInteger4 == null) {
            throw new GeneralSecurityException("point is at infinity");
        }
        if (bigInteger3.signum() == -1 || bigInteger3.compareTo(bigInteger2) != -1) {
            throw new GeneralSecurityException("x is out of range");
        }
        if (bigInteger4.signum() == -1 || bigInteger4.compareTo(bigInteger2) != -1) {
            throw new GeneralSecurityException("y is out of range");
        }
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger4).mod(bigInteger2);
        if (!bigInteger5.equals(bigInteger = bigInteger3.multiply(bigInteger3).add(ellipticCurve.getA()).multiply(bigInteger3).add(ellipticCurve.getB()).mod(bigInteger2))) {
            throw new GeneralSecurityException("Point is not on curve");
        }
    }

    private static BigInteger zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        ECField eCField = ellipticCurve.getField();
        if (eCField instanceof ECFieldFp) {
            return ((ECFieldFp)eCField).getP();
        }
        throw new GeneralSecurityException("Only curves over prime order fields are supported");
    }

    public static int zzb(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzayt.zza(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    private static ECParameterSpec zza(String string2, String string3, String string4, String string5, String string6) {
        BigInteger bigInteger = new BigInteger(string2);
        BigInteger bigInteger2 = new BigInteger(string3);
        BigInteger bigInteger3 = new BigInteger("3");
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger3);
        BigInteger bigInteger5 = new BigInteger(string4, 16);
        BigInteger bigInteger6 = new BigInteger(string5, 16);
        BigInteger bigInteger7 = new BigInteger(string6, 16);
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, bigInteger4, bigInteger5);
        ECPoint eCPoint = new ECPoint(bigInteger6, bigInteger7);
        return new ECParameterSpec(ellipticCurve, eCPoint, bigInteger2, 1);
    }

    public static ECParameterSpec zza(zzayv zzayv2) throws NoSuchAlgorithmException {
        switch (zzayv2) {
            case zzdno: {
                return zzayt.zza("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5");
            }
            case zzdnp: {
                return zzayt.zza("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", "aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", "3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f");
            }
            case zzdnq: {
                return zzayt.zza("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", "c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", "11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650");
            }
        }
        String string2 = String.valueOf((Object)zzayv2);
        throw new NoSuchAlgorithmException(new StringBuilder(22 + String.valueOf(string2).length()).append("curve not implemented:").append(string2).toString());
    }

    public static ECPublicKey zza(zzayv zzayv2, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzayt.zza(zzayv2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        zzayt.zza(eCPoint, eCParameterSpec.getCurve());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        return (ECPublicKey)zzayy.zzdof.zzek("EC").generatePublic(eCPublicKeySpec);
    }

    public static KeyPair zza(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = zzayy.zzdoe.zzek("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] zza(ECPrivateKey eCPrivateKey, ECPoint eCPoint) throws GeneralSecurityException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray;
        block13: {
            BigInteger bigInteger3;
            zzayt.zza(eCPoint, eCPrivateKey.getParams().getCurve());
            ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
            eCParameterSpec.getCurve();
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(eCPublicKeySpec);
            KeyAgreement keyAgreement = zzayy.zzdod.zzek("ECDH");
            keyAgreement.init(eCPrivateKey);
            keyAgreement.doPhase(publicKey, true);
            byArray = keyAgreement.generateSecret();
            ECPrivateKey eCPrivateKey2 = eCPrivateKey;
            byte[] byArray2 = byArray;
            EllipticCurve ellipticCurve = eCPrivateKey2.getParams().getCurve();
            BigInteger bigInteger4 = new BigInteger(1, byArray2);
            if (bigInteger4.signum() == -1 || bigInteger4.compareTo(zzayt.zza(ellipticCurve)) != -1) {
                throw new GeneralSecurityException("shared secret is out of range");
            }
            EllipticCurve ellipticCurve2 = ellipticCurve;
            BigInteger bigInteger5 = bigInteger4;
            bigInteger2 = zzayt.zza(ellipticCurve2);
            BigInteger bigInteger6 = ellipticCurve2.getA();
            BigInteger bigInteger7 = ellipticCurve2.getB();
            BigInteger bigInteger8 = bigInteger2;
            BigInteger bigInteger9 = bigInteger5.multiply(bigInteger5).add(bigInteger6).multiply(bigInteger5).add(bigInteger7).mod(bigInteger2);
            if (bigInteger8.signum() != 1) {
                throw new InvalidAlgorithmParameterException("p must be positive");
            }
            bigInteger9 = bigInteger9.mod(bigInteger8);
            BigInteger bigInteger10 = null;
            if (bigInteger9.equals(BigInteger.ZERO)) {
                bigInteger3 = BigInteger.ZERO;
            } else {
                BigInteger bigInteger11;
                if (bigInteger8.testBit(0) && bigInteger8.testBit(1)) {
                    bigInteger11 = bigInteger8.add(BigInteger.ONE).shiftRight(2);
                    bigInteger10 = bigInteger9.modPow(bigInteger11, bigInteger8);
                } else if (bigInteger8.testBit(0) && !bigInteger8.testBit(1)) {
                    BigInteger bigInteger12;
                    BigInteger bigInteger13;
                    block14: {
                        bigInteger11 = BigInteger.ONE;
                        BigInteger bigInteger14 = bigInteger8.subtract(BigInteger.ONE).shiftRight(1);
                        int n = 0;
                        do {
                            if ((bigInteger13 = bigInteger11.multiply(bigInteger11).subtract(bigInteger9).mod(bigInteger8)).equals(BigInteger.ZERO)) {
                                bigInteger3 = bigInteger11;
                                break block13;
                            }
                            bigInteger12 = bigInteger13.modPow(bigInteger14, bigInteger8);
                            if (bigInteger12.add(BigInteger.ONE).equals(bigInteger8)) break block14;
                            if (!bigInteger12.equals(BigInteger.ONE)) {
                                throw new InvalidAlgorithmParameterException("p is not prime");
                            }
                            bigInteger11 = bigInteger11.add(BigInteger.ONE);
                        } while (++n != 128 || bigInteger8.isProbablePrime(80));
                        throw new InvalidAlgorithmParameterException("p is not prime");
                    }
                    bigInteger12 = bigInteger8.add(BigInteger.ONE).shiftRight(1);
                    BigInteger bigInteger15 = bigInteger11;
                    BigInteger bigInteger16 = BigInteger.ONE;
                    for (int i = bigInteger12.bitLength() - 2; i >= 0; --i) {
                        BigInteger bigInteger17 = bigInteger15.multiply(bigInteger16);
                        bigInteger15 = bigInteger15.multiply(bigInteger15).add(bigInteger16.multiply(bigInteger16).mod(bigInteger8).multiply(bigInteger13)).mod(bigInteger8);
                        bigInteger16 = bigInteger17.add(bigInteger17).mod(bigInteger8);
                        if (!bigInteger12.testBit(i)) continue;
                        bigInteger17 = bigInteger15.multiply(bigInteger11).add(bigInteger16.multiply(bigInteger13)).mod(bigInteger8);
                        bigInteger16 = bigInteger11.multiply(bigInteger16).add(bigInteger15).mod(bigInteger8);
                        bigInteger15 = bigInteger17;
                    }
                    bigInteger10 = bigInteger15;
                }
                if (bigInteger10 != null && bigInteger10.multiply(bigInteger10).mod(bigInteger8).compareTo(bigInteger9) != 0) {
                    throw new GeneralSecurityException("Could not find a modular square root");
                }
                bigInteger3 = bigInteger = bigInteger10;
            }
        }
        if (!bigInteger.testBit(0)) {
            bigInteger2.subtract(bigInteger).mod(bigInteger2);
        }
        return byArray;
    }
}

