/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzaug;
import com.google.android.gms.internal.ads.zzauk;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxc;
import com.google.android.gms.internal.ads.zzaxe;
import com.google.android.gms.internal.ads.zzaxg;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzazj;
import com.google.android.gms.internal.ads.zzazl;
import com.google.android.gms.internal.ads.zzazq;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbcu;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzavk
implements zzaug<zzauk> {
    zzavk() {
    }

    private final zzauk zzh(zzbah zzbah2) throws GeneralSecurityException {
        try {
            zzazj zzazj2;
            zzaxc zzaxc2;
            zzaxc zzaxc3;
            zzaxc zzaxc4 = zzaxc3 = zzaxc.zzae(zzbah2);
            zzaxc zzaxc5 = zzaxc3;
            if (!(zzaxc3 instanceof zzaxc)) {
                throw new GeneralSecurityException("expected HmacKey proto");
            }
            zzaxc zzaxc6 = zzaxc2 = zzaxc5;
            zzazq.zzj(zzaxc2.getVersion(), 0);
            if (zzaxc6.zzwv().size() < 16) {
                throw new GeneralSecurityException("key too short");
            }
            zzavk.zza(zzaxc6.zzym());
            zzaxa zzaxa2 = zzaxc2.zzym().zzys();
            byte[] byArray = zzaxc2.zzwv().toByteArray();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
            int n = zzaxc2.zzym().zzyt();
            switch (zzaxa2) {
                case zzdkg: {
                    zzazj2 = new zzazj("HMACSHA1", secretKeySpec, n);
                    break;
                }
                case zzdki: {
                    zzazj2 = new zzazj("HMACSHA256", secretKeySpec, n);
                    break;
                }
                case zzdkj: {
                    zzazj2 = new zzazj("HMACSHA512", secretKeySpec, n);
                    break;
                }
                default: {
                    throw new GeneralSecurityException("unknown hash");
                }
            }
            return zzazj2;
        }
        catch (zzbbu zzbbu2) {
            throw new GeneralSecurityException("expected serialized HmacKey proto", zzbbu2);
        }
    }

    @Override
    public final zzbcu zzb(zzbah zzbah2) throws GeneralSecurityException {
        try {
            zzaxe zzaxe2 = zzaxe.zzag(zzbah2);
            return this.zzb((zzbcu)zzaxe2);
        }
        catch (zzbbu zzbbu2) {
            throw new GeneralSecurityException("expected serialized HmacKeyFormat proto", zzbbu2);
        }
    }

    @Override
    public final zzbcu zzb(zzbcu zzbcu2) throws GeneralSecurityException {
        zzaxe zzaxe2;
        if (!(zzbcu2 instanceof zzaxe)) {
            throw new GeneralSecurityException("expected HmacKeyFormat proto");
        }
        zzaxe zzaxe3 = zzaxe2 = (zzaxe)zzbcu2;
        if (zzaxe2.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzavk.zza(zzaxe3.zzym());
        return zzaxc.zzyn().zzav(0).zzc(zzaxe2.zzym()).zzaf(zzbah.zzo((byte[])zzazl.zzbh(zzaxe2.getKeySize()))).zzadi();
    }

    @Override
    public final zzaxi zzc(zzbah zzbah2) throws GeneralSecurityException {
        zzaxc zzaxc2 = (zzaxc)this.zzb(zzbah2);
        return (zzaxi)zzaxi.zzyz().zzeb("type.googleapis.com/google.crypto.tink.HmacKey").zzai(zzaxc2.zzaav()).zzb(zzaxi.zzb.zzdkx).zzadi();
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    private static void zza(zzaxg zzaxg2) throws GeneralSecurityException {
        if (zzaxg2.zzyt() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzaxg2.zzys()) {
            case zzdkg: {
                if (zzaxg2.zzyt() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzdki: {
                if (zzaxg2.zzyt() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzdkj: {
                if (zzaxg2.zzyt() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ Object zza(zzbcu zzbcu2) throws GeneralSecurityException {
        zzaxc zzaxc2;
        zzbcu zzbcu3 = zzbcu2;
        if (!(zzbcu3 instanceof zzaxc)) {
            throw new GeneralSecurityException("expected HmacKey proto");
        }
        zzaxc zzaxc3 = zzaxc2 = (zzaxc)zzbcu3;
        zzazq.zzj(zzaxc2.getVersion(), 0);
        if (zzaxc3.zzwv().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzavk.zza(zzaxc3.zzym());
        zzaxa zzaxa2 = zzaxc2.zzym().zzys();
        byte[] byArray = zzaxc2.zzwv().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zzaxc2.zzym().zzyt();
        switch (zzaxa2) {
            case zzdkg: {
                return new zzazj("HMACSHA1", secretKeySpec, n);
            }
            case zzdki: {
                return new zzazj("HMACSHA256", secretKeySpec, n);
            }
            case zzdkj: {
                return new zzazj("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    @Override
    public final /* synthetic */ Object zza(zzbah zzbah2) throws GeneralSecurityException {
        return this.zzh(zzbah2);
    }
}

