/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzaua;
import com.google.android.gms.internal.ads.zzaug;
import com.google.android.gms.internal.ads.zzauh;
import com.google.android.gms.internal.ads.zzaum;
import com.google.android.gms.internal.ads.zzaun;
import com.google.android.gms.internal.ads.zzaup;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzaxl;
import com.google.android.gms.internal.ads.zzaxn;
import com.google.android.gms.internal.ads.zzaxr;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbcu;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzauo {
    private static final Logger logger = Logger.getLogger(zzauo.class.getName());
    private static final ConcurrentMap<String, zzaug> zzdhq = new ConcurrentHashMap<String, zzaug>();
    private static final ConcurrentMap<String, Boolean> zzdhr = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzaua> zzdhs = new ConcurrentHashMap<String, zzaua>();

    public static synchronized <P> void zza(String string2, zzaua<P> zzaua2) throws GeneralSecurityException {
        if (zzdhs.containsKey(string2.toLowerCase())) {
            zzaua zzaua3 = (zzaua)zzdhs.get(string2.toLowerCase());
            if (!zzaua2.getClass().equals(zzaua3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzdhs.put(string2.toLowerCase(), zzaua2);
    }

    public static <P> zzaua<P> zzdy(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzaua zzaua2 = (zzaua)zzdhs.get(string2.toLowerCase());
        if (zzaua2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.init().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.init().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.init().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.init().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzaua2;
    }

    public static <P> void zza(String string2, zzaug<P> zzaug2) throws GeneralSecurityException {
        zzauo.zza(string2, zzaug2, true);
    }

    public static synchronized <P> void zza(String string2, zzaug<P> zzaug2, boolean bl) throws GeneralSecurityException {
        if (zzaug2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (zzdhq.containsKey(string2)) {
            zzaug<P> zzaug3 = zzauo.zzdz(string2);
            boolean bl2 = (Boolean)zzdhr.get(string2);
            if (!zzaug2.getClass().equals(zzaug3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzaug3.getClass().getName(), zzaug2.getClass().getName()));
            }
        }
        zzdhq.put(string2, zzaug2);
        zzdhr.put(string2, bl);
    }

    private static <P> zzaug<P> zzdz(String string2) throws GeneralSecurityException {
        zzaug zzaug2 = (zzaug)zzdhq.get(string2);
        if (zzaug2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        return zzaug2;
    }

    public static <P> zzaxi zza(zzaxn zzaxn2) throws GeneralSecurityException {
        zzaug<P> zzaug2 = zzauo.zzdz(zzaxn2.zzyw());
        if (((Boolean)zzdhr.get(zzaxn2.zzyw())).booleanValue()) {
            return zzaug2.zzc(zzaxn2.zzyx());
        }
        String string2 = String.valueOf(zzaxn2.zzyw());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzbcu zzb(zzaxn zzaxn2) throws GeneralSecurityException {
        zzaug<P> zzaug2 = zzauo.zzdz(zzaxn2.zzyw());
        if (((Boolean)zzdhr.get(zzaxn2.zzyw())).booleanValue()) {
            return zzaug2.zzb(zzaxn2.zzyx());
        }
        String string2 = String.valueOf(zzaxn2.zzyw());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> zzbcu zza(String string2, zzbcu zzbcu2) throws GeneralSecurityException {
        zzaug<P> zzaug2 = zzauo.zzdz(string2);
        if (((Boolean)zzdhr.get(string2)).booleanValue()) {
            return zzaug2.zzb(zzbcu2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zzb(String string2, zzbcu zzbcu2) throws GeneralSecurityException {
        return zzauo.zzdz(string2).zza(zzbcu2);
    }

    private static <P> P zza(String string2, zzbah zzbah2) throws GeneralSecurityException {
        return zzauo.zzdz(string2).zza(zzbah2);
    }

    public static <P> P zza(String string2, byte[] byArray) throws GeneralSecurityException {
        return zzauo.zza(string2, zzbah.zzo((byte[])byArray));
    }

    public static <P> zzaum<P> zza(zzauh zzauh2, zzaug<P> zzaug2) throws GeneralSecurityException {
        zzaup.zzc(zzauh2.zzwg());
        zzaum zzaum2 = new zzaum();
        for (zzaxr.zzb zzb2 : zzauh2.zzwg().zzzl()) {
            if (zzb2.zzzq() != zzaxl.zzdle) continue;
            P p = zzauo.zza(zzb2.zzzp().zzyw(), zzb2.zzzp().zzyx());
            zzaun zzaun2 = zzaum2.zza(p, zzb2);
            if (zzb2.zzzr() != zzauh2.zzwg().zzzk()) continue;
            zzaum2.zza(zzaun2);
        }
        return zzaum2;
    }
}

