/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Build;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzash;
import com.google.android.gms.internal.ads.zzast;
import com.google.android.gms.internal.ads.zzasu;
import com.google.android.gms.internal.ads.zzasx;
import com.google.android.gms.internal.ads.zzasy;
import com.google.android.gms.internal.ads.zzasz;
import com.google.android.gms.internal.ads.zzata;
import com.google.android.gms.internal.ads.zzatb;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public class zzass
extends WebView
implements zzasx,
zzasz,
zzata,
zzatb {
    private final List<zzasx> zzdew = new CopyOnWriteArrayList<zzasx>();
    private final List<zzatb> zzdex = new CopyOnWriteArrayList<zzatb>();
    private final List<zzasz> zzdey = new CopyOnWriteArrayList<zzasz>();
    private final List<zzata> zzdez = new CopyOnWriteArrayList<zzata>();
    private final zzash zzdfa;
    protected final WebViewClient zzdfb;

    public zzass(zzash zzash2) {
        super((Context)zzash2);
        this.zzdfa = zzash2;
        this.setBackgroundColor(0);
        zzass zzass2 = this;
        WebSettings webSettings = zzass2.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzbv.zzem().zza(zzass2.getContext(), webSettings);
        zzass2 = this;
        zzass2.removeJavascriptInterface("accessibility");
        zzass2.removeJavascriptInterface("accessibilityTraversal");
        try {
            zzass2.getSettings().setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzakb.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        this.setLayerType(1, null);
        this.zzdfb = new zzast(this, this, this, this);
        super.setWebViewClient(this.zzdfb);
    }

    protected final zzash zzvv() {
        return this.zzdfa;
    }

    public void zzbe(String string2) {
        zzasy.zza(this, string2);
    }

    public void loadUrl(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
            zzbv.zzeo().zza(throwable, "CoreWebView.loadUrl");
            zzakb.zzd((String)"#007 Could not call remote method.", (Throwable)throwable);
            return;
        }
    }

    @Override
    public void zzc(zzasu zzasu2) {
        Iterator<zzata> iterator = this.zzdez.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzc(zzasu2);
        }
    }

    @Override
    public final void zzb(zzasu zzasu2) {
        Iterator<zzasz> iterator = this.zzdey.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(zzasu2);
        }
    }

    @Override
    public final boolean zza(zzasu zzasu2) {
        Iterator<zzasx> iterator = this.zzdew.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zza(zzasu2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final WebResourceResponse zzd(zzasu zzasu2) {
        Iterator<zzatb> iterator = this.zzdex.iterator();
        while (iterator.hasNext()) {
            WebResourceResponse webResourceResponse = iterator.next().zzd(zzasu2);
            if (webResourceResponse == null) continue;
            return webResourceResponse;
        }
        return null;
    }

    public void addJavascriptInterface(Object object, String string2) {
        if (Build.VERSION.SDK_INT >= 17) {
            super.addJavascriptInterface(object, string2);
            return;
        }
        zzakb.v("Ignore addJavascriptInterface due to low Android version.");
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    public final void zza(zzasx zzasx2) {
        this.zzdew.add(zzasx2);
    }

    public final void zza(zzatb zzatb2) {
        this.zzdex.add(zzatb2);
    }

    public final void zza(zzasz zzasz2) {
        this.zzdey.add(zzasz2);
    }

    public final void zza(zzata zzata2) {
        this.zzdez.add(zzata2);
    }
}

