/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbo;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzalb;
import com.google.android.gms.internal.ads.zzamt;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzaor;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzaqg;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzarl;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzarx;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzash;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzasj;
import com.google.android.gms.internal.ads.zzasr;
import com.google.android.gms.internal.ads.zzass;
import com.google.android.gms.internal.ads.zzasv;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzfs;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznq;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zznx;
import com.google.android.gms.internal.ads.zzox;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzus;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzasq
extends zzasv
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzaqw,
zzuo {
    @Nullable
    private final zzci zzbjc;
    private final zzang zzyf;
    private final zzbo zzddb;
    private final zzw zzwc;
    private zzasj zzdet;
    @GuardedBy(value="this")
    private zzd zzddg;
    @GuardedBy(value="this")
    private zzasi zzddh;
    @GuardedBy(value="this")
    private String zzus;
    @GuardedBy(value="this")
    private boolean zzddi;
    @GuardedBy(value="this")
    private boolean zzddk;
    @GuardedBy(value="this")
    private boolean zzddl;
    @GuardedBy(value="this")
    private int zzddm;
    @GuardedBy(value="this")
    private boolean zzddn = true;
    @GuardedBy(value="this")
    private boolean zzddo = false;
    @GuardedBy(value="this")
    private String zzchp = "";
    @GuardedBy(value="this")
    private zzarl zzddp;
    @GuardedBy(value="this")
    private boolean zzddq;
    @GuardedBy(value="this")
    private boolean zzddr;
    @GuardedBy(value="this")
    private zzox zzdds;
    @GuardedBy(value="this")
    private int zzddt;
    @GuardedBy(value="this")
    private int zzddu;
    private zznv zzddv;
    private zznv zzdad;
    private zznv zzddw;
    private zznw zzddx;
    private WeakReference<View.OnClickListener> zzddy;
    @GuardedBy(value="this")
    private zzd zzddz;
    private zzamt zzaee;
    private int zzbwz = -1;
    private int zzbwy = -1;
    private int zzbxb = -1;
    private int zzbxc = -1;
    private float zzdeu;
    private Map<String, zzaqh> zzdeb;
    private final WindowManager zzaeu;

    static zzasq zzc(Context context, zzasi zzasi2, String string2, boolean bl, boolean bl2, @Nullable zzci zzci2, zzang zzang2, zznx zznx2, zzbo zzbo2, zzw zzw2, zzhs zzhs2) {
        zzash zzash2 = new zzash(context);
        return new zzasq(zzash2, zzasi2, string2, bl, bl2, zzci2, zzang2, zznx2, zzbo2, zzw2, zzhs2);
    }

    @VisibleForTesting
    private zzasq(zzash zzash2, zzasi zzasi2, String string2, boolean bl, boolean bl2, @Nullable zzci zzci2, zzang zzang2, zznx zznx2, zzbo zzbo2, zzw zzw2, zzhs zzhs2) {
        super(zzash2);
        this.zzddh = zzasi2;
        this.zzus = string2;
        this.zzddk = bl;
        this.zzddm = -1;
        this.zzbjc = zzci2;
        this.zzyf = zzang2;
        this.zzddb = zzbo2;
        this.zzwc = zzw2;
        this.zzaeu = (WindowManager)this.getContext().getSystemService("window");
        this.zzaee = new zzamt(this.zzvv().zzto(), (View)this, this, null);
        zzbv.zzek().zza((Context)zzash2, zzang2.zzcw, this.getSettings());
        this.setDownloadListener(this);
        this.zzdeu = this.zzvv().getResources().getDisplayMetrics().density;
        this.zzvk();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            this.addJavascriptInterface(zzaro.zzk(this), "googleAdsJsInterface");
        }
        zznx zznx3 = zznx2;
        zzasq zzasq2 = this;
        zzasq2.zzvo();
        zzasq2.zzddx = new zznw(new zznx(true, "make_wv", zzasq2.zzus));
        zzasq2.zzddx.zzji().zzc(zznx3);
        zzasq2.zzdad = zznq.zzb(zzasq2.zzddx.zzji());
        zzasq2.zzddx.zza("native:view_create", zzasq2.zzdad);
        zzasq2.zzddw = null;
        zzasq2.zzddv = null;
        zzbv.zzem().zzaw((Context)zzash2);
    }

    public final void zza(zzasj zzasj2) {
        this.zzdet = zzasj2;
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzw zzbi() {
        return this.zzwc;
    }

    private final boolean zzvh() {
        int n;
        int n2;
        if (!this.zzdet.zzfz() && !this.zzdet.zzuu()) {
            return false;
        }
        zzbv.zzek();
        DisplayMetrics displayMetrics = zzakk.zza(this.zzaeu);
        zzkb.zzif();
        int n3 = zzamu.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzkb.zzif();
        int n4 = zzamu.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzvv().zzto();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbv.zzek();
            int[] nArray = zzakk.zzf(activity);
            zzkb.zzif();
            n2 = zzamu.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzkb.zzif();
            n = zzamu.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzbwy == n3 && this.zzbwz == n4 && this.zzbxb == n2 && this.zzbxc == n) {
            return false;
        }
        boolean bl = this.zzbwy != n3 || this.zzbwz != n4;
        this.zzbwy = n3;
        this.zzbwz = n4;
        this.zzbxb = n2;
        this.zzbxc = n;
        new zzaal(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzaeu.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzc(String string2, String string3, @Nullable String string4) {
        zzna zzna2 = zznk.zzaya;
        String string5 = (Boolean)zzkb.zzik().zzd(zzna2) != false ? zzarx.zzb(string3, zzarx.zzvp()) : string3;
        super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzbe(String string2) {
        if (!this.isDestroyed()) {
            super.zzbe(string2);
            return;
        }
        zzakb.zzdk((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzty() {
        this.zzvj();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzyf.zzcw);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzup.zza((zzuo)this, "onhide", hashMap2);
    }

    @Override
    public final void zzai(int n) {
        if (n == 0) {
            zzasq zzasq2 = this;
            zznq.zza(zzasq2.zzddx.zzji(), zzasq2.zzdad, "aebb2");
        }
        this.zzvj();
        if (this.zzddx.zzji() != null) {
            this.zzddx.zzji().zze("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzyf.zzcw);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzup.zza((zzuo)this, "onhide", hashMap2);
    }

    private final void zzvj() {
        zznq.zza(this.zzddx.zzji(), this.zzdad, "aeh2");
    }

    @Override
    public final void zzno() {
        if (this.zzddv == null) {
            zznq.zza(this.zzddx.zzji(), this.zzdad, "aes2");
            this.zzddv = zznq.zzb(this.zzddx.zzji());
            this.zzddx.zza("native:view_show", this.zzddv);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzyf.zzcw);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzup.zza((zzuo)this, "onshow", hashMap2);
    }

    @Override
    public final void zztz() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzbv.zzfj().zzdp()));
        hashMap.put("app_volume", String.valueOf(zzbv.zzfj().zzdo()));
        hashMap.put("device_volume", String.valueOf(zzalb.zzay(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzup.zza((zzuo)this, "volume", hashMap2);
    }

    @Override
    public final synchronized zzd zzub() {
        return this.zzddg;
    }

    @Override
    public final synchronized zzd zzuc() {
        return this.zzddz;
    }

    @Override
    public final synchronized zzasi zzud() {
        return this.zzddh;
    }

    @Override
    public final synchronized String zzue() {
        return this.zzus;
    }

    @Override
    public final WebViewClient zzug() {
        return this.zzdfb;
    }

    @Override
    public final synchronized boolean zzuh() {
        return this.zzddi;
    }

    @Override
    public final zzci zzui() {
        return this.zzbjc;
    }

    @Override
    public final zzang zztq() {
        return this.zzyf;
    }

    @Override
    public final synchronized boolean zzuj() {
        return this.zzddk;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbv.zzek();
            zzakk.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzakb.zzck((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdet.zzuu()) {
            zzasq zzasq2 = this;
            synchronized (zzasq2) {
                if (this.zzdds != null) {
                    this.zzdds.zzc(motionEvent);
                }
            }
        } else if (this.zzbjc != null) {
            this.zzbjc.zza(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzna zzna2 = zznk.zzaxx;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzddk || this.zzddh.zzvt()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzddh.zzvu()) {
            float f = 0.0f;
            zzarl zzarl2 = this.zztm();
            if (zzarl2 != null) {
                f = zzarl2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzddh.isFluid()) {
            int n11;
            Object object = zznk.zzbch;
            if (((Boolean)zzkb.zzik().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzasr((zzasq)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzass)this).zzbe(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzddu) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzddu * this.zzdeu);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzddh.zzvs()) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.zzaeu.getDefaultDisplay().getMetrics(displayMetrics);
            this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzddh.widthPixels > n17 || this.zzddh.heightPixels > n18 ? 1 : 0;
        zzna zzna2 = zznk.zzbfe;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            int n20 = n4 = !((float)this.zzddh.widthPixels / this.zzdeu > (float)n17 / this.zzdeu) && !((float)this.zzddh.heightPixels / this.zzdeu > (float)n18 / this.zzdeu) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzddh.widthPixels / this.zzdeu);
            int n21 = (int)((float)this.zzddh.heightPixels / this.zzdeu);
            int n22 = (int)((float)n14 / this.zzdeu);
            int n23 = (int)((float)n16 / this.zzdeu);
            zzakb.zzdk((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzddh.widthPixels, this.zzddh.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzvh();
        zzd zzd2 = this.zzub();
        if (zzd2 != null && bl) {
            zzd2.zznn();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzddg = zzd2;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzddz = zzd2;
    }

    @Override
    public final synchronized void zza(zzasi zzasi2) {
        this.zzddh = zzasi2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzai(boolean bl) {
        boolean bl2 = bl != this.zzddk;
        this.zzddk = bl;
        this.zzvk();
        if (bl2) {
            new zzaal(this).zzby(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzuo() {
        this.zzaee.zzsc();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzaee.onAttachedToWindow();
        }
        boolean bl = this.zzddq;
        if (this.zzdet != null && this.zzdet.zzuu()) {
            bl = true;
            if (!this.zzddr) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdet.zzuv();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzfg();
                    zzasq zzasq2 = this;
                    if (zzasq2 == null) {
                        throw null;
                    }
                    zzaor.zza((View)zzasq2, onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdet.zzuw()) != null) {
                    zzbv.zzfg();
                    zzasq zzasq3 = this;
                    if (zzasq3 == null) {
                        throw null;
                    }
                    zzaor.zza((View)zzasq3, onScrollChangedListener);
                }
                this.zzddr = true;
            }
            this.zzvh();
        }
        this.zzal(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzasq zzasq2 = this;
        synchronized (zzasq2) {
            if (!this.isDestroyed()) {
                this.zzaee.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzddr && this.zzdet != null && this.zzdet.zzuu() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdet.zzuv();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzem().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdet.zzuw()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzddr = false;
            }
        }
        this.zzal(false);
    }

    @Override
    public final void zzbm(Context context) {
        this.zzvv().setBaseContext(context);
        this.zzaee.zzi(this.zzvv().zzto());
    }

    @Override
    public final synchronized void zzu(boolean bl) {
        if (this.zzddg != null) {
            this.zzddg.zza(this.zzdet.zzfz(), bl);
            return;
        }
        this.zzddi = bl;
    }

    @Override
    public final synchronized int getRequestedOrientation() {
        return this.zzddm;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzddm = n;
        if (this.zzddg != null) {
            this.zzddg.setRequestedOrientation(this.zzddm);
        }
    }

    @Override
    public final Activity zzto() {
        return this.zzvv().zzto();
    }

    @Override
    public final Context zzua() {
        return this.zzvv().zzua();
    }

    private final synchronized void zzvk() {
        if (this.zzddk || this.zzddh.zzvs()) {
            zzakb.zzck((String)"Enabling hardware acceleration on an overlay.");
            this.zzvm();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzakb.zzck((String)"Disabling hardware acceleration on an AdView.");
            this.zzvl();
            return;
        }
        zzakb.zzck((String)"Enabling hardware acceleration on an AdView.");
        this.zzvm();
    }

    private final synchronized void zzvl() {
        if (!this.zzddl) {
            zzbv.zzem().zzz((View)this);
        }
        this.zzddl = true;
    }

    private final synchronized void zzvm() {
        if (this.zzddl) {
            zzbv.zzem().zzy((View)this);
        }
        this.zzddl = false;
    }

    @Override
    protected final synchronized void zzam(boolean bl) {
        if (!bl) {
            this.zzvo();
            this.zzaee.zzsd();
            if (this.zzddg != null) {
                this.zzddg.close();
                this.zzddg.onDestroy();
                this.zzddg = null;
            }
        }
        ((zzus)this.zzdet).reset();
        zzbv.zzff();
        zzaqg.zzb(this);
        this.zzvn();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdet != null && this.zzdet.zzve() != null) {
            this.zzdet.zzve().zzda();
        }
    }

    @Override
    public final void zzup() {
        if (this.zzddw == null) {
            this.zzddw = zznq.zzb(this.zzddx.zzji());
            this.zzddx.zza("native:view_load", this.zzddw);
        }
    }

    @Override
    public final void onPause() {
        try {
            if (PlatformVersion.isAtLeastHoneycomb()) {
                super.onPause();
            }
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            if (PlatformVersion.isAtLeastHoneycomb()) {
                super.onResume();
            }
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzus() {
        zzakb.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzaj(boolean bl) {
        this.zzddn = bl;
    }

    @Override
    public final synchronized boolean zzul() {
        return this.zzddn;
    }

    @Override
    public final synchronized boolean zzum() {
        return this.zzddo;
    }

    @Override
    public final synchronized void zzcl() {
        this.zzddo = true;
        if (this.zzddb != null) {
            this.zzddb.zzcl();
        }
    }

    @Override
    public final synchronized void zzcm() {
        this.zzddo = false;
        if (this.zzddb != null) {
            this.zzddb.zzcm();
        }
    }

    private final synchronized void zzvn() {
        this.zzdeb = null;
    }

    @Override
    public final synchronized void zzdr(String string2) {
        this.zzchp = string2 == null ? "" : string2;
    }

    @Override
    public final synchronized String zzol() {
        return this.zzchp;
    }

    @Override
    public final zzapn zztl() {
        return null;
    }

    @Override
    public final zznv zztn() {
        return this.zzdad;
    }

    @Override
    public final zznw zztp() {
        return this.zzddx;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzddy = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzddy.get();
    }

    @Override
    public final synchronized void zzb(zzox zzox2) {
        this.zzdds = zzox2;
    }

    @Override
    public final synchronized zzox zzuq() {
        return this.zzdds;
    }

    @Override
    public final synchronized zzarl zztm() {
        return this.zzddp;
    }

    @Override
    public final synchronized void zza(zzarl zzarl2) {
        if (this.zzddp != null) {
            zzakb.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzddp = zzarl2;
    }

    @Override
    public final synchronized boolean zzun() {
        return this.zzddt > 0;
    }

    @Override
    public final synchronized void zzak(boolean bl) {
        this.zzddt += bl ? 1 : -1;
        if (this.zzddt <= 0 && this.zzddg != null) {
            this.zzddg.zznq();
        }
    }

    private final void zzvo() {
        if (this.zzddx == null) {
            return;
        }
        zznx zznx2 = this.zzddx.zzji();
        if (zznx2 != null && zzbv.zzeo().zzpy() != null) {
            zzbv.zzeo().zzpy().zza(zznx2);
        }
    }

    @Override
    public final void zzur() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzah(boolean bl) {
        this.zzdet.zzah(bl);
    }

    @Override
    public final void zznp() {
        zzd zzd2 = this.zzub();
        if (zzd2 != null) {
            zzd2.zznp();
        }
    }

    @Override
    public final int zztr() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzts() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzdet.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzdet.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzdet.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzdet.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzfs zzfs2) {
        zzasq zzasq2 = this;
        synchronized (zzasq2) {
            this.zzddq = zzfs2.zztg;
        }
        this.zzal(zzfs2.zztg);
    }

    private final void zzal(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzup.zza((zzuo)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzv<? super zzaqw> zzv2) {
        if (this.zzdet != null) {
            this.zzdet.zza(string2, zzv2);
        }
    }

    @Override
    public final void zzb(String string2, zzv<? super zzaqw> zzv2) {
        if (this.zzdet != null) {
            this.zzdet.zzb(string2, zzv2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzv<? super zzaqw>> predicate) {
        if (this.zzdet != null) {
            this.zzdet.zza(string2, predicate);
        }
    }

    @Override
    public final /* synthetic */ zzasc zzuf() {
        return this.zzdet;
    }

    static /* synthetic */ int zza(zzasq zzasq2) {
        return zzasq2.zzddu;
    }

    static /* synthetic */ int zza(zzasq zzasq2, int n) {
        zzasq2.zzddu = n;
        return zzasq2.zzddu;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzup.zza((zzuo)this, string2, jSONObject);
    }

    @Override
    public final void zzf(String string2, String string3) {
        zzup.zza((zzuo)this, string2, string3);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzup.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzup.zza((zzuo)this, string2, map);
    }
}

