/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbo;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzalb;
import com.google.android.gms.internal.ads.zzamt;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzaor;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzaqg;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzaqx;
import com.google.android.gms.internal.ads.zzarj;
import com.google.android.gms.internal.ads.zzark;
import com.google.android.gms.internal.ads.zzarl;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzarx;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzash;
import com.google.android.gms.internal.ads.zzasi;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzfs;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzhu;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznq;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zznx;
import com.google.android.gms.internal.ads.zzox;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@zzadh
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzari
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzaqw {
    private final zzash zzdda;
    @Nullable
    private final zzci zzbjc;
    private final zzang zzyf;
    private final zzbo zzddb;
    private final zzw zzwc;
    private final DisplayMetrics zzagj;
    private final float zzddc;
    private boolean zzddd = false;
    private boolean zzdde = false;
    private zzaqx zzddf;
    @GuardedBy(value="this")
    private zzd zzddg;
    @GuardedBy(value="this")
    private zzasi zzddh;
    @GuardedBy(value="this")
    private String zzus;
    @GuardedBy(value="this")
    private boolean zzddi;
    @GuardedBy(value="this")
    private boolean zzddj;
    @GuardedBy(value="this")
    private boolean zzddk;
    @GuardedBy(value="this")
    private boolean zzddl;
    @GuardedBy(value="this")
    private Boolean zzcpp;
    @GuardedBy(value="this")
    private int zzddm;
    @GuardedBy(value="this")
    private boolean zzddn = true;
    @GuardedBy(value="this")
    private boolean zzddo = false;
    @GuardedBy(value="this")
    private String zzchp = "";
    @GuardedBy(value="this")
    private zzarl zzddp;
    @GuardedBy(value="this")
    private boolean zzddq;
    @GuardedBy(value="this")
    private boolean zzddr;
    @GuardedBy(value="this")
    private zzox zzdds;
    @GuardedBy(value="this")
    private int zzddt;
    @GuardedBy(value="this")
    private int zzddu;
    private zznv zzddv;
    private zznv zzdad;
    private zznv zzddw;
    private zznw zzddx;
    private WeakReference<View.OnClickListener> zzddy;
    @GuardedBy(value="this")
    private zzd zzddz;
    @GuardedBy(value="this")
    private boolean zzdea;
    private zzamt zzaee;
    private int zzbwz = -1;
    private int zzbwy = -1;
    private int zzbxb = -1;
    private int zzbxc = -1;
    private Map<String, zzaqh> zzdeb;
    private final WindowManager zzaeu;
    private final zzhs zzcch;

    static zzari zzb(Context context, zzasi zzasi2, String string2, boolean bl, boolean bl2, @Nullable zzci zzci2, zzang zzang2, zznx zznx2, zzbo zzbo2, zzw zzw2, zzhs zzhs2) {
        zzash zzash2 = new zzash(context);
        return new zzari(zzash2, zzasi2, string2, bl, bl2, zzci2, zzang2, zznx2, zzbo2, zzw2, zzhs2);
    }

    @VisibleForTesting
    private zzari(zzash zzash2, zzasi zzasi2, String string2, boolean bl, boolean bl2, @Nullable zzci zzci2, zzang zzang2, zznx zznx2, zzbo zzbo2, zzw zzw2, zzhs zzhs2) {
        super((Context)zzash2);
        this.zzdda = zzash2;
        this.zzddh = zzasi2;
        this.zzus = string2;
        this.zzddk = bl;
        this.zzddm = -1;
        this.zzbjc = zzci2;
        this.zzyf = zzang2;
        this.zzddb = zzbo2;
        this.zzwc = zzw2;
        this.zzaeu = (WindowManager)this.getContext().getSystemService("window");
        zzbv.zzek();
        this.zzagj = zzakk.zza(this.zzaeu);
        this.zzddc = this.zzagj.density;
        this.zzcch = zzhs2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzakb.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzbv.zzek().zza((Context)zzash2, zzang2.zzcw, webSettings);
        zzbv.zzem().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzvk();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            this.addJavascriptInterface(zzaro.zzk(this), "googleAdsJsInterface");
        }
        if (PlatformVersion.isAtLeastHoneycomb()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzaee = new zzamt(this.zzdda.zzto(), (View)this, this, null);
        zznx zznx3 = zznx2;
        zzari zzari2 = this;
        zzari2.zzvo();
        zzari2.zzddx = new zznw(new zznx(true, "make_wv", zzari2.zzus));
        zzari2.zzddx.zzji().zzc(zznx3);
        zzari2.zzdad = zznq.zzb(zzari2.zzddx.zzji());
        zzari2.zzddx.zza("native:view_create", zzari2.zzdad);
        zzari2.zzddw = null;
        zzari2.zzddv = null;
        zzbv.zzem().zzaw((Context)zzash2);
        zzbv.zzeo().zzqe();
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzaqx) {
            this.zzddf = (zzaqx)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzw zzbi() {
        return this.zzwc;
    }

    private final boolean zzvh() {
        int n;
        int n2;
        if (!this.zzddf.zzfz() && !this.zzddf.zzuu()) {
            return false;
        }
        zzkb.zzif();
        int n3 = zzamu.zzb((DisplayMetrics)this.zzagj, (int)this.zzagj.widthPixels);
        zzkb.zzif();
        int n4 = zzamu.zzb((DisplayMetrics)this.zzagj, (int)this.zzagj.heightPixels);
        Activity activity = this.zzdda.zzto();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbv.zzek();
            int[] nArray = zzakk.zzf(activity);
            zzkb.zzif();
            n2 = zzamu.zzb((DisplayMetrics)this.zzagj, (int)nArray[0]);
            zzkb.zzif();
            n = zzamu.zzb((DisplayMetrics)this.zzagj, (int)nArray[1]);
        }
        if (this.zzbwy == n3 && this.zzbwz == n4 && this.zzbxb == n2 && this.zzbxc == n) {
            return false;
        }
        boolean bl = this.zzbwy != n3 || this.zzbwz != n4;
        this.zzbwy = n3;
        this.zzbwz = n4;
        this.zzbxb = n2;
        this.zzbxc = n;
        new zzaal(this).zza(n3, n4, n2, n, this.zzagj.density, this.zzaeu.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbv.zzek().zzn(map);
        }
        catch (JSONException jSONException) {
            zzakb.zzdk((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzakb.zzdm((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    private final synchronized void zzds(String string2) {
        if (!this.isDestroyed()) {
            this.loadUrl(string2);
            return;
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                zzbv.zzeo().zza(throwable, "AdWebViewImpl.loadUrl");
                zzakb.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                return;
            }
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final synchronized void zzdt(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            zzbv.zzeo().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
            zzakb.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zzc(String string2, String string3, @Nullable String string4) {
        if (!this.isDestroyed()) {
            zzna zzna2 = zznk.zzaya;
            String string5 = (Boolean)zzkb.zzik().zzd(zzna2) != false ? zzarx.zzb(string3, zzarx.zzvp()) : string3;
            super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
            return;
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @TargetApi(value=19)
    private final synchronized void zza(String string2, ValueCallback<String> valueCallback) {
        if (!this.isDestroyed()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        zzakb.zzdk((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final void zzdu(String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            if (this.zzpz() == null) {
                this.zzvi();
            }
            if (this.zzpz().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
                return;
            }
            String string3 = String.valueOf(string2);
            this.zzds(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            return;
        }
        String string4 = String.valueOf(string2);
        this.zzds(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
    }

    @Override
    public final void zzbe(String string2) {
        this.zzdu(string2);
    }

    private final synchronized void zzvi() {
        this.zzcpp = zzbv.zzeo().zzpz();
        if (this.zzcpp == null) {
            try {
                String string2 = "(function(){})()";
                this.evaluateJavascript(string2, null);
                this.zza(true);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.zza(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void zza(Boolean bl) {
        zzari zzari2 = this;
        synchronized (zzari2) {
            this.zzcpp = bl;
        }
        zzbv.zzeo().zza(bl);
    }

    @VisibleForTesting
    private final synchronized Boolean zzpz() {
        return this.zzcpp;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzari zzari2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzari2.zzdu(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzakb.zzck((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzdu(stringBuilder.toString());
    }

    @Override
    public final void zzty() {
        this.zzvj();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzyf.zzcw);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzai(int n) {
        if (n == 0) {
            zzari zzari2 = this;
            zznq.zza(zzari2.zzddx.zzji(), zzari2.zzdad, "aebb2");
        }
        this.zzvj();
        if (this.zzddx.zzji() != null) {
            this.zzddx.zzji().zze("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzyf.zzcw);
        this.zza("onhide", hashMap);
    }

    private final void zzvj() {
        zznq.zza(this.zzddx.zzji(), this.zzdad, "aeh2");
    }

    @Override
    public final void zzno() {
        if (this.zzddv == null) {
            zznq.zza(this.zzddx.zzji(), this.zzdad, "aes2");
            this.zzddv = zznq.zzb(this.zzddx.zzji());
            this.zzddx.zza("native:view_show", this.zzddv);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzyf.zzcw);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zztz() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzbv.zzfj().zzdp()));
        hashMap.put("app_volume", String.valueOf(zzbv.zzfj().zzdo()));
        hashMap.put("device_volume", String.valueOf(zzalb.zzay(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final synchronized zzd zzub() {
        return this.zzddg;
    }

    @Override
    public final synchronized zzd zzuc() {
        return this.zzddz;
    }

    @Override
    public final synchronized zzasi zzud() {
        return this.zzddh;
    }

    @Override
    public final synchronized String zzue() {
        return this.zzus;
    }

    @Override
    public final WebViewClient zzug() {
        return this.zzddf;
    }

    @Override
    public final synchronized boolean zzuh() {
        return this.zzddi;
    }

    @Override
    public final zzci zzui() {
        return this.zzbjc;
    }

    @Override
    public final zzang zztq() {
        return this.zzyf;
    }

    @Override
    public final synchronized boolean zzuj() {
        return this.zzddk;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbv.zzek();
            zzakk.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzakb.zzck((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzddf.zzuu()) {
            zzari zzari2 = this;
            synchronized (zzari2) {
                if (this.zzdds != null) {
                    this.zzdds.zzc(motionEvent);
                }
            }
        } else if (this.zzbjc != null) {
            this.zzbjc.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzna zzna2 = zznk.zzaxx;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzddk || this.zzddh.zzvt()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzddh.zzvu()) {
            float f = 0.0f;
            zzarl zzarl2 = this.zztm();
            if (zzarl2 != null) {
                f = zzarl2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzddh.isFluid()) {
            int n11;
            Object object = zznk.zzbch;
            if (((Boolean)zzkb.zzik().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzarj((zzari)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            this.zzdu(string2);
            float f = this.zzagj.density;
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzddu) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzddu * f);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzddh.zzvs()) {
            this.setMeasuredDimension(this.zzagj.widthPixels, this.zzagj.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzddh.widthPixels > n17 || this.zzddh.heightPixels > n18 ? 1 : 0;
        zzna zzna2 = zznk.zzbfe;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            int n20 = n4 = !((float)this.zzddh.widthPixels / this.zzddc > (float)n17 / this.zzddc) && !((float)this.zzddh.heightPixels / this.zzddc > (float)n18 / this.zzddc) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzddh.widthPixels / this.zzddc);
            int n21 = (int)((float)this.zzddh.heightPixels / this.zzddc);
            int n22 = (int)((float)n14 / this.zzddc);
            int n23 = (int)((float)n16 / this.zzddc);
            zzakb.zzdk((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            if (!this.zzddd) {
                this.zzcch.zza(zzhu.zza.zzb.zzalj);
                this.zzddd = true;
                return;
            }
        } else {
            if (this.getVisibility() != 8) {
                this.setVisibility(0);
            }
            if (!this.zzdde) {
                this.zzcch.zza(zzhu.zza.zzb.zzalk);
                this.zzdde = true;
            }
            this.setMeasuredDimension(this.zzddh.widthPixels, this.zzddh.heightPixels);
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzvh();
        zzd zzd2 = this.zzub();
        if (zzd2 != null && bl) {
            zzd2.zznn();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzddg = zzd2;
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzddz = zzd2;
    }

    @Override
    public final synchronized void zza(zzasi zzasi2) {
        this.zzddh = zzasi2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzai(boolean bl) {
        boolean bl2 = bl != this.zzddk;
        this.zzddk = bl;
        this.zzvk();
        if (bl2) {
            new zzaal(this).zzby(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzuo() {
        this.zzaee.zzsc();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzaee.onAttachedToWindow();
        }
        boolean bl = this.zzddq;
        if (this.zzddf != null && this.zzddf.zzuu()) {
            bl = true;
            if (!this.zzddr) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzddf.zzuv();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzfg();
                    zzari zzari2 = this;
                    if (zzari2 == null) {
                        throw null;
                    }
                    zzaor.zza((View)zzari2, onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzddf.zzuw()) != null) {
                    zzbv.zzfg();
                    zzari zzari3 = this;
                    if (zzari3 == null) {
                        throw null;
                    }
                    zzaor.zza((View)zzari3, onScrollChangedListener);
                }
                this.zzddr = true;
            }
            this.zzvh();
        }
        this.zzal(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzari zzari2 = this;
        synchronized (zzari2) {
            if (!this.isDestroyed()) {
                this.zzaee.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzddr && this.zzddf != null && this.zzddf.zzuu() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzddf.zzuv();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzem().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzddf.zzuw()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzddr = false;
            }
        }
        this.zzal(false);
    }

    @Override
    public final void zzbm(Context context) {
        this.zzdda.setBaseContext(context);
        this.zzaee.zzi(this.zzdda.zzto());
    }

    @Override
    public final synchronized void zzu(boolean bl) {
        if (this.zzddg != null) {
            this.zzddg.zza(this.zzddf.zzfz(), bl);
            return;
        }
        this.zzddi = bl;
    }

    @Override
    public final synchronized int getRequestedOrientation() {
        return this.zzddm;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzddm = n;
        if (this.zzddg != null) {
            this.zzddg.setRequestedOrientation(this.zzddm);
        }
    }

    @Override
    public final Activity zzto() {
        return this.zzdda.zzto();
    }

    @Override
    public final Context zzua() {
        return this.zzdda.zzua();
    }

    private final synchronized void zzvk() {
        if (this.zzddk || this.zzddh.zzvs()) {
            zzakb.zzck((String)"Enabling hardware acceleration on an overlay.");
            this.zzvm();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzakb.zzck((String)"Disabling hardware acceleration on an AdView.");
            this.zzvl();
            return;
        }
        zzakb.zzck((String)"Enabling hardware acceleration on an AdView.");
        this.zzvm();
    }

    private final synchronized void zzvl() {
        if (!this.zzddl) {
            zzbv.zzem().zzz((View)this);
        }
        this.zzddl = true;
    }

    private final synchronized void zzvm() {
        if (this.zzddl) {
            zzbv.zzem().zzy((View)this);
        }
        this.zzddl = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzvo();
        this.zzaee.zzsd();
        if (this.zzddg != null) {
            this.zzddg.close();
            this.zzddg.onDestroy();
            this.zzddg = null;
        }
        this.zzddf.reset();
        if (this.zzddj) {
            return;
        }
        zzbv.zzff();
        zzaqg.zzb(this);
        this.zzvn();
        this.zzddj = true;
        zzakb.v("Initiating WebView self destruct sequence in 3...");
        zzakb.v("Loading blank page in WebView, 2...");
        this.zzdt("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzari zzari2 = this;
            synchronized (zzari2) {
                if (!this.zzddj) {
                    this.zzddf.reset();
                    zzbv.zzff();
                    zzaqg.zzb(this);
                    this.zzvn();
                    this.zzqf();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzuk() {
        zzakb.v("Destroying WebView!");
        this.zzqf();
        zzakk.zzcrm.post((Runnable)new zzark(this));
    }

    private final synchronized void zzqf() {
        if (!this.zzdea) {
            this.zzdea = true;
            zzbv.zzeo().zzqf();
        }
    }

    @Override
    public final synchronized boolean isDestroyed() {
        return this.zzddj;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzddf != null && this.zzddf.zzve() != null) {
            this.zzddf.zzve().zzda();
        }
    }

    @Override
    public final void zzup() {
        if (this.zzddw == null) {
            this.zzddw = zznq.zzb(this.zzddx.zzji());
            this.zzddx.zza("native:view_load", this.zzddw);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (PlatformVersion.isAtLeastHoneycomb()) {
                super.onPause();
            }
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (PlatformVersion.isAtLeastHoneycomb()) {
                super.onResume();
            }
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzus() {
        zzakb.v("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzakb.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzaj(boolean bl) {
        this.zzddn = bl;
    }

    @Override
    public final synchronized boolean zzul() {
        return this.zzddn;
    }

    @Override
    public final synchronized boolean zzum() {
        return this.zzddo;
    }

    @Override
    public final synchronized void zzcl() {
        this.zzddo = true;
        if (this.zzddb != null) {
            this.zzddb.zzcl();
        }
    }

    @Override
    public final synchronized void zzcm() {
        this.zzddo = false;
        if (this.zzddb != null) {
            this.zzddb.zzcm();
        }
    }

    private final synchronized void zzvn() {
        this.zzdeb = null;
    }

    @Override
    public final synchronized void zzdr(String string2) {
        this.zzchp = string2 == null ? "" : string2;
    }

    @Override
    public final synchronized String zzol() {
        return this.zzchp;
    }

    @Override
    public final zzapn zztl() {
        return null;
    }

    @Override
    public final zznv zztn() {
        return this.zzdad;
    }

    @Override
    public final zznw zztp() {
        return this.zzddx;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzddy = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener getOnClickListener() {
        return (View.OnClickListener)this.zzddy.get();
    }

    @Override
    public final synchronized void zzb(zzox zzox2) {
        this.zzdds = zzox2;
    }

    @Override
    public final synchronized zzox zzuq() {
        return this.zzdds;
    }

    @Override
    public final synchronized zzarl zztm() {
        return this.zzddp;
    }

    @Override
    public final synchronized void zza(zzarl zzarl2) {
        if (this.zzddp != null) {
            zzakb.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzddp = zzarl2;
    }

    @Override
    public final synchronized boolean zzun() {
        return this.zzddt > 0;
    }

    @Override
    public final synchronized void zzak(boolean bl) {
        this.zzddt += bl ? 1 : -1;
        if (this.zzddt <= 0 && this.zzddg != null) {
            this.zzddg.zznq();
        }
    }

    private final void zzvo() {
        if (this.zzddx == null) {
            return;
        }
        zznx zznx2 = this.zzddx.zzji();
        if (zznx2 != null && zzbv.zzeo().zzpy() != null) {
            zzbv.zzeo().zzpy().zza(zznx2);
        }
    }

    @Override
    public final void zzur() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzah(boolean bl) {
        this.zzddf.zzah(bl);
    }

    @Override
    public final void zznp() {
        zzd zzd2 = this.zzub();
        if (zzd2 != null) {
            zzd2.zznp();
        }
    }

    @Override
    public final int zztr() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzts() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzddf.zza(zzc2);
    }

    @Override
    public final void zza(boolean bl, int n) {
        this.zzddf.zza(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzddf.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzddf.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzfs zzfs2) {
        zzari zzari2 = this;
        synchronized (zzari2) {
            this.zzddq = zzfs2.zztg;
        }
        this.zzal(zzfs2.zztg);
    }

    private final void zzal(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzv<? super zzaqw> zzv2) {
        if (this.zzddf != null) {
            this.zzddf.zza(string2, zzv2);
        }
    }

    @Override
    public final void zzb(String string2, zzv<? super zzaqw> zzv2) {
        if (this.zzddf != null) {
            this.zzddf.zzb(string2, zzv2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzv<? super zzaqw>> predicate) {
        if (this.zzddf != null) {
            this.zzddf.zza(string2, predicate);
        }
    }

    @Override
    public final /* synthetic */ zzasc zzuf() {
        return this.zzddf;
    }

    static /* synthetic */ int zza(zzari zzari2) {
        return zzari2.zzddu;
    }

    static /* synthetic */ int zza(zzari zzari2, int n) {
        zzari2.zzddu = n;
        return zzari2.zzddu;
    }

    static /* synthetic */ void zzb(zzari zzari2) {
        super.destroy();
    }
}

