/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.gmsg.zza;
import com.google.android.gms.ads.internal.gmsg.zzab;
import com.google.android.gms.ads.internal.gmsg.zzac;
import com.google.android.gms.ads.internal.gmsg.zzad;
import com.google.android.gms.ads.internal.gmsg.zzb;
import com.google.android.gms.ads.internal.gmsg.zzc;
import com.google.android.gms.ads.internal.gmsg.zzd;
import com.google.android.gms.ads.internal.gmsg.zzf;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.ads.internal.gmsg.zzy;
import com.google.android.gms.ads.internal.gmsg.zzz;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzt;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzx;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaab;
import com.google.android.gms.internal.ads.zzaak;
import com.google.android.gms.internal.ads.zzaam;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzait;
import com.google.android.gms.internal.ads.zzajb;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzamy;
import com.google.android.gms.internal.ads.zzaoe;
import com.google.android.gms.internal.ads.zzaql;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzaqy;
import com.google.android.gms.internal.ads.zzaqz;
import com.google.android.gms.internal.ads.zzara;
import com.google.android.gms.internal.ads.zzarb;
import com.google.android.gms.internal.ads.zzasc;
import com.google.android.gms.internal.ads.zzasd;
import com.google.android.gms.internal.ads.zzase;
import com.google.android.gms.internal.ads.zzasf;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzcj;
import com.google.android.gms.internal.ads.zzhi;
import com.google.android.gms.internal.ads.zzhl;
import com.google.android.gms.internal.ads.zzjd;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzmw;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzadh
@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzaqx
extends WebViewClient
implements zzasc {
    private static final String[] zzdbo = new String[]{"UNKNOWN", "HOST_LOOKUP", "UNSUPPORTED_AUTH_SCHEME", "AUTHENTICATION", "PROXY_AUTHENTICATION", "CONNECT", "IO", "TIMEOUT", "REDIRECT_LOOP", "UNSUPPORTED_SCHEME", "FAILED_SSL_HANDSHAKE", "BAD_URL", "FILE", "FILE_NOT_FOUND", "TOO_MANY_REQUESTS"};
    private static final String[] zzdbp = new String[]{"NOT_YET_VALID", "EXPIRED", "ID_MISMATCH", "UNTRUSTED", "DATE_INVALID", "INVALID"};
    private zzaqw zzbnd;
    private final HashMap<String, List<zzv<? super zzaqw>>> zzdbq = new HashMap();
    private final Object mLock = new Object();
    private zzjd zzapt;
    private zzn zzbnc;
    private zzasd zzdbr;
    private zzase zzdbs;
    private zzb zzbll;
    private zzd zzblm;
    private zzasf zzdbt;
    private boolean zzdbu = false;
    private zzz zzbmu;
    @GuardedBy(value="mLock")
    private boolean zzaek;
    @GuardedBy(value="mLock")
    private boolean zzdbv;
    @GuardedBy(value="mLock")
    private ViewTreeObserver.OnGlobalLayoutListener zzdbw;
    @GuardedBy(value="mLock")
    private ViewTreeObserver.OnScrollChangedListener zzdbx;
    @GuardedBy(value="mLock")
    private boolean zzdby;
    private zzt zzbnb;
    private final zzaak zzdbz;
    private zzx zzbmw;
    private zzaab zzbmx;
    private zzaam zzbmy;
    private zzasg zzdca;
    @Nullable
    protected zzait zzxd;
    private boolean zzdcb;
    private boolean zzdcc;
    private int zzdcd;
    private View.OnAttachStateChangeListener zzdce;

    public zzaqx(zzaqw zzaqw2, boolean bl) {
        this(zzaqw2, bl, new zzaak(zzaqw2, zzaqw2.zzua(), new zzmw(zzaqw2.getContext())), null);
    }

    @VisibleForTesting
    private zzaqx(zzaqw zzaqw2, boolean bl, zzaak zzaak2, zzaab zzaab2) {
        this.zzbnd = zzaqw2;
        this.zzaek = bl;
        this.zzdbz = zzaak2;
        this.zzbmx = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzdbz.zzc(n, n2);
        if (this.zzbmx != null) {
            this.zzbmx.zza(n, n2, bl);
        }
    }

    @Override
    public final void zza(zzjd zzjd2, zzb zzb2, zzn zzn2, zzd zzd2, zzt zzt2, boolean bl, @Nullable zzz zzz2, zzx zzx2, zzaam zzaam2, @Nullable zzait zzait2) {
        boolean bl2;
        if (zzx2 == null) {
            zzx2 = new zzx(this.zzbnd.getContext(), zzait2, null);
        }
        this.zzbmx = new zzaab(this.zzbnd, zzaam2);
        this.zzxd = zzait2;
        zzna zzna2 = zznk.zzayf;
        if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
            this.zza("/adMetadata", new zza(zzb2));
        }
        this.zza("/appEvent", new zzc(zzd2));
        this.zza("/backButton", zzf.zzblx);
        this.zza("/refresh", zzf.zzbly);
        this.zza("/canOpenURLs", zzf.zzblo);
        this.zza("/canOpenIntents", zzf.zzblp);
        this.zza("/click", zzf.zzblq);
        this.zza("/close", zzf.zzblr);
        this.zza("/customClose", zzf.zzbls);
        this.zza("/instrument", zzf.zzbmb);
        this.zza("/delayPageLoaded", zzf.zzbmd);
        this.zza("/delayPageClosed", zzf.zzbme);
        this.zza("/getLocationInfo", zzf.zzbmf);
        this.zza("/httpTrack", zzf.zzblt);
        this.zza("/log", zzf.zzblu);
        this.zza("/mraid", new zzac(zzx2, this.zzbmx, zzaam2));
        this.zza("/mraidLoaded", this.zzdbz);
        this.zza("/open", new zzad(this.zzbnd.getContext(), this.zzbnd.zztq(), this.zzbnd.zzui(), zzt2, zzjd2, zzb2, zzd2, zzn2, zzx2, this.zzbmx));
        this.zza("/precache", new zzaql());
        this.zza("/touch", zzf.zzblw);
        this.zza("/video", zzf.zzblz);
        this.zza("/videoMeta", zzf.zzbma);
        if (zzbv.zzfh().zzs(this.zzbnd.getContext())) {
            this.zza("/logScionEvent", new zzab(this.zzbnd.getContext()));
        }
        if (zzz2 != null) {
            this.zza("/setInterstitialProperties", new zzy(zzz2));
        }
        this.zzapt = zzjd2;
        this.zzbnc = zzn2;
        this.zzbll = zzb2;
        this.zzblm = zzd2;
        this.zzbnb = zzt2;
        this.zzbmw = zzx2;
        this.zzbmy = zzaam2;
        this.zzbmu = zzz2;
        this.zzdbu = bl2 = bl;
    }

    @Override
    public final zzx zzut() {
        return this.zzbmw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzfz() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzaek;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzuu() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdbv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzuv() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdbw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzuw() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdbx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzux() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdby;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbnd.isDestroyed()) {
                zzakb.v("Blank page loaded, 1...");
                this.zzbnd.zzuk();
                return;
            }
        }
        this.zzdcb = true;
        zzaqx zzaqx2 = this;
        if (zzaqx2.zzdbs != null) {
            zzaqx2.zzdbs.zzly();
            zzaqx2.zzdbs = null;
        }
        this.zzvd();
    }

    private final void zza(View view, zzait zzait2, int n) {
        if (zzait2.zzph() && n > 0) {
            zzait2.zzr(view);
            if (zzait2.zzph()) {
                zzakk.zzcrm.postDelayed((Runnable)new zzaqz(this, view, zzait2, n), 100L);
            }
        }
    }

    private final void zzuy() {
        if (this.zzdce == null) {
            return;
        }
        this.zzbnd.getView().removeOnAttachStateChangeListener(this.zzdce);
    }

    @Override
    public final void zzuz() {
        zzait zzait2 = this.zzxd;
        if (zzait2 != null) {
            WebView webView = this.zzbnd.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzait2, 10);
                return;
            }
            zzait zzait3 = zzait2;
            zzaqx zzaqx2 = this;
            zzaqx2.zzuy();
            zzaqx2.zzdce = new zzara(zzaqx2, zzait3);
            zzaqx2.zzbnd.getView().addOnAttachStateChangeListener(zzaqx2.zzdce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzva() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdby = true;
        }
        ++this.zzdcd;
        this.zzvd();
    }

    @Override
    public final void zzvb() {
        --this.zzdcd;
        this.zzvd();
    }

    @Override
    public final void zzvc() {
        this.zzdcc = true;
        this.zzvd();
    }

    private final void zzvd() {
        if (this.zzdbr != null && (this.zzdcb && this.zzdcd <= 0 || this.zzdcc)) {
            this.zzdbr.zze(!this.zzdcc);
            this.zzdbr = null;
        }
        this.zzbnd.zzup();
    }

    public final void zza(com.google.android.gms.ads.internal.overlay.zzc zzc2) {
        boolean bl = this.zzbnd.zzuj();
        this.zza(new AdOverlayInfoParcel(zzc2, (zzjd)(bl && !this.zzbnd.zzud().zzvs() ? null : this.zzapt), bl ? null : this.zzbnc, this.zzbnb, this.zzbnd.zztq()));
    }

    public final void zza(boolean bl, int n) {
        boolean bl2 = this.zzbnd.zzuj();
        this.zza(new AdOverlayInfoParcel((zzjd)(bl2 && !this.zzbnd.zzud().zzvs() ? null : this.zzapt), this.zzbnc, this.zzbnb, this.zzbnd, bl, n, this.zzbnd.zztq()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzbnd.zzuj();
        this.zza(new AdOverlayInfoParcel((zzjd)(bl2 && !this.zzbnd.zzud().zzvs() ? null : this.zzapt), bl2 ? null : new zzarb(this.zzbnd, this.zzbnc), this.zzbll, this.zzblm, this.zzbnb, this.zzbnd, bl, n, string2, this.zzbnd.zztq()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzbnd.zzuj();
        this.zza(new AdOverlayInfoParcel((zzjd)(bl2 && !this.zzbnd.zzud().zzvs() ? null : this.zzapt), bl2 ? null : new zzarb(this.zzbnd, this.zzbnc), this.zzbll, this.zzblm, this.zzbnb, this.zzbnd, bl, n, string2, string3, this.zzbnd.zztq()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzbmx != null) {
            bl = this.zzbmx.zznf();
        }
        zzbv.zzei();
        zzl.zza(this.zzbnd.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzxd != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzbyl != null) {
                string2 = adOverlayInfoParcel.zzbyl.url;
            }
            this.zzxd.zzcf(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzv<? super zzaqw> zzv2) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzv<? super zzaqw>> list = this.zzdbq.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzv<? super zzaqw>>();
                this.zzdbq.put(string2, list);
            }
            list.add(zzv2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzv<? super zzaqw> zzv2) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzv<? super zzaqw>> list = this.zzdbq.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzv2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzv<? super zzaqw>> predicate) {
        Object object = this.mLock;
        synchronized (object) {
            List<zzv<? super zzaqw>> list = this.zzdbq.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzv<? super zzaqw>> arrayList = new ArrayList<zzv<? super zzaqw>>();
            for (zzv<? super zzaqw> zzv2 : list) {
                if (!predicate.apply(zzv2)) continue;
                arrayList.add(zzv2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzxd != null) {
            this.zzxd.zzpj();
            this.zzxd = null;
        }
        this.zzuy();
        Object object = this.mLock;
        synchronized (object) {
            this.zzdbq.clear();
            this.zzapt = null;
            this.zzbnc = null;
            this.zzdbr = null;
            this.zzdbs = null;
            this.zzbll = null;
            this.zzblm = null;
            this.zzdbu = false;
            this.zzaek = false;
            this.zzdbv = false;
            this.zzdby = false;
            this.zzbnb = null;
            this.zzdbt = null;
            if (this.zzbmx != null) {
                this.zzbmx.zzm(true);
                this.zzbmx = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzasd zzasd2) {
        this.zzdbr = zzasd2;
    }

    @Override
    public final void zza(zzase zzase2) {
        this.zzdbs = zzase2;
    }

    @Override
    public final void zza(zzasf zzasf2) {
        this.zzdbt = zzasf2;
    }

    @Override
    public final void zza(zzasg zzasg2) {
        this.zzdca = zzasg2;
    }

    public final zzasg zzve() {
        return this.zzdca;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzakb.v(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzi(uri);
        }
    }

    public final void onReceivedError(WebView webView, int n, String string2, String string3) {
        String string4 = n < 0 && -n - 1 < zzdbo.length ? zzdbo[-n - 1] : String.valueOf(n);
        this.zzd(this.zzbnd.getContext(), "http_err", string4, string3);
        super.onReceivedError(webView, n, string2, string3);
    }

    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (sslError != null) {
            int n = sslError.getPrimaryError();
            String string2 = n >= 0 && n < zzdbp.length ? zzdbp[n] : String.valueOf(n);
            this.zzd(this.zzbnd.getContext(), "ssl_err", string2, zzbv.zzem().zza(sslError));
        }
        super.onReceivedSslError(webView, sslErrorHandler, sslError);
    }

    private final void zzd(Context context, String string2, String string3, String string4) {
        Uri uri;
        Object object = zznk.zzazy;
        if (!((Boolean)zzkb.zzik().zzd(object)).booleanValue()) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("err", string2);
        bundle.putString("code", string3);
        object = string4;
        bundle.putString("host", !TextUtils.isEmpty((CharSequence)object) && (uri = Uri.parse((String)object)).getHost() != null ? uri.getHost() : "");
        zzbv.zzek().zza(context, this.zzbnd.zztq().zzcw, "gmob-apps", bundle, true);
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzakb.v(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzi(uri);
        } else {
            String string4;
            if (this.zzdbu && webView == this.zzbnd.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzapt != null) {
                    zzna zzna2 = zznk.zzaxf;
                    if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                        this.zzapt.onAdClicked();
                        if (this.zzxd != null) {
                            this.zzxd.zzcf(string2);
                        }
                        this.zzapt = null;
                    }
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzbnd.getWebView().willNotDraw()) {
                try {
                    zzci zzci2 = this.zzbnd.zzui();
                    if (zzci2 != null && zzci2.zzb(uri)) {
                        uri = zzci2.zza(uri, this.zzbnd.getContext(), this.zzbnd.getView(), this.zzbnd.zzto());
                    }
                }
                catch (zzcj zzcj2) {
                    String string5 = String.valueOf(string2);
                    zzakb.zzdk((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzbmw == null || this.zzbmw.zzcy()) {
                    this.zza(new com.google.android.gms.ads.internal.overlay.zzc("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzbmw.zzs(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzakb.zzdk((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzhi zzhi2;
            String string3 = zzajb.zzb(string2, this.zzbnd.getContext());
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzhl zzhl2 = zzhl.zzaa(string2);
            if (zzhl2 != null && (zzhi2 = zzbv.zzeq().zza(zzhl2)) != null && zzhi2.zzhi()) {
                return new WebResourceResponse("", "", zzhi2.zzhj());
            }
            if (zzamy.isEnabled()) {
                zzna zzna2 = zznk.zzazn;
                if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                    return this.zze(string2, map);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzbv.zzeo().zza(throwable, "AdWebViewClient.interceptRequest");
            return null;
        }
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzbv.zzek().zza(this.zzbnd.getContext(), this.zzbnd.zztq().zzcw, false, httpURLConnection);
            zzamy zzamy22 = new zzamy();
            zzamy22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzamy22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzakb.zzdk((String)"Protocol is null");
                    return null;
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzakb.zzdk((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return null;
                }
                String string6 = String.valueOf(string3);
                zzakb.zzck((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzbv.zzek();
            return zzakk.zzb(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzah(boolean bl) {
        this.zzdbu = bl;
    }

    @Override
    public final zzait zzvf() {
        return this.zzxd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdbv = true;
            this.zzbnd.zzuo();
            this.zzdbw = onGlobalLayoutListener;
            this.zzdbx = onScrollChangedListener;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zznk() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdbu = false;
            this.zzaek = true;
            zzaoe.zzcvy.execute(new zzaqy(this));
            return;
        }
    }

    @Override
    public final void zzb(int n, int n2) {
        if (this.zzbmx != null) {
            this.zzbmx.zzb(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    private final void zzi(Uri uri) {
        String string2 = uri.getPath();
        List<zzv<? super zzaqw>> list = this.zzdbq.get(string2);
        if (list != null) {
            zzbv.zzek();
            Map<String, String> map = zzakk.zzg(uri);
            if (zzakb.isLoggable((int)2)) {
                String string3 = String.valueOf(string2);
                zzakb.v(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
                for (String string4 : map.keySet()) {
                    String string5 = map.get(string4);
                    zzakb.v(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
                }
            }
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(this.zzbnd, map);
            }
            return;
        }
        String string6 = String.valueOf(uri);
        zzakb.v(new StringBuilder(32 + String.valueOf(string6).length()).append("No GMSG handler found for GMSG: ").append(string6).toString());
    }

    final /* synthetic */ void zzvg() {
        this.zzbnd.zzuo();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzbnd.zzub();
        if (zzd2 != null) {
            zzd2.zznk();
        }
        if (this.zzdbt != null) {
            this.zzdbt.zzdb();
            this.zzdbt = null;
        }
    }

    static /* synthetic */ void zza(zzaqx zzaqx2, View view, zzait zzait2, int n) {
        zzaqx2.zza(view, zzait2, n);
    }
}

