/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzx;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzaqp;
import com.google.android.gms.internal.ads.zzaqq;
import com.google.android.gms.internal.ads.zzaqr;
import com.google.android.gms.internal.ads.zzaqs;
import com.google.android.gms.internal.ads.zzaqt;
import com.google.android.gms.internal.ads.zzaqu;
import com.google.android.gms.internal.ads.zzaqw;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;

@zzadh
@TargetApi(value=11)
public final class zzaqo
extends WebChromeClient {
    private final zzaqw zzbnd;

    public zzaqo(zzaqw zzaqw2) {
        this.zzbnd = zzaqw2;
    }

    private final boolean zza(Context context, String string2, String string3, String string4, String string5, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            Object object;
            if (this.zzbnd != null && this.zzbnd.zzuf() != null && this.zzbnd.zzuf().zzut() != null && (object = this.zzbnd.zzuf().zzut()) != null && !((zzx)object).zzcy()) {
                ((zzx)object).zzs(new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("window.").append(string2).append("('").append(string4).append("')").toString());
                return false;
            }
            object = new AlertDialog.Builder(context);
            object.setTitle((CharSequence)string3);
            if (bl) {
                JsPromptResult jsPromptResult2 = jsPromptResult;
                String string6 = string5;
                String string7 = string4;
                AlertDialog.Builder builder = object;
                Context context2 = context;
                LinearLayout linearLayout = new LinearLayout(context2);
                linearLayout.setOrientation(1);
                TextView textView = new TextView(context2);
                textView.setText((CharSequence)string7);
                EditText editText = new EditText(context2);
                editText.setText((CharSequence)string6);
                linearLayout.addView((View)textView);
                linearLayout.addView((View)editText);
                builder.setView((View)linearLayout).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzaqu(jsPromptResult2, editText)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzaqt(jsPromptResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzaqs(jsPromptResult2)).create().show();
            } else {
                JsResult jsResult2 = jsResult;
                String string8 = string4;
                object.setMessage((CharSequence)string8).setPositiveButton(17039370, (DialogInterface.OnClickListener)new zzaqr(jsResult2)).setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new zzaqq(jsResult2)).setOnCancelListener((DialogInterface.OnCancelListener)new zzaqp(jsResult2)).create().show();
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzakb.zzc((String)"Fail to display Dialog.", (Throwable)badTokenException);
        }
        return true;
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        if (this.zzbnd.zzug() != null) {
            webView2.setWebViewClient(this.zzbnd.zzug());
        }
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzaqw)) {
            zzakb.zzdk((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzd zzd2 = ((zzaqw)webView).zzub();
        if (zzd2 == null) {
            zzakb.zzdk((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzd2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = consoleMessage.message();
        String string3 = consoleMessage.sourceId();
        int n = consoleMessage.lineNumber();
        String string4 = new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JS: ").append(string2).append(" (").append(string3).append(":").append(n).append(")").toString();
        if (string4.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzakb.e((String)string4);
                break;
            }
            case WARNING: {
                zzakb.zzdk((String)string4);
                break;
            }
            case LOG: 
            case TIP: {
                zzakb.zzdj((String)string4);
                break;
            }
            case DEBUG: {
                zzakb.zzck((String)string4);
                break;
            }
            default: {
                zzakb.zzdj((String)string4);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            l4 = l2 <= l5 && l2 <= 0x100000L ? l2 : 0L;
        } else {
            long l6;
            long l7;
            if (l2 == 0L) {
                l7 = Math.min(131072L, l5);
                l6 = Math.min(l + l7, 0x100000L);
            } else {
                l7 = Math.min(0x100000L - l, l5);
                l6 = l2 <= l7 ? l + l2 : l;
            }
            l4 = l6;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onHideCustomView() {
        zzd zzd2 = this.zzbnd.zzub();
        if (zzd2 == null) {
            zzakb.zzdk((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzd2.zznh();
    }

    private static Context zza(WebView webView) {
        if (!(webView instanceof zzaqw)) {
            return webView.getContext();
        }
        zzaqw zzaqw2 = (zzaqw)webView;
        Activity activity = zzaqw2.zzto();
        if (activity != null) {
            return activity;
        }
        return zzaqw2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzaqo.zza(webView), "alert", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzaqo.zza(webView), "onBeforeUnload", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(zzaqo.zza(webView), "confirm", string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(zzaqo.zza(webView), "prompt", string2, string3, string4, null, jsPromptResult, true);
    }

    public final void onReachedMaxAppCacheSize(long l, long l2, WebStorage.QuotaUpdater quotaUpdater) {
        long l3 = 0x500000L - l2;
        long l4 = l + 131072L;
        if (l3 < l4) {
            quotaUpdater.updateQuota(0L);
            return;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.onShowCustomView(view, -1, customViewCallback);
    }

    @Deprecated
    public final void onShowCustomView(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzd zzd2 = this.zzbnd.zzub();
        if (zzd2 == null) {
            zzakb.zzdk((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzd2.zza(view, customViewCallback);
        zzd2.setRequestedOrientation(n);
    }

    /*
     * Unable to fully structure code
     */
    public final void onGeolocationPermissionsShowPrompt(String var1_1, GeolocationPermissions.Callback var2_2) {
        block2: {
            if (var2_2 == null) break block2;
            var3_3 = this;
            zzbv.zzek();
            if (zzakk.zzl(var3_3.zzbnd.getContext(), "android.permission.ACCESS_FINE_LOCATION")) ** GOTO lbl-1000
            zzbv.zzek();
            if (zzakk.zzl(var3_3.zzbnd.getContext(), "android.permission.ACCESS_COARSE_LOCATION")) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            var2_2.invoke(var1_1, v0, true);
        }
    }

    @TargetApi(value=21)
    public final void onPermissionRequest(PermissionRequest permissionRequest) {
        block6: {
            block5: {
                if (!PlatformVersion.isAtLeastLollipop()) break block5;
                zzna zzna2 = zznk.zzayb;
                if (!((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) break block6;
            }
            super.onPermissionRequest(permissionRequest);
            return;
        }
        if (this.zzbnd == null || this.zzbnd.zzuf() == null || this.zzbnd.zzuf().zzvf() == null) {
            super.onPermissionRequest(permissionRequest);
            return;
        }
        String[] stringArray = this.zzbnd.zzuf().zzvf().zzb(permissionRequest.getResources());
        if (stringArray.length > 0) {
            permissionRequest.grant(stringArray);
            return;
        }
        permissionRequest.deny();
    }
}

