/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzamy;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzaqh;
import com.google.android.gms.internal.ads.zzaqi;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzadh
public final class zzaqn
extends zzaqh {
    private static final Set<String> zzdbg = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzdbh = new DecimalFormat("#,###");
    private File zzdbi;
    private boolean zzdbj;

    public zzaqn(zzapw zzapw2) {
        super(zzapw2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzakb.zzdk((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzdbi = new File(file, "admobVideoStreams");
        if (!this.zzdbi.isDirectory() && !this.zzdbi.mkdirs()) {
            String string2 = String.valueOf(this.zzdbi.getAbsolutePath());
            zzakb.zzdk((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzdbi = null;
            return;
        }
        if (!this.zzdbi.setReadable(true, false) || !this.zzdbi.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzdbi.getAbsolutePath());
            zzakb.zzdk((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzdbi = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzdp(String string2) {
        int n;
        Object object;
        int n2;
        Object object2;
        block41: {
            int n3;
            if (this.zzdbi == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzaqn)object2).zzdbi == null) {
                    n4 = 0;
                } else {
                    n2 = 0;
                    object = ((zzaqn)object2).zzdbi.listFiles();
                    int n5 = ((File[])object).length;
                    for (n = 0; n < n5; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n2;
                    }
                    n4 = n2;
                }
                object2 = zznk.zzaux;
                if (n4 <= (Integer)zzkb.zzik().zzd((zzna)object2)) break block41;
                object2 = this;
                if (((zzaqn)object2).zzdbi == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzaqn)object2).zzdbi.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = super.zzc(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzakb.zzdk((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        object2 = string2;
        zzkb.zzif();
        String string3 = zzamu.zzde((String)object2);
        File file = new File(this.zzdbi, string3);
        File file4 = this.zzc(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzakb.zzck((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzdbi.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzdbg;
        synchronized (object3) {
            if (zzdbg.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzakb.zzdk((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzdbg.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            HttpURLConnection httpURLConnection;
            block42: {
                zzbv.zzew();
                object2 = zznk.zzavc;
                n2 = (Integer)zzkb.zzik().zzd((zzna)object2);
                object2 = string2;
                URL uRL = new URL((String)object2);
                n = 0;
                while (++n <= 20) {
                    File file2;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n2);
                    uRLConnection.setReadTimeout(n2);
                    if (!(uRLConnection instanceof HttpURLConnection)) {
                        throw new IOException("Invalid protocol.");
                    }
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    file2 = new zzamy();
                    file2.zza(httpURLConnection, null);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    int n9 = httpURLConnection.getResponseCode();
                    file2.zza(httpURLConnection, n9);
                    if (n9 / 100 == 3) {
                        String string11 = httpURLConnection.getHeaderField("Location");
                        if (string11 == null) {
                            throw new IOException("Missing Location header in redirect");
                        }
                        String string12 = (uRL = new URL(uRL, string11)).getProtocol();
                        if (string12 == null) {
                            throw new IOException("Protocol is null");
                        }
                        if (!string12.equals("http") && !string12.equals("https")) {
                            String string13 = String.valueOf(string12);
                            throw new IOException(string13.length() != 0 ? "Unsupported scheme: ".concat(string13) : new String("Unsupported scheme: "));
                        }
                        String string14 = String.valueOf(string11);
                        zzakb.zzck((String)(string14.length() != 0 ? "Redirecting to ".concat(string14) : new String("Redirecting to ")));
                        httpURLConnection.disconnect();
                        continue;
                    }
                    break block42;
                }
                throw new IOException("Too many redirects (20)");
            }
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 instanceof HttpURLConnection && (n8 = httpURLConnection2.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string15 = String.valueOf(Integer.toString(n8));
                string10 = string15.length() != 0 ? "HTTP request failed. Code: ".concat(string15) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection2.getContentLength();
            if (n8 < 0) {
                String string16 = String.valueOf(string2);
                zzakb.zzdk((String)(string16.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string16) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzdbg.remove(string7);
                return false;
            }
            String string17 = zzdbh.format(n8);
            object2 = zznk.zzauy;
            int n10 = (Integer)zzkb.zzik().zzd((zzna)object2);
            if (n8 > n10) {
                zzakb.zzdk((String)new StringBuilder(33 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Content length ").append(string17).append(" exceeds limit at ").append(string2).toString());
                String string18 = String.valueOf(string17);
                String string19 = string18.length() != 0 ? "File too big for full file cache. Size: ".concat(string18) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string19);
                zzdbg.remove(string7);
                return false;
            }
            zzakb.zzck((String)new StringBuilder(20 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Caching ").append(string17).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection2.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            Clock clock = zzbv.zzer();
            int n11 = 0;
            long l = clock.currentTimeMillis();
            object2 = zznk.zzavb;
            long l3 = (Long)zzkb.zzik().zzd((zzna)object2);
            zzamj zzamj2 = new zzamj(l3);
            object2 = zznk.zzava;
            long l4 = (Long)zzkb.zzik().zzd((zzna)object2);
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n11 += n7) > n10) {
                    string9 = "sizeExceeded";
                    String string20 = String.valueOf(Integer.toString(n11));
                    string10 = string20.length() != 0 ? "File too big for full file cache. Size: ".concat(string20) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (clock.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string21 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string21).length()).append("Timeout exceeded. Limit: ").append(string21).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzdbj) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzamj2.tryAcquire()) continue;
                n = n8;
                int n12 = n11;
                object = file.getAbsolutePath();
                String string22 = string2;
                object2 = this;
                zzamu.zzsy.post((Runnable)new zzaqi((zzaqh)object2, string22, (String)object, n12, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzakb.isLoggable((int)3)) {
                String string23 = zzdbh.format(n11);
                zzakb.zzck((String)new StringBuilder(22 + String.valueOf(string23).length() + String.valueOf(string2).length()).append("Preloaded ").append(string23).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n11);
            zzdbg.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzbv.zzeo().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzdbj) {
                zzakb.zzdj((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzakb.zzc((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string24 = String.valueOf(file.getAbsolutePath());
                zzakb.zzdk((String)(string24.length() != 0 ? "Could not delete partial cache file at ".concat(string24) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzdbg.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzdbj = true;
    }

    private final File zzc(File file) {
        return new File(this.zzdbi, String.valueOf(file.getName()).concat(".done"));
    }
}

