/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.gmsg.zzv;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzams;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzapi;
import com.google.android.gms.internal.ads.zzapn;
import com.google.android.gms.internal.ads.zzapv;
import com.google.android.gms.internal.ads.zzapw;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzadh
public final class zzaqc
implements zzv<zzapw> {
    private boolean zzdau;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzkb.zzif();
                n2 = zzamu.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzakb.zzdk((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzapi zzapi2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzakb.zzdk((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Object object2;
        Object object3;
        Map map2 = map;
        zzapw zzapw2 = (zzapw)object;
        zzaqc zzaqc2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzakb.zzdk((String)"Action missing from video GMSG.");
            return;
        }
        if (zzakb.isLoggable((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzakb.zzck((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzakb.zzdk((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzapw2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzakb.zzdk((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzakb.zzdk((String)"No MIME types specified for decoder properties inspection.");
                zzapi.zza(zzapw2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzakb.zzdk((String)"Video decoder properties available on API versions >= 16.");
                zzapi.zza(zzapw2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzams.zzdd(string3.trim()));
            }
            zzapi.zza(zzapw2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzapw2.zztl();
        if (object3 == null) {
            zzakb.zzdk((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzapw2.getContext();
            int n2 = zzaqc.zza(context, map2, "x", 0);
            int n3 = zzaqc.zza(context, map2, "y", 0);
            int n4 = zzaqc.zza(context, map2, "w", -1);
            int n5 = zzaqc.zza(context, map2, "h", -1);
            zzna zzna2 = zznk.zzbca;
            if (((Boolean)zzkb.zzik().zzd(zzna2)).booleanValue()) {
                n4 = Math.min(n4, zzapw2.zzts() - n2);
                n5 = Math.min(n5, zzapw2.zztr() - n3);
            }
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzapn)object3).zzth() == null) {
                zzapv zzapv2 = new zzapv((String)map2.get("flags"));
                ((zzapn)object3).zza(n2, n3, n4, n5, n, bl3, zzapv2);
                zzapi zzapi2 = ((zzapn)object3).zzth();
                if (zzapi2 != null) {
                    zzaqc.zza(zzapi2, map2);
                }
                return;
            }
            ((zzapn)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzapi zzapi3 = ((zzapn)object3).zzth();
        if (zzapi3 == null) {
            zzapi.zza(zzapw2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzapw2.getContext();
            int n = zzaqc.zza(context, map2, "x", 0);
            int n6 = zzaqc.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzapi3.zzf(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = (String)map2.get("time");
            if (string4 == null) {
                zzakb.zzdk((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzapi3.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzakb.zzdk((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzapi3.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzapi3.zzta();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzaqc.zza(zzapi3, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzapi3.zztb();
                return;
            }
            zzapi3.zztc();
            return;
        }
        if ("pause".equals(string2)) {
            zzapi3.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzapi3.play();
            return;
        }
        if ("show".equals(string2)) {
            zzapi3.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzapi3.zzdn((String)map2.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzapw2.getContext();
            int n = zzaqc.zza(context, map2, "dx", 0);
            int n7 = zzaqc.zza(context, map2, "dy", 0);
            zzapi3.zza(n, n7);
            if (!zzaqc2.zzdau) {
                zzapw2.zznp();
                zzaqc2.zzdau = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = (String)map2.get("volume");
            if (string6 == null) {
                zzakb.zzdk((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzapi3.setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzakb.zzdk((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzapi3.zztd();
            return;
        }
        String string8 = String.valueOf(string2);
        zzakb.zzdk((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

