/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzakb;
import com.google.android.gms.internal.ads.zzapr;
import com.google.android.gms.internal.ads.zzapt;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzadh
@TargetApi(value=14)
public final class zzapu
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzapt {
    private static final float[] zzcyv = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzapr zzcyw;
    private final float[] zzcys;
    private final float[] zzcyx;
    private final float[] zzcyy;
    private final float[] zzcyz;
    private final float[] zzcza;
    private final float[] zzczb;
    private final float[] zzczc;
    private float zzczd;
    private float zzcze;
    private float zzczf;
    private int zzur;
    private int zzuq;
    private SurfaceTexture zzczg;
    private SurfaceTexture zzczh;
    private int zzczi;
    private int zzczj;
    private int zzczk;
    private FloatBuffer zzczl = ByteBuffer.allocateDirect(zzcyv.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzczm;
    private final Object zzczn;
    private EGL10 zzczo;
    private EGLDisplay zzczp;
    private EGLContext zzczq;
    private EGLSurface zzczr;
    private volatile boolean zzczs;
    private volatile boolean zzczt;

    public zzapu(Context context) {
        super("SphericalVideoProcessor");
        this.zzczl.put(zzcyv).position(0);
        this.zzcys = new float[9];
        this.zzcyx = new float[9];
        this.zzcyy = new float[9];
        this.zzcyz = new float[9];
        this.zzcza = new float[9];
        this.zzczb = new float[9];
        this.zzczc = new float[9];
        this.zzczd = Float.NaN;
        this.zzcyw = new zzapr(context);
        this.zzcyw.zza(this);
        this.zzczm = new CountDownLatch(1);
        this.zzczn = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzuq = n;
        this.zzur = n2;
        this.zzczh = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(int n, int n2) {
        Object object = this.zzczn;
        synchronized (object) {
            this.zzuq = n;
            this.zzur = n2;
            this.zzczs = true;
            this.zzczn.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzti() {
        Object object = this.zzczn;
        synchronized (object) {
            this.zzczt = true;
            this.zzczh = null;
            this.zzczn.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zztj() {
        if (this.zzczh == null) {
            return null;
        }
        try {
            this.zzczm.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzczg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzczk;
        Object object = this.zzczn;
        synchronized (object) {
            this.zzczn.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zznn() {
        Object object = this.zzczn;
        synchronized (object) {
            this.zzczn.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzna zzna2;
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl2;
        if (this.zzczh == null) {
            zzakb.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzczm.countDown();
            return;
        }
        zzapu zzapu2 = this;
        this.zzczo = (EGL10)EGLContext.getEGL();
        zzapu2.zzczp = zzapu2.zzczo.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzapu2.zzczp == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzapu2.zzczo.eglInitialize(zzapu2.zzczp, nArray)) {
                bl2 = false;
            } else {
                object2 = zzapu2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                objectArray = new int[1];
                object = ((zzapu)object2).zzczo.eglChooseConfig(((zzapu)object2).zzczp, nArray2, eGLConfigArray, 1, objectArray) && objectArray[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzapu2.zzczq = zzapu2.zzczo.eglCreateContext(zzapu2.zzczp, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzapu2.zzczq == null || zzapu2.zzczq == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzapu2.zzczr = zzapu2.zzczo.eglCreateWindowSurface(zzapu2.zzczp, (EGLConfig)object, (Object)zzapu2.zzczh, null);
                        bl2 = zzapu2.zzczr == null || zzapu2.zzczr == EGL10.EGL_NO_SURFACE ? false : zzapu2.zzczo.eglMakeCurrent(zzapu2.zzczp, zzapu2.zzczr, zzapu2.zzczr, zzapu2.zzczq);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzapu2 = this;
        zzna zzna3 = zzna2 = zznk.zzazp;
        if (!((String)zzkb.zzik().zzd(zzna3)).equals(zzna2.zzja())) {
            zzna3 = zzna2;
            string2 = (String)zzkb.zzik().zzd(zzna3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzapu.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzna3 = zzna2 = zznk.zzazq;
            if (!((String)zzkb.zzik().zzd(zzna3)).equals(zzna2.zzja())) {
                zzna3 = zzna2;
                string3 = (String)zzkb.zzik().zzd(zzna3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzapu.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzapu.zzdo("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzapu.zzdo("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzapu.zzdo("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzapu.zzdo("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzapu.zzdo("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzapu.zzdo("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzapu.zzdo("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzczi = n;
        GLES20.glUseProgram((int)zzapu2.zzczi);
        zzapu.zzdo("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzapu2.zzczi, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzapu2.zzczl);
        zzapu.zzdo("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzapu.zzdo("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzapu.zzdo("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzapu.zzdo("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzapu.zzdo("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzapu.zzdo("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzapu.zzdo("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzapu.zzdo("texParameteri");
        zzapu2.zzczj = GLES20.glGetUniformLocation((int)zzapu2.zzczi, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzapu2.zzczj, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzczi != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzczo.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzakb.e((String)string6);
            zzbv.zzeo().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zztk();
            this.zzczm.countDown();
            return;
        }
        this.zzczg = new SurfaceTexture(n7);
        this.zzczg.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzczm.countDown();
        this.zzcyw.start();
        try {
            this.zzczs = true;
            while (!this.zzczt) {
                zzapu2 = this;
                while (zzapu2.zzczk > 0) {
                    zzapu2.zzczg.updateTexImage();
                    --zzapu2.zzczk;
                }
                if (zzapu2.zzcyw.zza(zzapu2.zzcys)) {
                    if (Float.isNaN(zzapu2.zzczd)) {
                        float[] fArray = zzapu2.zzcys;
                        objectArray = new float[]{0.0f, 1.0f, 0.0f};
                        object2 = zzapu2.zzcys;
                        float[] fArray2 = new float[]{(float)(object2[0] * objectArray[0] + object2[1] * objectArray[1] + object2[2] * objectArray[2]), (float)(object2[3] * objectArray[0] + object2[4] * objectArray[1] + object2[5] * objectArray[2]), (float)(object2[6] * objectArray[0] + object2[7] * objectArray[1] + object2[8] * objectArray[2])};
                        zzapu2.zzczd = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzapu.zzb(zzapu2.zzczb, zzapu2.zzczd + zzapu2.zzcze);
                } else {
                    zzapu.zza(zzapu2.zzcys, -1.5707964f);
                    zzapu.zzb(zzapu2.zzczb, zzapu2.zzcze);
                }
                zzapu.zza(zzapu2.zzcyx, 1.5707964f);
                zzapu.zza(zzapu2.zzcyy, zzapu2.zzczb, zzapu2.zzcyx);
                zzapu.zza(zzapu2.zzcyz, zzapu2.zzcys, zzapu2.zzcyy);
                zzapu.zza(zzapu2.zzcza, zzapu2.zzczf);
                zzapu.zza(zzapu2.zzczc, zzapu2.zzcza, zzapu2.zzcyz);
                GLES20.glUniformMatrix3fv((int)zzapu2.zzczj, (int)1, (boolean)false, (float[])zzapu2.zzczc, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzapu.zzdo("drawArrays");
                GLES20.glFinish();
                zzapu2.zzczo.eglSwapBuffers(zzapu2.zzczp, zzapu2.zzczr);
                if (this.zzczs) {
                    zzapu2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzapu2.zzuq, (int)zzapu2.zzur);
                    zzapu.zzdo("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzapu2.zzczi, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzapu2.zzczi, (String)"uFOVy");
                    if (zzapu2.zzuq > zzapu2.zzur) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzapu2.zzur / (float)zzapu2.zzuq));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzapu2.zzuq / (float)zzapu2.zzur));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzczs = false;
                }
                try {
                    Object object3 = this.zzczn;
                    synchronized (object3) {
                        if (!this.zzczt && !this.zzczs && this.zzczk == 0) {
                            this.zzczn.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzakb.zzdk((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzakb.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzbv.zzeo().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzcyw.stop();
            this.zzczg.setOnFrameAvailableListener(null);
            this.zzczg = null;
            this.zztk();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzuq > this.zzur) {
            f4 = 1.7453293f * f / (float)this.zzuq;
            f3 = 1.7453293f * f2 / (float)this.zzuq;
        } else {
            f4 = 1.7453293f * f / (float)this.zzur;
            f3 = 1.7453293f * f2 / (float)this.zzur;
        }
        this.zzcze -= f4;
        this.zzczf -= f3;
        if (this.zzczf < -1.5707964f) {
            this.zzczf = -1.5707964f;
        }
        if (this.zzczf > 1.5707964f) {
            this.zzczf = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzapu.zzdo("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzapu.zzdo("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzapu.zzdo("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzapu.zzdo("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzapu.zzdo("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zztk() {
        boolean bl = false;
        if (this.zzczr != null && this.zzczr != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzczo.eglMakeCurrent(this.zzczp, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzczo.eglDestroySurface(this.zzczp, this.zzczr);
            this.zzczr = null;
        }
        if (this.zzczq != null) {
            bl |= this.zzczo.eglDestroyContext(this.zzczp, this.zzczq);
            this.zzczq = null;
        }
        if (this.zzczp != null) {
            bl |= this.zzczo.eglTerminate(this.zzczp);
            this.zzczp = null;
        }
        return bl;
    }

    private static void zzdo(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

